<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\ListResource;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class FlexFlowList extends ListResource {
    /**
     * Construct the FlexFlowList
     * 
     * @param Version $version Version that contains the resource
     * @return \Twilio\Rest\FlexApi\V1\FlexFlowList 
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array();

        $this->uri = '/FlexFlows';
    }

    /**
     * Streams FlexFlowInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     * 
     * @param array|Options $options Optional Arguments
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return \Twilio\Stream stream of results
     */
    public function stream($options = array(), $limit = null, $pageSize = null) {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($options, $limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Reads FlexFlowInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     * 
     * @param array|Options $options Optional Arguments
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return FlexFlowInstance[] Array of results
     */
    public function read($options = array(), $limit = null, $pageSize = null) {
        return iterator_to_array($this->stream($options, $limit, $pageSize), false);
    }

    /**
     * Retrieve a single page of FlexFlowInstance records from the API.
     * Request is executed immediately
     * 
     * @param array|Options $options Optional Arguments
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return \Twilio\Page Page of FlexFlowInstance
     */
    public function page($options = array(), $pageSize = Values::NONE, $pageToken = Values::NONE, $pageNumber = Values::NONE) {
        $options = new Values($options);
        $params = Values::of(array(
            'FriendlyName' => $options['friendlyName'],
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ));

        $response = $this->version->page(
            'GET',
            $this->uri,
            $params
        );

        return new FlexFlowPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a specific page of FlexFlowInstance records from the API.
     * Request is executed immediately
     * 
     * @param string $targetUrl API-generated URL for the requested results page
     * @return \Twilio\Page Page of FlexFlowInstance
     */
    public function getPage($targetUrl) {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new FlexFlowPage($this->version, $response, $this->solution);
    }

    /**
     * Create a new FlexFlowInstance
     * 
     * @param string $friendlyName Human readable description of this FlexFlow
     * @param string $chatServiceSid Service Sid.
     * @param string $channelType Channel type
     * @param array|Options $options Optional Arguments
     * @return FlexFlowInstance Newly created FlexFlowInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create($friendlyName, $chatServiceSid, $channelType, $options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'FriendlyName' => $friendlyName,
            'ChatServiceSid' => $chatServiceSid,
            'ChannelType' => $channelType,
            'ContactIdentity' => $options['contactIdentity'],
            'Enabled' => Serialize::booleanToString($options['enabled']),
            'IntegrationType' => $options['integrationType'],
            'Integration.FlowSid' => $options['integrationFlowSid'],
            'Integration.Url' => $options['integrationUrl'],
            'Integration.WorkspaceSid' => $options['integrationWorkspaceSid'],
            'Integration.WorkflowSid' => $options['integrationWorkflowSid'],
            'Integration.Channel' => $options['integrationChannel'],
            'Integration.Timeout' => $options['integrationTimeout'],
            'Integration.Priority' => $options['integrationPriority'],
            'Integration.CreationOnMessage' => Serialize::booleanToString($options['integrationCreationOnMessage']),
            'LongLived' => Serialize::booleanToString($options['longLived']),
        ));

        $payload = $this->version->create(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new FlexFlowInstance($this->version, $payload);
    }

    /**
     * Constructs a FlexFlowContext
     * 
     * @param string $sid The unique ID of the FlexFlow
     * @return \Twilio\Rest\FlexApi\V1\FlexFlowContext 
     */
    public function getContext($sid) {
        return new FlexFlowContext($this->version, $sid);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.FlexApi.V1.FlexFlowList]';
    }
}