<?php

function liquid_vc_page_templates() {
	
	$sections_uri = get_template_directory_uri() . '/liquid/assets/img/liquid-templates/sections/';
	$pages_uri = get_template_directory_uri() . '/liquid/assets/img/liquid-templates/pages/';
	$templates = array();

	/*###################
		Page TEMPLATES
	###################*/
	//Darkapp
	$data = array();
	$data['name'] = esc_html__( 'Dark App', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'darkapp-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:60px|padding_bottom_small:60px" css=".vc_custom_1607342656970{padding-top: 70px !important;padding-bottom: 30px !important;}"][vc_column width="7/12" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_origin_x="0%" ca_an_opacity="1" ca_duration="2000" ca_delay="180" ca_init_translate_y="100" ca_init_rotate_y="15" ca_init_rotate_x="0" ca_init_translate_x="0" responsive_align="text-center text-sm-left"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" margin="bottom_small:1.15em" color="rgba(255, 255, 255, 0.75)"]<img class="alignnone size-full wp-image-31" src="https://darkapp.liquid-themes.com/wp-content/uploads/2020/10/Group-28148.svg" alt="Image" />  Introducing Reminder Tools[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" fs="text_large:86px|text_medium:7vw|text_small:13vw" lh="text_small:1em" margin="right_all:5%25|bottom_small:0.3em" padding="right_large:0px|left_large:0px|right_medium:1vw|left_medium:1vw"]E-wallet in your pocket 🤑[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:20px|text_medium:22px|text_small:18px" lh="text_small:1.5em"]Preferred stock may be hybrid by having the qualities of bonds of fixed returns and common stock voting rightson.[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1602597013022{padding-top: 22px !important;}"][vc_column_inner offset="vc_col-md-5" css=".vc_custom_1607342265389{margin-bottom: 15px !important;}"][ld_button style="btn-default" title="Get the app" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="fontawesome" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" fw="700" ls="0.05em" i_icon_fontawesome="fab fa-apple" i_size="23px" i_margin_right="0.85em" css=".vc_custom_1605283164168{padding-right: 0.75em !important;padding-left: 0.75em !important;}" lh="2.5em"][/vc_column_inner][vc_column_inner css=".vc_custom_1607342274637{margin-bottom: 15px !important;}" offset="vc_col-md-6"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" lh="text_small:1em"]Get your tools for free. [ld_br]<br /> For a limited time.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="5/12" column_top_onmobile="yes" align="text-center" offset="vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10" css=".vc_custom_1607342664586{padding-top: 120px !important;}" responsive_css="padding_top_medium:20%25" responsive_align="text-center text-md-left"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" pf_duration="1800" pf_start_delay="1250" pf_delay="180" pf_init_translate_y="35" pf_init_rotate_x="-12"][ld_images_group_element img_size="50%" absolute_pos="yes" image="84" position="top_small:-20%25|right_small:0px|left_small:12px"][/ld_images_group_element][ld_images_group_element img_size="55%" image="85" margin="bottom_large:-10%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column][ld_particles as_bg="yes" absolute_pos="yes" color_type="multi_color" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1605275107996-f48f08c1-2ce5" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="8" multi_color_values="%5B%7B%22scolor%22%3A%22%234cfd89%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%23fdc14c%22%7D%5D" size="4"][/vc_column][/vc_row][vc_row][vc_column][ld_custom_menu source="custom" localscroll="yes" menu_alignment="text-center" sticky="yes" cm_sticky_type="lqd-sticky-menu-floating" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Features%22%2C%22url%22%3A%22%23features%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Connect%22%2C%22url%22%3A%22%23connect%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Pricing%22%2C%22url%22%3A%22%23pricing%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Download%22%2C%22url%22%3A%22%23download%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="46" color="rgb(0, 0, 0)" hcolor="rgb(255, 255, 255)" bg_hcolor="rgb(0, 0, 0)" lh="1.15em" fs="13px"][/vc_column][/vc_row][vc_row gap="2" equal_height="yes" fade_scroll="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" el_id="features" css=".vc_custom_1610621670722{padding-top: 60px !important;padding-bottom: 60px !important;}" ca_duration="1000" ca_delay="90"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" css=".vc_custom_1605256828929{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:62px" margin="bottom_small:0.25em" lh="text_small:1em"]Automate all your payments.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.5em"]Focused on providing smart, affordable and convenient mobility solutions. Use customer data to build.[/ld_fancy_heading][ld_spacer][/vc_column][vc_column width="1/2" css=".vc_custom_1610620429265{padding-top: 15px !important;padding-right: 15px !important;padding-bottom: 5px !important;padding-left: 15px !important;background-color: #1c1c1e !important;}" offset="vc_col-md-4" responsive_css="padding_top_medium:30px|padding_right_medium:5px|padding_bottom_medium:5px|padding_left_medium:5px"][ld_icon_box i_type="image" heading_size="xs" i_size="xl" alignment="text-left" fill="yes" i_icon_image="212" title="Multi Platform" icon_mb="30" fill_color="rgb(28, 28, 30)" css=".vc_custom_1610619772861{margin-bottom: 6px !important;}" custom_size="35px" title_mb="0"]Adjust responsive spacing, change font size, hide sections on specific devices.[/ld_icon_box][/vc_column][vc_column width="1/2" responsive_css="padding_top_medium:30px|padding_right_medium:5px|padding_bottom_medium:5px|padding_left_medium:5px" css=".vc_custom_1610620439513{padding-top: 15px !important;padding-right: 15px !important;padding-bottom: 5px !important;padding-left: 15px !important;background-color: #1c1c1e !important;}" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" i_size="xl" alignment="text-left" fill="yes" i_icon_image="213" title="Verified Payments" icon_mb="30" fill_color="rgb(28, 28, 30)" css=".vc_custom_1610619826886{margin-bottom: 6px !important;}" custom_size="40px"]Adjust responsive spacing, change font size, hide sections on specific devices.[/ld_icon_box][/vc_column][vc_column width="1/2" responsive_css="padding_top_medium:30px|padding_right_medium:5px|padding_bottom_medium:5px|padding_left_medium:5px" css=".vc_custom_1610620447730{padding-top: 15px !important;padding-right: 15px !important;padding-bottom: 5px !important;padding-left: 15px !important;background-color: #1c1c1e !important;}" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" i_size="xl" alignment="text-left" fill="yes" i_icon_image="216" title="Secure Identification" icon_mb="30" fill_color="rgb(28, 28, 30)" css=".vc_custom_1610619834541{margin-bottom: 6px !important;}" custom_size="40px"]Adjust responsive spacing, change font size, hide sections on specific devices.[/ld_icon_box][/vc_column][vc_column width="1/2" responsive_css="margin_top_medium:5px|padding_top_medium:30px|padding_right_medium:5px|padding_bottom_medium:5px|padding_left_medium:5px" css=".vc_custom_1610620469937{padding-top: 25px !important;padding-right: 15px !important;padding-bottom: 5px !important;padding-left: 15px !important;background-color: #1c1c1e !important;}" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" i_size="xl" alignment="text-left" fill="yes" i_icon_image="214" title="Daily Reports" icon_mb="30" fill_color="rgb(28, 28, 30)" css=".vc_custom_1610619841671{margin-bottom: 6px !important;}" custom_size="40px"]Adjust responsive spacing, change font size, hide sections on specific devices.[/ld_icon_box][/vc_column][vc_column width="1/2" responsive_css="margin_top_medium:5px|padding_top_medium:30px|padding_right_medium:5px|padding_bottom_medium:5px|padding_left_medium:5px" css=".vc_custom_1610620493108{padding-top: 25px !important;padding-right: 15px !important;padding-bottom: 5px !important;padding-left: 15px !important;background-color: #1c1c1e !important;}" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" i_size="lg" alignment="text-left" fill="yes" i_icon_image="216" title="Secure Cloud Data" icon_mb="25" fill_color="rgb(28, 28, 30)" css=".vc_custom_1610620822812{margin-bottom: 6px !important;}" custom_size="40px"]Adjust responsive spacing, change font size, hide sections on specific devices.[/ld_icon_box][/vc_column][vc_column width="1/2" responsive_css="margin_top_medium:5px|padding_top_medium:30px|padding_right_medium:5px|padding_bottom_medium:5px|padding_left_medium:5px" css=".vc_custom_1610620488345{padding-top: 25px !important;padding-right: 15px !important;padding-bottom: 5px !important;padding-left: 15px !important;background-color: #1c1c1e !important;}" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" i_size="xl" alignment="text-left" fill="yes" i_icon_image="214" title="Daily Reports" icon_mb="30" fill_color="rgb(28, 28, 30)" css=".vc_custom_1610619841671{margin-bottom: 6px !important;}" custom_size="40px"]Adjust responsive spacing, change font size, hide sections on specific devices.[/ld_icon_box][/vc_column][/vc_row][vc_row el_id="screenshot" css=".vc_custom_1610621677167{padding-top: 5vh !important;padding-bottom: 10vh !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="power2.in" translate_from_y="180" translate_to_y="-250" rotate_to_z="0" rotate_from_z="0" parallax_duration="+=50%"][ld_fancy_heading tag="h2" parallax="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0.9" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="top top" use_custom_fonts_title="true" enable_split="true" color="rgb(139, 139, 139)" fs="text_large:55px|text_medium:48px|text_small:10vw" lh="text_small:1em" fw="text_small:700" ca_init_translate_y="80" ca_init_rotate_z="2"]🏦 <span style="color: #ffffff;">Pre-market.</span> Preferred stock may be hybrid by having the qualities of bonds of fixed returns and common stock voting rightson.[/ld_fancy_heading][/vc_column][/vc_row][vc_row fade_scroll="yes" responsive_css="padding_top_large:10vh|padding_bottom_large:10vh"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="power3.in" translate_from_y="100" translate_to_y="-100" rotate_to_z="0" rotate_from_z="0" parallax_duration="+=50%"][ld_fancy_heading tag="h2" parallax="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0.9" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="center center" use_custom_fonts_title="true" enable_split="true" color="rgb(139, 139, 139)" fs="text_large:55px|text_medium:48px|text_small:10vw" lh="text_small:1em" fw="text_small:700" ca_init_translate_y="80" ca_init_rotate_z="2"]💶 <span style="color: #ffffff;">Stock exchange.</span> Lets investors recoup the initial investment plus capital gains from subsequent rises in stock price.[/ld_fancy_heading][/vc_column][/vc_row][vc_row fade_scroll="yes" css=".vc_custom_1610570152432{padding-top: 10vh !important;padding-bottom: 20vh !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="power4.in" translate_from_y="100" translate_to_y="-170" rotate_to_z="0" rotate_from_z="0" parallax_duration="+=50%"][ld_fancy_heading tag="h2" parallax="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0.9" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="center center" use_custom_fonts_title="true" enable_split="true" color="rgb(139, 139, 139)" fs="text_large:55px|text_medium:48px|text_small:10vw" lh="text_small:1em" fw="text_small:700" ca_init_translate_y="80" ca_init_rotate_z="2"]💬 <span style="color: #ffffff;">Next‑generation security.</span> knows a face when it sees one, and intelligently relights it to capture more natural-looking contours.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" row_scale_bg_onhover="yes" responsive_css="margin_top_large:100px|margin_right_large:10vw|margin_left_large:10vw|margin_right_medium:2vw|margin_left_medium:2vw|padding_top_small:25px" css=".vc_custom_1610621715068{margin-right: 1vw !important;margin-left: 1vw !important;padding-top: 45px !important;padding-bottom: 15px !important;background-color: #1e1f21 !important;border-radius: 10px !important;}" el_id="connect"][vc_column][ld_tabs style="style03" nav_alignment="justify-content-md-center" tab_trigger="hover" use_custom_fonts_nav="true" primary_color="rgba(255, 255, 255, 0.1)" text_color="rgba(255, 255, 255, 0.25)" text_hcolor="rgb(255, 255, 255)" primary_hcolor="rgb(94, 85, 255)" fs="16px" lh="1em"][ld_tab_section title="Buy Stock" tab_id="lqd-1605277170632-fe1c2a8e-b8e3"][vc_row_inner content_placement="middle" css=".vc_custom_1605276852705{padding-top: 40px !important;}"][vc_column_inner offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" css=".vc_custom_1605277066426{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:500" margin="bottom_small:1.5em"]— 890m Transactions Completed[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:61px|text_small:12vw" lh="text_small:1em" margin="bottom_small:0.35em"]Buy Pre-market Tech Stocks.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:1.36em" margin="bottom_small:1.5em"]Preferred stock may be hybrid by having the qualities of bonds of fixed returns and common stock voting rightson.[/ld_fancy_heading][ld_button style="btn-default" title="Get the app" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-sm" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="fontawesome" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" fw="700" ls="0.05em" i_icon_fontawesome="fab fa-apple" i_size="23px" i_margin_right="0.85em" css=".vc_custom_1610622994657{padding-right: 0.75em !important;padding-left: 0.75em !important;}" lh="2.5em"][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-lg-3 vc_col-md-offset-1 vc_col-md-4 vc_col-xs-10" responsive_align="text-center"][vc_single_image image="116" alignment="center"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Sell Stock" tab_id="lqd-1605276082976-6dd252f5-cbda"][vc_row_inner content_placement="middle" css=".vc_custom_1605276852705{padding-top: 40px !important;}"][vc_column_inner offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" css=".vc_custom_1605277066426{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:500" margin="bottom_small:1.5em"]— 890m Transactions Completed[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:61px|text_small:12vw" lh="text_small:1em" margin="bottom_small:0.35em"]Connect your Apple Card.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:1.36em" margin="bottom_small:1.5em"]Preferred stock may be hybrid by having the qualities of bonds of fixed returns and common stock voting rightson.[/ld_fancy_heading][ld_button style="btn-default" title="Get the app" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-sm" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="fontawesome" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" fw="700" ls="0.05em" i_icon_fontawesome="fab fa-apple" i_size="23px" i_margin_right="0.85em" css=".vc_custom_1610622994657{padding-right: 0.75em !important;padding-left: 0.75em !important;}" lh="2.5em"][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-lg-3 vc_col-md-offset-1 vc_col-md-4 vc_col-xs-10" responsive_align="text-center"][vc_single_image image="116" alignment="center"][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row][vc_row css=".vc_custom_1605278329873{padding-top: 120px !important;}" el_id="pricing"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" css=".vc_custom_1605519505752{margin-bottom: 12px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:62px" margin="bottom_small:0.25em" lh="text_small:1em"]Simple Pricing[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.5em"]Preferred stock may be hybrid by having the qualities of bonds of fixed returns and common stock voting rightson.[/ld_fancy_heading][/vc_column][vc_column][ld_tabs style="style09c" nav_alignment="justify-content-md-center" use_custom_fonts_nav="true" nav_bg_color="rgb(33, 34, 34)" primary_hcolor="rgb(23, 23, 23)" fs="14px" lh="1em"][ld_tab_section title="Monthly" tab_id="lqd-1605513973187-1776c30b-d096"][vc_row_inner gap="0"][vc_column_inner enable_link="enable_column_link" width="1/2" link="url:%23|||"][ld_price_table template="style03b" show_button="yes" pt_style="btn-naked" pt_title="Join basic plan" pt_i_type="linea" pt_i_hover_reveal="btn-hover-reveal" pt_i_add_icon="true" title="Basic plan" description="Preferred stock may be hybrid by having the qualities of bonds of fixed returns." price="£6.90 <small>/year</small>" accent_color="rgb(94, 85, 255)" pt_i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" pt_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" pt_css=".vc_custom_1610181634565{background-color: rgba(0,0,0,0.01) !important;*background-color: rgb(0,0,0) !important;}" border_color="rgb(38, 38, 38)" desc_color="rgba(255, 255, 255, 0.5)" price_color="rgb(255, 255, 255)" bg_color="rgba(255, 255, 255, 0)" pt_hover_color="rgb(94, 85, 255)"]</p> <ul> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Live Stock Updates</span></li> <li><span style="color: rgba(255, 255, 255, 0.3);">- <i class="lqd-icn-ess"></i> Access to Pre and After Markets</span></li> <li>- <i class="lqd-icn-ess"></i><span style="color: rgba(255, 255, 255, 0.3);"> Secure Data Connection</span></li> </ul> <p>[/ld_price_table][/vc_column_inner][vc_column_inner enable_link="enable_column_link" width="1/2" responsive_css="margin_left_small:-1px" link="url:%23|||"][ld_price_table template="style03b" featured="yes" featured_tag="yes" show_button="yes" pt_style="btn-naked" pt_title="Join premium plan" pt_i_type="linea" pt_i_hover_reveal="btn-hover-reveal" pt_i_add_icon="true" title="Popular Plan" description="Preferred stock may be hybrid by having the qualities of bonds of fixed returns." price="£12.90 <small>/year</small>" accent_color="rgb(94, 85, 255)" pt_i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" pt_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" pt_css=".vc_custom_1610181670552{background-color: rgba(0,0,0,0.01) !important;*background-color: rgb(0,0,0) !important;}" border_color="rgb(38, 38, 38)" desc_color="rgba(255, 255, 255, 0.5)" price_color="rgb(255, 255, 255)" bg_color="rgba(255, 255, 255, 0)" pt_hover_color="rgb(94, 85, 255)" featured_label="Save 20%" featured_txt_color="rgb(255, 255, 255)"]</p> <ul> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Live Stock Updates</span></li> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Access to Pre and After Markets</span></li> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Secure Data Connection</span></li> <li style="list-style-type: none;"></li> </ul> <p>[/ld_price_table][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Annual - Save 40%" tab_id="lqd-1605520608121-cb1d25f7-9a98"][vc_row_inner gap="0"][vc_column_inner enable_link="enable_column_link" width="1/2" link="url:%23|||"][ld_price_table template="style03b" show_button="yes" pt_style="btn-naked" pt_title="Join basic plan" pt_i_type="linea" pt_i_hover_reveal="btn-hover-reveal" pt_i_add_icon="true" title="Basic plan" description="Preferred stock may be hybrid by having the qualities of bonds of fixed returns." price="£66.90 <small>/year</small>" accent_color="rgb(94, 85, 255)" pt_i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" pt_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" pt_css=".vc_custom_1610570414937{background-color: rgba(0,0,0,0.01) !important;*background-color: rgb(0,0,0) !important;}" border_color="rgb(38, 38, 38)" desc_color="rgba(255, 255, 255, 0.5)" price_color="rgb(255, 255, 255)" bg_color="rgba(255, 255, 255, 0)" pt_hover_color="rgb(94, 85, 255)"]</p> <ul> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Live Stock Updates</span></li> <li><span style="color: rgba(255, 255, 255, 0.3);">- <i class="lqd-icn-ess"></i> Access to Pre and After Markets</span></li> <li>- <i class="lqd-icn-ess"></i><span style="color: rgba(255, 255, 255, 0.3);"> Secure Data Connection</span></li> </ul> <p>[/ld_price_table][/vc_column_inner][vc_column_inner enable_link="enable_column_link" width="1/2" responsive_css="margin_left_small:-1px" link="url:%23|||"][ld_price_table template="style03b" featured="yes" featured_tag="yes" show_button="yes" pt_style="btn-naked" pt_title="Join premium plan" pt_i_type="linea" pt_i_hover_reveal="btn-hover-reveal" pt_i_add_icon="true" title="Popular Plan" description="Preferred stock may be hybrid by having the qualities of bonds of fixed returns." price="£82.90 <small>/year</small>" accent_color="rgb(94, 85, 255)" pt_i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" pt_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" pt_css=".vc_custom_1610570408494{background-color: rgba(0,0,0,0.01) !important;*background-color: rgb(0,0,0) !important;}" border_color="rgb(38, 38, 38)" desc_color="rgba(255, 255, 255, 0.5)" price_color="rgb(255, 255, 255)" bg_color="rgba(255, 255, 255, 0)" pt_hover_color="rgb(94, 85, 255)" featured_label="Save 40%" featured_txt_color="rgb(255, 255, 255)"]</p> <ul> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Live Stock Updates</span></li> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Access to Pre and After Markets</span></li> <li><span style="color: #ffffff;"><i class="lqd-icn-ess icon-ion-ios-checkmark"></i>Secure Data Connection</span></li> <li style="list-style-type: none;"></li> </ul> <p>[/ld_price_table][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][vc_column offset="vc_col-md-offset-4 vc_col-md-4" responsive_align="text-center"][ld_icon_box i_type="image" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" items_alignment="align-items-center" i_icon_image="119" title="Les services de paiement sont disponibles via des applications mobiles et de bureau." title_mb="1" custom_heading_size="14px" h_color="rgba(167, 167, 167, 0.55)" icon_mb="20" custom_size="30px"][/ld_icon_box][/vc_column][/vc_row][vc_row content_placement="middle" bg_position="center top" css=".vc_custom_1605278322098{padding-top: 65px !important;padding-bottom: 35px !important;background-image: url(https://darkapp.liquid-themes.com/wp-content/uploads/2020/11/bg-circles.svg?id=120) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="download"][vc_column offset="vc_col-lg-5 vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605283182083{margin-bottom: 35px !important;}"][ld_images_group_element image="121" margin="bottom_small:20px"][/ld_images_group_element][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22easy%20%F0%9F%A4%91%22%7D%2C%7B%22word%22%3A%22secure%20%F0%9F%92%B6%22%7D%2C%7B%22word%22%3A%22public%20%F0%9F%8F%A6%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:61px|text_small:12vw" lh="text_small:1em" margin="bottom_small:0.25em"]E-Stock trading made[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.5em"]All in one  and startup solutions. Endless use-cases that make it highly[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1602597013022{padding-top: 22px !important;}"][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1605278083336{margin-bottom: 15px !important;}"][ld_button style="btn-default" title="Get the app" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="fontawesome" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" fw="700" ls="0.05em" i_icon_fontawesome="fab fa-apple" i_size="23px" i_margin_right="0.85em" css=".vc_custom_1605283164168{padding-right: 0.75em !important;padding-left: 0.75em !important;}" lh="2.5em"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1602594290870{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" lh="text_small:1em"]Get your tools for free. [ld_br]<br /> For a limited time.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-1 vc_col-md-5 vc_col-xs-10"][ld_images_group_element enable_hover3d="yes" image="124"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Barber
	$data = array();
	$data['name'] = esc_html__( 'Barber', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'barber-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" enable_slideshow_bg="yes" slideshow_images="155,156" bg_attachment="fixed" enable_overlay="yes" enable_row_dividers="yes" enable_loading_bg="yes" css=".vc_custom_1610355277015{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(https://barber.liquid-themes.com/staging/wp-content/uploads/2020/03/barber-slide-1_2x-scaled_b590a2c2e8ef2da9b9d2f62b8155a2a0.jpg?id=155) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" row_svg_divider="top_shape_height:0|bottom_shape_type:11|bottom_shape_color:%23fffdf8|bottom_shape_height:86" overlay_bg="rgba(0, 0, 0, 0.31)" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:60px|padding_bottom_small:60px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" ca_start_delay="250" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="11px" margin="bottom_small:2em" fw="700" ls="0.2em"]Enjoy Your Haircut[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading transform="text-uppercase" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="44" fs="text_medium:53px|text_small:9vw" lh="text_small:1.33em" fw="text_small:900" ca_init_translate_y="71"]NYC’s Favourite Barber Shop.[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="14px" fw="700" ls="2px"]14th St, SOHO, NYC. APPOINTMENT: +123 456 789[/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-solid" title="Book Appointment" transformation="text-uppercase" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="11px" ls="0.15em"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" el_id="scroll-down-link-container" ca_duration="1800" ca_start_delay="1000" ca_delay="180" ca_init_translate_y="40" responsive_align="text-center"][ld_button style="btn-naked" link_type="scroll_to_section" i_type="linea" i_position="bottom" i_shape="btn-icon-round" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-md" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" i_size="18px" i_color="rgb(0, 0, 0)" i_fill_color="rgb(255, 255, 255)" i_hcolor="rgb(255, 255, 255)" i_fill_hcolor="rgb(0, 0, 0)"][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1603097323845{padding-top: 60px !important;padding-bottom: 30px !important;}" el_id="about" responsive_css="padding_top_medium:130px|padding_bottom_medium:65px|padding_top_small:70px|padding_bottom_small:40px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_x="-50"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(122, 118, 100)" fs="11px" margin="bottom_small:2em" fw="700" ls="0.2em"]Meet Alex[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" padding="right_large:22%25" ca_init_translate_y="70"]Boston’s favorite hair stylist.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true"]Hold ourselves at the standard shaving of perfection in the barber special. Service and top-notch barbers, have the ability to consistently deals field and brow a diverse client base in London.[/ld_fancy_heading][ld_spacer height="12px"][ld_button style="btn-underlined" title="Book appointment" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" fs="10px" lh="1.5em" ls="0.125em" css=".vc_custom_1595406272654{padding-top: 1em !important;padding-right: 0.5em !important;padding-bottom: 1em !important;padding-left: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-round-forward" color="rgb(37, 37, 37)" hover_color="rgb(26, 26, 26)" i_size="21px"][ld_spacer][/vc_column][vc_column align="text-center" offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs" responsive_align="text-center"][ld_images_group_container][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="154" translate_from_y="25" translate_to_y="-95" margin="left_small:40%25"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="60" margin="top_small:-40px" translate_from_y="40" translate_to_y="-80" position="right_small:-150px" shadow_delay="300"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="59" margin="top_small:-18%25|left_small:-60%25" translate_from_y="80" translate_to_y="-120" shadow_delay="400"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row][vc_row gap="25" equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1612169894789{padding-top: 35px !important;padding-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="1" el_id="services" responsive_css="padding_bottom_medium:120px|padding_bottom_small:70px"][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="custom" i_size="xl" alignment="text-left" i_icon_image="27" title="Beard Scultping" title_mb="18" custom_heading_size="15px" icon_mb="35" custom_size="45px"]Traditional men’s beard and haircut. Using clippers and scissors by a barber.[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="custom" i_size="xl" alignment="text-left" i_icon_image="26" title="Shaving" title_mb="18" custom_heading_size="15px" icon_mb="35" custom_size="48px"]Shaving starting from either skin, double zero or beard haircut zero.[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="custom" i_size="xl" alignment="text-left" i_icon_image="119" title="Hair Care Products" title_mb="18" custom_heading_size="15px" icon_mb="35" custom_size="43px"]A service for short beards/stubble haircut by clippers and shaving.[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="custom" i_size="xl" alignment="text-left" i_icon_image="36" title="Hair Styling" title_mb="18" custom_heading_size="15px" icon_mb="35" custom_size="65px"]A service for longer and more styled beards double haircut on the close skin.[/ld_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" row_hide="hidden-xs hidden-sm"][vc_column offset="vc_col-md-4"][ld_flipbox direction="ld-flipbox-tb" shadow="ld-flipbox-shadow-onhover" bg_image="62"][ld_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1575638060492{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column_inner align="text-center" responsive_align="text-center"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:1em"]Stylish Haircut[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0.25em"]£90[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_button style="btn-solid" title="Learn more" transformation="text-uppercase" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="11px" ls="0.15em"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column align="text-center" offset="vc_col-md-4" responsive_align="text-center"][ld_flipbox direction="ld-flipbox-tb" shadow="ld-flipbox-shadow-onhover" bg_image="61"][ld_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1575638060492{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column_inner][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:1em"]Face Shave[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0.25em"]£40[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_button style="btn-solid" title="Learn more" transformation="text-uppercase" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="11px" ls="0.15em"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column align="text-center" offset="vc_col-md-4" responsive_align="text-center"][ld_flipbox direction="ld-flipbox-tb" shadow="ld-flipbox-shadow-onhover" bg_image="58"][ld_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1575638060492{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column_inner][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:1em"]Facial Cleansing[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0.25em"]£30[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_button style="btn-solid" title="Learn more" transformation="text-uppercase" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="11px" ls="0.15em"][/ld_flipbox_section][/ld_flipbox][/vc_column][/vc_row][vc_row gap="30" css=".vc_custom_1612795934473{padding-top: 100px !important;padding-bottom: 50px !important;background-color: #191919 !important;}" el_id="pricing"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1575632945266{margin-bottom: 40px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="13px" margin="bottom_small:1em"]Quality First[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1600" delay="350" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" ca_init_translate_y="70"]Our Pricing[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-6 vc_col-xs-6"][vc_row_inner content_placement="middle" css=".vc_custom_1575633407099{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Japanese Haircut[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]21[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Face Shave[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_align="text-sm-right" offset="vc_col-md-3"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]33[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Shave w/ Facial Skin Cleansing[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]17[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Head Spa[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]11[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Facial and Eyebrow Waxing[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]18[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" offset="vc_col-md-6 vc_col-xs-6"][vc_row_inner content_placement="middle" css=".vc_custom_1575633407099{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Head Spa[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]36[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Facial Skin Cleansing[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_align="text-sm-right" offset="vc_col-md-3"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]26[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Traditional Hair Styling[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]72[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Face Shave[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]11[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle" css=".vc_custom_1575633417276{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 25px !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-bottom-style: solid !important;}"][vc_column_inner width="3/4"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="15px"]Japanese Haircut[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4" responsive_align="text-sm-right"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(150, 150, 150)" fs="15px"]22[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" css=".vc_custom_1575633824432{padding-top: 70px !important;}" responsive_align="text-center"][ld_button style="btn-default" title="Book appointment" transformation="text-uppercase" size="btn-lg" border="border-thicker" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="10px" lh="1.5em" ls="0.125em" css=".vc_custom_1595333034437{padding-top: 1em !important;padding-right: 0.5em !important;padding-bottom: 1em !important;padding-left: 0.5em !important;}" htext_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1595348344118{padding-top: 50px !important;padding-right: 10px !important;padding-bottom: 50px !important;padding-left: 10px !important;background-color: #191919 !important;}" el_id="lqd-gallery" responsive_css="padding_right_medium:50px|padding_left_medium:50px"][vc_column][ld_media columns_gap="15" bottom_gap="30" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="lqd-1575634066049-29fc854e-3303" pf_delay="130" pf_init_translate_y="-1" pf_duration="1800"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="66" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="68" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="70" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="72" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/1" image="64" offset="vc_col-md-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="63" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="65" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="67" offset="vc_col-md-3 vc_col-xs-6"][ld_media_element link_type="image" add_icon="yes" icon_type="plus" width="1/2" image="69" offset="vc_col-md-3 vc_col-xs-6"][/ld_media][/vc_column][/vc_row][vc_row equal_height="yes" css=".vc_custom_1596223143045{padding-top: 60px !important;padding-bottom: 15px !important;}" responsive_css="padding_top_medium:130px|padding_top_small:70px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(122, 118, 100)" fs="11px" margin="bottom_small:2em" fw="700" ls="0.2em"]Our Barbers[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="70"]Hair Stylists[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true"]Hold ourselves at the standard shaving of perfection in the barber special double zero cut.[/ld_fancy_heading][ld_spacer height="22px"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" equal_height="yes"][vc_column width="1/2" offset="vc_col-md-3"][ld_team_member template="style05" image="124" name="Jamie Vox" position="Hair Stylist" socials="%5B%7B%22network%22%3A%22fa-behance%22%7D%5D" accent_color="linear-gradient(0deg, rgba(0, 0, 0, 0.9) 0%, rgba(0, 0, 0, 0) 80.2547770700637%)" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.6)"][/ld_team_member][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_team_member template="style05" image="125" name="Rob Kye" position="Beard Stylist" socials="%5B%7B%22network%22%3A%22fa-behance%22%7D%5D" accent_color="linear-gradient(0deg, rgba(0, 0, 0, 0.9) 0%, rgba(0, 0, 0, 0) 80.2547770700637%)" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.6)"][/ld_team_member][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_team_member template="style05" image="126" name="Erik Genie" position="Hair Stylist" socials="%5B%7B%22network%22%3A%22fa-behance%22%7D%5D" accent_color="linear-gradient(0deg, rgba(0, 0, 0, 0.9) 0%, rgba(0, 0, 0, 0) 80.2547770700637%)" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.6)"][/ld_team_member][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_team_member template="style05" image="127" name="Jack Dan" position="Hair Stylist" socials="%5B%7B%22network%22%3A%22fa-behance%22%7D%5D" accent_color="linear-gradient(0deg, rgba(0, 0, 0, 0.9) 0%, rgba(0, 0, 0, 0) 80.2547770700637%)" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.6)"][/ld_team_member][/vc_column][/vc_row][vc_row enable_overlay="yes" css=".vc_custom_1583755466862{padding-bottom: 110px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_css="padding_bottom_medium:110px" overlay_bg="rgba(255, 255, 255, 0.76)"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_images_group_element image="89" position="top_small:65px"][/ld_images_group_element][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(122, 118, 100)" fs="11px" margin="bottom_small:2em" fw="700" ls="0.2em"]Testimonials[/ld_fancy_heading][ld_fancy_heading alignment="text-center" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="text_small:33px" lh="text_small:1.33em" ca_init_translate_y="70"]Hear from our buddies.[/ld_fancy_heading][ld_spacer][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" navarrow="6" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-top" prevoffset="-150px" nextoffset="-150px"][ld_carousel_section title="Tab" tab_id="lqd-1595406417906-accc0f08-7be7"][vc_row_inner css=".vc_custom_1575635408408{margin-bottom: 25px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="27px" margin="bottom_small:1em" color="rgb(0, 0, 0)"]"I love the way they shave the beard!" It is a standard shaving of perfection in the barber special. Service and top-notch barbers, have the ability to consistently deals field in London."[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(100, 74, 52)" fs="10px" ls="0.075em" fw="700"]Jack from Harlem[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595406575959-6535116b-53f3"][vc_row_inner css=".vc_custom_1575635408408{margin-bottom: 25px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="27px" margin="bottom_small:1em" color="rgb(0, 0, 0)"]"I love the way they shave the beard!" It is a standard shaving of perfection in the barber special. Service and top-notch barbers, have the ability to consistently deals field in London."[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(100, 74, 52)" fs="10px" ls="0.075em" fw="700"]Jack from Harlem[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595406575323-9dfa4b1f-5906"][vc_row_inner css=".vc_custom_1575635408408{margin-bottom: 25px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="27px" margin="bottom_small:1em" color="rgb(0, 0, 0)"]"I love the way they shave the beard!" It is a standard shaving of perfection in the barber special. Service and top-notch barbers, have the ability to consistently deals field in London."[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(100, 74, 52)" fs="10px" ls="0.075em" fw="700"]Jack from Harlem[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595406574165-e927da7a-4067"][vc_row_inner css=".vc_custom_1575635408408{margin-bottom: 25px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="27px" margin="bottom_small:1em" color="rgb(0, 0, 0)"]"I love the way they shave the beard!" It is a standard shaving of perfection in the barber special. Service and top-notch barbers, have the ability to consistently deals field in London."[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(100, 74, 52)" fs="10px" ls="0.075em" fw="700"]Jack from Harlem[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" el_id="contact"][vc_column][ld_google_map style="shadesOfGray" map_marker="custom" si_style="" si_size="" si_border="" zoom="14" map_controls="fullscreenControl" si_scheme="" address="Seba Skate Park" map_height="430px" custom_marker="151"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Music
	$data = array();
	$data['name'] = esc_html__( 'Music', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'music-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="bottom" fade_scroll="yes" enable_slideshow_bg="yes" slideshow_images="4595,4520,4524" enable_overlay="yes" css=".vc_custom_1603704921801{padding-top: 110px !important;padding-bottom: 110px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(0deg, rgb(15,15,20) 2.8662420382165603%, rgba(15, 15, 20, 0.38) 29.006369426751593%, rgba(20,19,26,0) 54.77707006369427%)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1596021144870{margin-bottom: 10vh !important;}" ca_init_rotate_y="64" ca_duration="1400" ca_delay="80" ca_init_translate_y="52" responsive_align="text-center"][ld_fancy_heading transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="68" fs="text_medium:120px|text_small:26vw" compressor="0.6" ls="text_small:0.035em" lh="text_small:1.4em" ca_init_translate_y="0" ca_init_rotate_y="0"]Daniel[ld_br]Mcbride[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-8"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1.2" ca_init_scale_y="1.2" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="800" ca_delay="180" ca_init_translate_y="50" ca_init_rotate_x="-25"][vc_column_inner width="1/3" align="text-center" offset="vc_col-xs-4" responsive_align="text-center"][ld_button style="btn-naked" title="Apple Music" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-y-alt" i_type="fontawesome" i_position="top" i_add_icon="true" i_size="44px" i_margin_bottom="20px" i_color="rgb(255, 255, 255)" text_color="rgba(255, 255, 255, 0.7)" fs="14px" i_icon_fontawesome="fab fa-apple" link="url:%23|||" i_hcolor="rgb(165, 116, 80)"][/vc_column_inner][vc_column_inner width="1/3" align="text-center" offset="vc_col-xs-4" responsive_align="text-center"][ld_button style="btn-naked" title="Spotify" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-y-alt" i_type="fontawesome" i_position="top" i_add_icon="true" i_size="44px" i_margin_bottom="20px" i_color="rgb(255, 255, 255)" text_color="rgba(255, 255, 255, 0.7)" fs="14px" i_icon_fontawesome="fab fa-spotify" i_hcolor="rgb(165, 116, 80)"][/vc_column_inner][vc_column_inner width="1/3" align="text-center" offset="vc_col-xs-4" responsive_align="text-center"][ld_button style="btn-naked" title="Youtube" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-y-alt" i_type="fontawesome" i_position="top" i_add_icon="true" i_size="44px" i_margin_bottom="20px" i_color="rgb(255, 255, 255)" text_color="rgba(255, 255, 255, 0.7)" fs="14px" i_icon_fontawesome="fab fa-youtube" i_hcolor="rgb(165, 116, 80)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1602658984101{padding-bottom: 70px !important;}" responsive_css="margin_bottom_medium:60px|padding_top_medium:120px|padding_bottom_medium:120px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="80" ca_init_translate_x="2" ca_init_translate_y="50" ca_init_rotate_y="50" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]Biography[/ld_fancy_heading][ld_fancy_heading tag="h2" margin="bottom_small:1em"]Derrick's Story[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="21px" lh="1.71em"]Robert attended English-style boarding schools in India from the age of eight and returned to Zanzibar after secondary school. In 1964, his family fled the Zanzibar Revolution. One of Mercury’s former bandmates from the Hectics has said “the only music he listened to, and played, was Western pop music. In addition to working with Michael Jackson, Mercury and Roger Taylor sang on the title track for Billy Squier’s 1982 studio release,[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6"][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_medium:100px|top_small:70%25|right_small:0px"][ld_images_group_element img_size="70%" enable_effects="yes" enable_hover3d="yes" image="4523"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row][vc_row bg_position="right center" enable_overlay="yes" css=".vc_custom_1605626609742{padding-top: 20px !important;padding-bottom: 40px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" el_id="listen" overlay_bg="linear-gradient(0deg, rgb(15,15,20) 0.3184713375796178%, rgba(15, 15, 20, 0.79) 98.72611464968153%)" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1575544994394{margin-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h2"]Latest Releases[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="1.777em"]His solo work was as commercially successful as most debuted in the top 10 of the UK Music Charts.[/ld_fancy_heading][/vc_column][vc_column align="text-center" css=".vc_custom_1579185718022{margin-bottom: 30px !important;}" responsive_align="text-center"][ld_media columns_gap="0" bottom_gap="0" use_custom_fonts_title="true" media_id="1575537484172-f1af07e8-c2eb" fs="17px"][ld_media_element link_type="video" visible_content="yes" image="35" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D1DpH-icPpl0|||" offset="vc_col-md-2 vc_col-xs-6" title="Swagger" subtitle="ft. Alicia"][ld_media_element link_type="video" visible_content="yes" image="36" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DM4ZoCHID9GI|||" offset="vc_col-md-2 vc_col-xs-6" title="River" subtitle="Devia"][ld_media_element link_type="iframe" visible_content="yes" image="37" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F291312051%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||" offset="vc_col-md-2 vc_col-xs-6" title="Soundcloud" subtitle="Devia"][ld_media_element link_type="video" visible_content="yes" image="38" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D1DpH-icPpl0|||" offset="vc_col-md-2 vc_col-xs-6" title="Glitter & Gold" subtitle="Devia"][ld_media_element link_type="video" visible_content="yes" image="39" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DDkeiKbqa02g|||" offset="vc_col-md-2 vc_col-xs-6" title="Freak" subtitle="ft. Alicia"][ld_media_element link_type="video" visible_content="yes" image="40" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D9HDEHj2yzew|||" offset="vc_col-md-2 vc_col-xs-6" title="Blacktop" subtitle="Devia"][/ld_media][/vc_column][/vc_row][vc_row css=".vc_custom_1605626634888{padding-bottom: 60px !important;}" responsive_css="margin_top_medium:100px|padding_top_medium:70px|padding_bottom_medium:70px"][vc_column][ld_bananas_banner use_custom_fonts_heading="true" use_custom_fonts_heading2="true" image="4569" heading="Available on Spotify." heading2="New album is out!" fs="clamp(32px, 7vw, 110px)" fs2="clamp(32px, 7vw, 110px)"][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1602662034705{padding-top: 30px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_small:30px|padding_bottom_small:20px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1608641455549{margin-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]Discography[/ld_fancy_heading][ld_fancy_heading tag="h2"]Listen on Spotify[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-4" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_init_rotate_y="50" responsive_css="padding_bottom_medium:0px" css=".vc_custom_1605626649614{padding-bottom: 70px !important;}" responsive_align="text-center text-md-left"][ld_images_group_container margin="bottom_small:25px"][ld_images_group_element img_size="34%" enable_hover3d="yes" hover3d_stacking_factor="0.6" enable_roudness="yes" image_roudness="6" image="4547"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" margin="bottom_small:0.15em"]Carlos Santana[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(128, 127, 131)" fs="18px"]Part II. 2018[/ld_fancy_heading][ld_spacer height="15px"][ld_button style="btn-default" title="Listen on Spotify" transformation="text-uppercase" shape="circle" size="btn-lg" border="border-thick" i_type="fontawesome" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(165, 116, 80)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="14px" lh="1.5em" ls="0.115em" i_size="16px" i_icon_fontawesome="fab fa-spotify"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-8" ca_duration="1800" ca_start_delay="450" ca_delay="180" ca_init_translate_y="60" ca_init_rotate_y="51"][vc_column_text] [/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1602658648968{padding-bottom: 70px !important;}" el_id="videos" responsive_css="padding_top_medium:20px|padding_bottom_medium:110px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1575556211575{margin-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]Gallery[/ld_fancy_heading][ld_fancy_heading tag="h2"]Latest Videos[/ld_fancy_heading][/vc_column][vc_column][ld_carousel_marquee_tab columns="md:1.95|sm:2|xs:1|spacing_md:70px|spacing_xs:15px" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600676918411-0a09d9e4-974e"][vc_row_inner][vc_column_inner bg_position="center center" align="text-center" responsive_css="padding_top_medium:220px|padding_bottom_medium:220px" css=".vc_custom_1583761429164{margin-bottom: 30px !important;padding-top: 135px !important;padding-bottom: 135px !important;background-image: url(https://musichub.liquid-themes.com/staging/wp-content/uploads/2020/03/carousel-1-opt.jpg?id=4521) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" responsive_align="text-center"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="25px" i_shape_custom_size="86px" i_hcolor="rgb(0, 0, 0)" i_color="rgb(255, 255, 255)" i_fill_color2="rgb(255, 255, 255)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:http%3A%2F%2Fyoutube.com%2Fwatch%3Fv%3DbS3uSzk4VwY|||"][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" margin="bottom_small:0.25em"]Carlos Santana[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(128, 127, 131)" fs="18px"]Live Performance in London[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600677498601-48dacf29-8412"][vc_row_inner][vc_column_inner bg_position="center center" align="text-center" responsive_css="padding_top_medium:220px|padding_bottom_medium:220px" css=".vc_custom_1583764929789{margin-bottom: 30px !important;padding-top: 135px !important;padding-bottom: 135px !important;background-image: url(https://musichub.liquid-themes.com/staging/wp-content/uploads/2020/03/carousel-3@2x.jpg?id=4531) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" responsive_align="text-center"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="25px" i_shape_custom_size="86px" i_hcolor="rgb(0, 0, 0)" i_color="rgb(255, 255, 255)" i_fill_color2="rgb(255, 255, 255)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:http%3A%2F%2Fyoutube.com%2Fwatch%3Fv%3DbS3uSzk4VwY|||"][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" margin="bottom_small:0.25em"]Carlos Santana[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(128, 127, 131)" fs="18px"]Live Performance in London[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600677502379-20bcbc66-e24c"][vc_row_inner][vc_column_inner bg_position="center center" align="text-center" responsive_css="padding_top_medium:220px|padding_bottom_medium:220px" css=".vc_custom_1583764921850{margin-bottom: 30px !important;padding-top: 135px !important;padding-bottom: 135px !important;background-image: url(https://musichub.liquid-themes.com/staging/wp-content/uploads/2020/03/carousel-2@2x.jpg?id=4530) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" responsive_align="text-center"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="25px" i_shape_custom_size="86px" i_hcolor="rgb(0, 0, 0)" i_color="rgb(255, 255, 255)" i_fill_color2="rgb(255, 255, 255)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:http%3A%2F%2Fyoutube.com%2Fwatch%3Fv%3DbS3uSzk4VwY|||"][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" margin="bottom_small:0.25em"]Carlos Santana[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(128, 127, 131)" fs="18px"]Live Performance in London[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600677506194-98843f62-752f"][vc_row_inner][vc_column_inner bg_position="center center" align="text-center" responsive_css="padding_top_medium:220px|padding_bottom_medium:220px" css=".vc_custom_1595926170703{margin-bottom: 30px !important;padding-top: 135px !important;padding-bottom: 135px !important;background-image: url(https://musichub.liquid-themes.com/staging/wp-content/uploads/2020/03/slide-2-opt.jpg?id=4524) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" responsive_align="text-center"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="25px" i_shape_custom_size="86px" i_hcolor="rgb(0, 0, 0)" i_color="rgb(255, 255, 255)" i_fill_color2="rgb(255, 255, 255)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:http%3A%2F%2Fyoutube.com%2Fwatch%3Fv%3DbS3uSzk4VwY|||"][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" margin="bottom_small:0.25em"]Carlos Santana[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(128, 127, 131)" fs="18px"]Live Performance in London[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row bg_position="center bottom" enable_overlay="yes" css=".vc_custom_1602658688642{padding-top: 70px !important;padding-bottom: 70px !important;background-image: url(https://musichub.liquid-themes.com/staging/wp-content/uploads/2020/01/music-bg-2@2x.jpg?id=4471) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="tour" overlay_bg="linear-gradient(0deg, rgb(15,15,20) 1.5923566878980893%, rgba(15, 15, 20, 0.63) 100%)" responsive_css="margin_top_medium:60px|padding_top_medium:100px|padding_bottom_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1605626836335{margin-bottom: 20px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center" responsive_css="margin_bottom_medium:60px"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]Events[/ld_fancy_heading][ld_fancy_heading tag="h2"]Tour dates[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" animation_preset="Fade In" ca_delay="50" ca_duration="900"][vc_row_inner equal_height="yes" content_placement="middle" gap="20" enable_overlay="yes" overlay_bg="rgba(0, 0, 0, 0)" hover_overlay_bg="rgba(0, 0, 0, 0.25)" css=".vc_custom_1575554642734{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 5px !important;border-bottom-color: rgba(255,255,255,0.17) !important;border-bottom-style: solid !important;}"][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1602773028642{margin-bottom: 15px !important;}"][ld_fancy_heading tag="h4"]21 APR[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773038033{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Arizona, US[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773046504{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.55)" fs="15px"]Santana ft. Joss[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_hidden-sm vc_col-xs-6 vc_hidden-xs" responsive_align="text-md-right" css=".vc_custom_1602773158856{margin-bottom: 15px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-md-right" css=".vc_custom_1602773072235{margin-bottom: 15px !important;}"][ld_button style="btn-naked" title="Buy tickets" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" fs="14px" ls="0.115em" css=".vc_custom_1595925758773{margin-bottom: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" gap="20" enable_overlay="yes" overlay_bg="rgba(0, 0, 0, 0)" hover_overlay_bg="rgba(0, 0, 0, 0.25)" css=".vc_custom_1575554642734{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 5px !important;border-bottom-color: rgba(255,255,255,0.17) !important;border-bottom-style: solid !important;}"][vc_column_inner align="text-center" offset="vc_hidden-lg vc_hidden-md" css=".vc_custom_1605682943092{margin-bottom: 15px !important;}" responsive_align="text-center"][ld_fancy_heading tag="p" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.25)" fs="12px" ls="0.115em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgba(255, 255, 255, 0.1)" lh="1.25em"]Sold out[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1602773080006{margin-bottom: 15px !important;}"][ld_fancy_heading tag="h4"]19 MAY[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773101970{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Stockholm, Sweden[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773108669{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.55)" fs="15px"]Santana ft. Joss[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_hidden-sm vc_col-xs-6 vc_hidden-xs" responsive_align="text-md-right" css=".vc_custom_1602773115902{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.25)" fs="12px" ls="0.115em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgba(255, 255, 255, 0.1)" lh="1.25em"]Sold out[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-md-right" css=".vc_custom_1602773123164{margin-bottom: 15px !important;}"][ld_button style="btn-naked" title="Buy tickets" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" fs="14px" ls="0.115em" css=".vc_custom_1595925758773{margin-bottom: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" gap="20" enable_overlay="yes" overlay_bg="rgba(0, 0, 0, 0)" hover_overlay_bg="rgba(0, 0, 0, 0.25)" css=".vc_custom_1575554642734{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 5px !important;border-bottom-color: rgba(255,255,255,0.17) !important;border-bottom-style: solid !important;}"][vc_column_inner offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1602773129464{margin-bottom: 15px !important;}"][ld_fancy_heading tag="h4"]08 JUN[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773136459{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]North Carolina, US[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773142518{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.55)" fs="15px"]Santana ft. Joss[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs" responsive_align="text-md-right" css=".vc_custom_1602773154205{margin-bottom: 15px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-md-right" css=".vc_custom_1602773166263{margin-bottom: 15px !important;}"][ld_button style="btn-naked" title="Buy tickets" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" fs="14px" ls="0.115em" css=".vc_custom_1595925758773{margin-bottom: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" gap="20" enable_overlay="yes" overlay_bg="rgba(0, 0, 0, 0)" hover_overlay_bg="rgba(0, 0, 0, 0.25)" css=".vc_custom_1575554642734{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 5px !important;border-bottom-color: rgba(255,255,255,0.17) !important;border-bottom-style: solid !important;}"][vc_column_inner offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1602773172442{margin-bottom: 15px !important;}"][ld_fancy_heading tag="h4"]11 JUL[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773179027{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]London, UK[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773186008{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.55)" fs="15px"]Santana ft. Joss[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs" responsive_align="text-md-right" css=".vc_custom_1602773191539{margin-bottom: 15px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-md-right" css=".vc_custom_1602773198908{margin-bottom: 15px !important;}"][ld_button style="btn-naked" title="Buy tickets" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" fs="14px" ls="0.115em" css=".vc_custom_1595925758773{margin-bottom: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" gap="20" enable_overlay="yes" overlay_bg="rgba(0, 0, 0, 0)" hover_overlay_bg="rgba(0, 0, 0, 0.25)" css=".vc_custom_1575554642734{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 5px !important;border-bottom-color: rgba(255,255,255,0.17) !important;border-bottom-style: solid !important;}"][vc_column_inner align="text-center" offset="vc_hidden-lg vc_hidden-md" css=".vc_custom_1605682964011{margin-bottom: 15px !important;}" responsive_align="text-center"][ld_fancy_heading tag="p" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.25)" fs="12px" ls="0.115em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgba(255, 255, 255, 0.1)" lh="1.25em"]Sold out[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1602773227518{margin-bottom: 15px !important;}"][ld_fancy_heading tag="h4"]15 AUG[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773234716{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Florence, Italy[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1602773241702{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.55)" fs="15px"]Santana ft. Joss[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_hidden-sm vc_col-xs-6 vc_hidden-xs" responsive_align="text-md-right" css=".vc_custom_1602773265298{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.25)" fs="12px" ls="0.115em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgba(255, 255, 255, 0.1)" lh="1.25em"]Sold out[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-md-right" css=".vc_custom_1602773272487{margin-bottom: 15px !important;}"][ld_button style="btn-naked" title="Buy tickets" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" fs="14px" ls="0.115em" css=".vc_custom_1595925758773{margin-bottom: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" css=".vc_custom_1575614929081{padding-top: 70px !important;}" responsive_align="text-center"][ld_button style="btn-default" title="SEE SCHEDULE" transformation="text-uppercase" shape="circle" size="btn-lg" border="border-thicker" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="14px" lh="1.5em" ls="0.115em"][/vc_column][/vc_row][vc_row css=".vc_custom_1602658713258{padding-bottom: 70px !important;}" el_id="follow" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1575621751849{margin-bottom: 20px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]Follow on[/ld_fancy_heading][ld_fancy_heading tag="h2"]Instagram[/ld_fancy_heading][/vc_column][vc_column][ld_instagram limit="6" images_per_row="3" columns_gap="custom" stretch="yes" border_radius="custom" custom_gap="20px" custom_border_radius="10px"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="top" css=".vc_custom_1579173155241{padding-top: 50px !important;padding-bottom: 70px !important;}"][vc_column align="text-center" offset="vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true"]Next Event In:[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="18px"]Jan 3, 2020 in Cambridge, London[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-7" responsive_align="text-md-right"][ld_countdown month="5" day="18" year="2021" use_custom_typography="true" fs="48px" lh="1.65em" primary_color="rgb(149, 149, 149)" digits_color="rgb(255, 255, 255)" sep_color="rgba(255, 255, 255, 0)" ls="0"][/vc_column][/vc_row][vc_row css=".vc_custom_1602658731479{padding-bottom: 70px !important;}" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1575614866488{margin-bottom: 60px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]Keep in touch[/ld_fancy_heading][ld_fancy_heading tag="h2"]Latest stories[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" animation_preset="Fade In" ca_delay="80"][ld_blog style="style03" grid_columns="3" post_type="post" posts_per_page="3" columns_gap="24" bottom_gap="30" ib_style="" ib_border="" unique_id="1575551164044-8928616c-5450" title_color="rgb(241, 241, 241)" filter_id="lqd-1596021020438-62349bcb-d705"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company
	$data = array();
	$data['name'] = esc_html__( 'Company', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" bg_attachment="fixed" enable_overlay="yes" enable_loading_bg="yes" css=".vc_custom_1603104694188{padding-top: 180px !important;padding-bottom: 120px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2020/07/banner-company-optimized@2x-scaled.jpg?id=8821) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 34, 44, 0.43)" responsive_css="padding_top_medium:135px|padding_bottom_medium:35px|padding_top_small:80px|padding_bottom_small:80px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-7" ca_duration="1600" ca_start_delay="600" ca_delay="160" ca_init_translate_y="50"][ld_fancy_heading split_type="chars, words" highlight_type="lqd-highlight-custom-underline" highlight_height="0.2em" highlight_offset="0em" duration="1000" delay="45" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_all:88px|text_large:84px|text_small:13.5vw" lh="text_small:0.9em" margin="bottom_small:0.1em" ca_init_translate_y="0" ls="text_small:-0.02em"][ld_highlight]first[/ld_highlight]class investments[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.7)" fs="text_medium:23px|text_small:20px" lh="text_medium:1.7em|text_small:1.5em" padding="right_large:20%25" ca_init_translate_y="0"]Take your business to the next level Hub’s built-in risk and profit management tools.[/ld_fancy_heading][vc_row_inner css=".vc_custom_1612086109115{padding-top: 25px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-5" css=".vc_custom_1576834675024{margin-bottom: 15px !important;}"][ld_button style="btn-solid" title="Get a quote" link_type="scroll_to_section" shape="round" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="16px" css=".vc_custom_1609755564039{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="20px" hover_color="rgb(24, 67, 65)"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1576834683574{margin-bottom: 15px !important;}"][vc_column_text]</p> <h6><span style="font-size: 13px; color: #ffffff;">call us now</span><br /> <span style="font-size: 19px; color: var(--color-primary);">+1 114 7788</span></h6> <p>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="2.05" ca_init_scale_y="2.05" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" responsive_align="text-md-right" ca_duration="1800" ca_start_delay="1200"][ld_spacer height="15px" md_height="120px" sm_height="30px"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="24px" i_shape_custom_size="96px" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.8)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQxdxYr6CRN4%26ab_channel%3DIntapp|||"][/vc_column][/vc_row][vc_row content_placement="middle"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1605625730804{padding-top: 80px !important;padding-bottom: 35px !important;}" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]about us[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_large:14%25"]consulting agency for your business.[/ld_fancy_heading][ld_fancy_heading tag="p"]Hub has a full range of products for personal data analysis, business consultation, and strategic partnership. Hub allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][/vc_column][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-2 vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1612176801668{padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 40px !important;padding-left: 20px !important;background-color: #ffffff !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.07)%22%7D%5D" responsive_css="margin_top_medium:-65px|padding_bottom_medium:20px|padding_right_small:50px|padding_left_small:50px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]send a message[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" padding="right_large:14%25" margin="bottom_small:1.1em" fs="30px"]request a call back[/ld_fancy_heading][ld_cf7 id="8632" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-lg" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" lqd_bg_color="rgb(248, 245, 243)" color="rgb(0, 0, 0)" css=".vc_custom_1606897967487{margin-bottom: 0px !important;}" submit_color="rgb(24, 67, 65)" bm="20px" submit_hbg_color="rgb(24, 67, 65)" submit_h_color="rgb(255, 255, 255)" submit_bg_color="rgb(255, 205, 40)" submit_border_color="rgb(255, 205, 40)" submit_hover_border_color="rgb(24, 67, 65)"][/vc_column][/vc_row][vc_row css=".vc_custom_1602153350967{padding-top: 65px !important;padding-bottom: 65px !important;}" responsive_css="margin_bottom_medium:80px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1577271562832{margin-bottom: 60px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_an_translate_y="0" responsive_align="text-center"][ld_fancy_heading tag="h2"]case studies[/ld_fancy_heading][ld_fancy_heading tag="p"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" equal_height="yes" animation_preset="Fade In" ca_duration="1800" ca_delay="90"][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1602158311874{margin-bottom: 30px !important;}"][ld_icon_box i_type="image" heading_size="custom" toggleable="yes" show_button="yes" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" ib_style="btn-naked" ib_title="Learn more" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" ib_i_add_icon="true" i_icon_image="8669" title="grow your brand and business" custom_heading_size="16px" icon_mb="20" css=".vc_custom_1602158022937{margin-bottom: 0px !important;padding-top: 25px !important;padding-right: 45px !important;padding-bottom: 0px !important;padding-left: 45px !important;}" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" title_mb="1" ib_color="rgb(255, 255, 255)" link="|||" hover_fill_color="rgb(24, 68, 65)" hover_text_color="rgb(255, 255, 255)" fill_color="rgb(252, 250, 249)" ib_i_color="rgb(255, 255, 255)"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1602158321529{margin-bottom: 30px !important;}"][ld_icon_box i_type="image" heading_size="custom" toggleable="yes" show_button="yes" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" ib_style="btn-naked" ib_title="Learn more" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" ib_i_add_icon="true" i_icon_image="8666" title="business plan consulting" custom_heading_size="16px" icon_mb="20" css=".vc_custom_1602158075991{margin-bottom: 0px !important;padding-top: 25px !important;padding-right: 45px !important;padding-bottom: 0px !important;padding-left: 45px !important;}" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" title_mb="1" ib_color="rgb(255, 255, 255)" link="|||" hover_fill_color="rgb(24, 68, 65)" hover_text_color="rgb(255, 255, 255)" fill_color="rgb(252, 250, 249)" ib_i_color="rgb(255, 255, 255)"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1602158333417{margin-bottom: 30px !important;}"][ld_icon_box i_type="image" heading_size="custom" toggleable="yes" show_button="yes" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" ib_style="btn-naked" ib_title="Learn more" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" ib_i_add_icon="true" i_icon_image="8667" title="increase your conversion rate" custom_heading_size="16px" icon_mb="20" css=".vc_custom_1602158099507{margin-bottom: 0px !important;padding-top: 25px !important;padding-right: 45px !important;padding-bottom: 0px !important;padding-left: 45px !important;}" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" title_mb="1" ib_color="rgb(255, 255, 255)" link="|||" hover_fill_color="rgb(24, 68, 65)" hover_text_color="rgb(255, 255, 255)" fill_color="rgb(252, 250, 249)" ib_i_color="rgb(255, 255, 255)"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1602158343474{margin-bottom: 30px !important;}"][ld_icon_box i_type="image" heading_size="custom" toggleable="yes" show_button="yes" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" ib_style="btn-naked" ib_title="Learn more" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" ib_i_add_icon="true" i_icon_image="8668" title="business startup analysis" custom_heading_size="16px" icon_mb="20" css=".vc_custom_1611425365907{margin-bottom: 0px !important;padding-top: 25px !important;padding-right: 45px !important;padding-bottom: 0px !important;padding-left: 45px !important;}" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" title_mb="1" ib_color="rgb(255, 255, 255)" link="|||" hover_fill_color="rgb(24, 68, 65)" hover_text_color="rgb(255, 255, 255)" fill_color="rgb(252, 250, 249)" ib_i_color="rgb(255, 255, 255)"][/ld_icon_box][/vc_column_inner][vc_column_inner align="text-center" css=".vc_custom_1576838184663{margin-top: 30px !important;}" responsive_align="text-center"][ld_button style="btn-naked" title="See more services" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" lh="1em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" htext_color="rgb(0, 0, 0)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row bg_attachment="fixed" enable_overlay="yes" css=".vc_custom_1595428168333{padding-top: 110px !important;padding-bottom: 110px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/bg-2@2x-scaled.jpg?id=8662) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(13, 65, 63, 0.91)"][vc_column offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25"][ld_fancy_heading tag="h2" alignment="text-center" split_type="words" duration="800" delay="20" easing="linear" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:50px|text_small:40px" lh="text_small:1.5em"]unleashing our clients’ potential by maximising <span style="color: #ffcc23;">the innovation.</span>[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1595425808576{padding-top: 50px !important;padding-bottom: 20px !important;background-color: #fcfaf9 !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_fancy_heading tag="p" color="rgba(29, 39, 78, 0.75)" margin="bottom_small:50px"]Join the 10.000+ companies trusting Hub[/ld_fancy_heading][/vc_column][vc_column align="text-center" responsive_align="text-center"][ld_carousel_marquee_tab columns="md:6|sm:4|xs:3|spacing_md:34px|spacing_xs:20px" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600670099986-fda266dc-b13a"][vc_single_image image="8804"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670135306-ec00d2d2-6cd6"][vc_single_image image="8802"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670138255-ecb183c1-d7e6"][vc_single_image image="8801"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670142203-cffe373d-a535"][vc_single_image image="8799"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670145263-0552daf2-f1e0"][vc_single_image image="8800"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670147842-65cbe96c-b157"][vc_single_image image="8798"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1602154964430{padding-top: 65px !important;}" responsive_css="border_top_medium:200px|padding_top_medium:100px|padding_bottom_medium:50px|padding_top_small:65px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1577271701433{margin-bottom: 60px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h2"]global experts[/ld_fancy_heading][ld_fancy_heading tag="p"]As a partner of corporates, Liquid has more than 9,000 partners of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_bottom_medium:80px|margin_bottom_small:45px" css=".vc_custom_1602155570185{margin-bottom: 45px !important;}"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="bottom" gap="20" animation_preset="Fade In" ca_delay="80"][vc_column_inner enable_link="enable_column_link" enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1595423449007{margin-bottom: 30px !important;padding-top: 215px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Image@2x.jpg?id=8661) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" offset="vc_col-md-4" overlay_bg="linear-gradient(0deg, rgba(24, 27, 49, 0.6) 0%, rgba(0, 0, 0, 0) 100%)" hover_overlay_bg="rgba(24, 27, 49, 0.65)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" link="url:%23|||"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="13px" fw="700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]finance[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em" padding="right_all:20%25|right_large:16%25"]banking and business partnership[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_link="enable_column_link" enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1595423440522{margin-bottom: 30px !important;padding-top: 215px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Image-2@2x.jpg?id=8659) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" offset="vc_col-md-4" overlay_bg="linear-gradient(0deg, rgba(24, 27, 49, 0.6) 0%, rgba(0, 0, 0, 0) 100%)" hover_overlay_bg="rgba(24, 27, 49, 0.65)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" link="url:%23|||"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="13px" fw="700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]analytics[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="28px" lh="1em" padding="right_all:20%25|right_large:16%25"]big data integration for startups[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_link="enable_column_link" enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1595423456095{margin-bottom: 30px !important;padding-top: 215px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Image-1@2x.jpg?id=8660) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" offset="vc_col-md-4" overlay_bg="linear-gradient(0deg, rgba(24, 27, 49, 0.6) 0%, rgba(0, 0, 0, 0) 100%)" hover_overlay_bg="rgba(24, 27, 49, 0.65)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" link="url:%23|||"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="13px" fw="700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]consulting[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em" padding="right_all:20%25|right_large:16%25"]analyzing company reports[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1606898355338{margin-bottom: 65px !important;}" responsive_css="padding_right_medium:8%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h2"]leading the best marketing team.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.25em"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing.[/ld_fancy_heading][ld_button style="btn-solid" title="learn more" shape="round" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="16px" css=".vc_custom_1595351930590{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="20px" hover_color="rgb(24, 67, 65)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1577272089640{margin-bottom: 30px !important;}" ca_duration="1800" ca_start_delay="350" ca_delay="180" ca_init_translate_y="35"][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="30px" fs="16px" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(248, 245, 243)" active_bg_color="rgb(24, 67, 65)" heading_color="rgb(24, 67, 65)" active_heading_color="rgb(255, 255, 255)" exp_color="rgb(24, 67, 65)" active_exp_color="rgb(255, 255, 255)" lh="1.5em" border_color="rgb(255, 250, 247)" active_border_color="rgb(24, 67, 65)"][vc_accordion_tab title="First-class investment solutions" tab_id="ld-1576843306949-c9811b96-fe6b"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Building the idea of future" tab_id="ld-1576843455029-57b05fca-b401"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Business consultation for startups" tab_id="ld-1576843473475-7ad9f679-ee46"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" bg_position="center center" css=".vc_custom_1605624089957{padding-top: 45px !important;padding-bottom: 30px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Shape-BG.png?id=8692) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:50px|padding_bottom_medium:80px|padding_top_small:45px"][vc_column offset="vc_col-md-6" responsive_align="text-center text-md-left"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="4" enable_shadow="yes" image="8768" position="left_large:0px|left_medium:-19vw|left_small:-10vw"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" enable_shadow="yes" image="8849" margin="top_small:-38%25|left_small:33%25" shadow_delay="500" position="left_medium:0px|left_small:-3vw"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_left_medium:16%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]company’s vision[/ld_fancy_heading][ld_fancy_heading tag="h2"]Investing in the digital future.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.25em"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data in the digital world.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Business-Plan Consulting" title_mb="1" icon_mb="10" custom_heading_size="17px" css=".vc_custom_1610731201809{margin-bottom: 10px !important;}" i_color="rgb(24, 67, 65)" icon_size="15px"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="First-Class Investments" title_mb="1" icon_mb="10" custom_heading_size="17px" icon_size="15px" css=".vc_custom_1610731213234{margin-bottom: 10px !important;}" i_color="rgb(24, 67, 65)"][/ld_icon_box][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1588062878035{padding-top: 30px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-5"][ld_button style="btn-solid" title="Get a quote" shape="round" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="16px" css=".vc_custom_1595424291759{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="20px" hover_color="rgb(24, 67, 65)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][ld_spacer height="72px"][/vc_column][vc_column custom_border_radius="500px" css=".vc_custom_1606899691951{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;padding-top: 35px !important;padding-bottom: 35px !important;border-left-color: #ededed !important;border-left-style: solid !important;border-right-color: #ededed !important;border-right-style: solid !important;border-top-color: #ededed !important;border-top-style: solid !important;border-bottom-color: #ededed !important;border-bottom-style: solid !important;}" responsive_css="border_top_medium:1px|border_right_medium:1px|border_bottom_medium:1px|border_left_medium:1px"][ld_process_box_container template="style05"][ld_process_box use_custom_fonts_title="true" title="Register your email" fs="16px" ls="0px" title_color="rgb(17, 36, 70)" bg_shape="rgb(255, 255, 255)" hover_icon_color="rgb(0, 0, 0)"][/ld_process_box][ld_process_box use_custom_fonts_title="true" title="Accept Invitations" fs="16px" ls="0px" bg_shape="rgb(255, 255, 255)" hover_icon_color="rgb(0, 0, 0)"][/ld_process_box][ld_process_box use_custom_fonts_title="true" title="Start using your email" fs="16px" ls="0px" title_color="rgb(17, 36, 70)" bg_shape="rgb(255, 255, 255)" hover_icon_color="rgb(0, 0, 0)"][/ld_process_box][/ld_process_box_container][/vc_column][/vc_row][vc_row bg_position="center center" enable_overlay="yes" css=".vc_custom_1610476534217{background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2021/01/testimonials-bg@2x2@2x.jpg?id=9081) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(115deg, rgb(24,67,65) 48.089171974522294%, rgba(0,0,0,0) 75.1592356687898%)" responsive_css="margin_top_medium:100px"][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1606899031019{padding-top: 60px !important;padding-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="50" responsive_css="padding_top_medium:120px|padding_bottom_medium:120px"][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="8689" margin="bottom_large:-3%25|left_large:-10%25" translate_from_y="52" translate_to_y="-90"][/ld_images_group_element][ld_fancy_heading tag="h2" padding="right_large:14%25" color="rgb(250, 213, 91)" margin="bottom_small:1em"]testimonials[/ld_fancy_heading][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" navarrow="6" navslidernumberstoarrows="yes" nav_arrow_color="rgb(255, 255, 255)" nav_arrow_numbers="rgb(255, 255, 255)" mobile_dots_bg_color="rgb(255, 255, 255)"][ld_carousel_section title="Tab" tab_id="lqd-1595349907264-81e36071-bb63"][vc_row_inner css=".vc_custom_1576847855744{margin-bottom: 20px !important;}"][vc_column_inner offset="vc_col-md-9"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:25px|text_small:20px" lh="text_small:39px" margin="bottom_small:1em"]“You made it so simple. My site is so much faster and easier to work with than my old site. I just choose the page, make the change and click save.”[/ld_fancy_heading][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" color="rgba(255, 255, 255, 0.55)"]Liquid, Founder[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595349907403-1f27b8d2-9642"][vc_row_inner css=".vc_custom_1576847855744{margin-bottom: 20px !important;}"][vc_column_inner offset="vc_col-md-9"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:25px|text_small:20px" lh="text_small:39px" margin="bottom_small:1em"]“You made it so simple. My site is so much faster and easier to work with than my old site. I just choose the page, make the change and click save.”[/ld_fancy_heading][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" color="rgba(255, 255, 255, 0.55)"]Liquid, Founder[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595349907531-bec55896-e0b5"][vc_row_inner css=".vc_custom_1576847855744{margin-bottom: 20px !important;}"][vc_column_inner offset="vc_col-md-9"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:25px|text_small:20px" lh="text_small:39px" margin="bottom_small:1em"]“You made it so simple. My site is so much faster and easier to work with than my old site. I just choose the page, make the change and click save.”[/ld_fancy_heading][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" color="rgba(255, 255, 255, 0.55)"]Liquid, Founder[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1602156062406{padding-top: 65px !important;padding-bottom: 30px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:30px|padding_top_small:65px|padding_bottom_small:30px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1605624154640{margin-bottom: 40px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center" responsive_css="margin_bottom_medium:60px"][ld_fancy_heading tag="h2"]hub news[/ld_fancy_heading][ld_fancy_heading tag="p"]As a partner of corporates, Liquid has more than 9,000 partners of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1602156564948{margin-bottom: 25px !important;}" responsive_css="margin_bottom_medium:80px|margin_bottom_small:25px"][ld_blog style="style16" grid_columns="3" meta_type="cats" post_type="post" posts_per_page="3" columns_gap="15" bottom_gap="30" ib_style="btn-default" unique_id="lqd-1588957493353-c70b8c09-8ad4" title_weight="700" filter_id="lqd-1588957493353-26dc0f0a-18f7" hover_title_color="rgb(0, 0, 0)" post_excerpt_length="12"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0"][vc_column css=".vc_custom_1595331977785{margin-bottom: -1px !important;}"][ld_google_map style="assassinsCreedIV" map_marker="html_marker" multiple_markers="yes" si_style="" si_size="" si_border="" zoom="14" address="Manhattan" map_height="550px" marker_coordinates="%5B%7B%7D%2C%7B%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - About
	$data = array();
	$data['name'] = esc_html__( 'Company - About', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-about.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1610731698842{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column][ld_tabs style="style03" nav_alignment="justify-content-md-center" use_custom_fonts_nav="true" primary_color="rgb(223, 224, 234)" active_color="rgb(0, 0, 0)" fs="17px" fw="700" text_color="rgba(24, 67, 65, 0.71)" primary_hcolor="rgb(24, 67, 65)" text_hcolor="rgb(24, 67, 65)"][ld_tab_section i_type="linea" title="Qualified Team" tab_id="1533026199621-94d7bc08-4b10"][vc_row_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1533026609059{padding-right: 8% !important;padding-left: 8% !important;}" responsive_align="text-center"][vc_column_text]<span style="font-size: 18px; color: #818486;">As a leading college in Paris, we look to engage with our student beyond the conventional design and development school relationship, becoming a partner to the people and companies we work with.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section i_type="linea" title="Business Partners" tab_id="ld-1576232120981-c979a48f-113f"][vc_row_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1533026609059{padding-right: 8% !important;padding-left: 8% !important;}" responsive_align="text-center"][vc_column_text]<span style="font-size: 18px; color: #818486;">As a leading college in Paris, we look to engage with our student beyond the conventional design and development school relationship, becoming a partner to the people and companies we work with.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section i_type="linea" title="Our Strategy" tab_id="ld-1576232120379-278439b3-5378"][vc_row_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1533026609059{padding-right: 8% !important;padding-left: 8% !important;}" responsive_align="text-center"][vc_column_text]<span style="font-size: 18px; color: #818486;">As a leading college in Paris, we look to engage with our student beyond the conventional design and development school relationship, becoming a partner to the people and companies we work with.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row][vc_row css=".vc_custom_1551902075173{margin-top: 20px !important;margin-bottom: 50px !important;}" responsive_css="margin_bottom_medium:100px"][vc_column][ld_media columns_gap="10" bottom_gap="20" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="ld-1540207915500-298c08e6-2b13"][ld_media_element link_type="video" width="1/1" title="Strategy" image="9088" offset="vc_col-md-6" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" custom_height="645px"][ld_media_element vertical_alignment="justify-content-end" link_type="image" width="1/1" title="Press and Media" image="9087" offset="vc_col-md-6" custom_height="312px"][ld_media_element vertical_alignment="justify-content-end" link_type="image" width="1/2" title="Career" image="9090" offset="vc_col-md-3 vc_col-xs-12" custom_height="312px"][ld_media_element vertical_alignment="justify-content-end" link_type="image" width="1/2" title="Learn" image="9089" offset="vc_col-md-3 vc_col-xs-12" custom_height="312px"][/ld_media][/vc_column][/vc_row][vc_row css=".vc_custom_1576240570995{padding-top: 120px !important;padding-bottom: 100px !important;background-color: #f4f4f4 !important;}" responsive_css="border_right_medium:200px"][vc_column offset="vc_col-lg-6 vc_col-md-7" css=".vc_custom_1607931989373{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:40px|text_small:36px"]Inspiration, innovation, and countless opportunities.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="30px" margin="bottom_small:2em"]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="20px" fs="16px" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" heading_color="rgb(57, 55, 77)" active_heading_color="rgb(255, 255, 255)" bg_color="rgb(255, 255, 255)" border_color="rgb(255, 255, 255)" fw="700" active_bg_color="rgb(24, 67, 65)"][vc_accordion_tab title="Hub Business' Vision" tab_id="lqd-1575466271794-292b803f-ecd6"][vc_column_text]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Our mission for Sustainability" tab_id="ld-1575466481374-e9a15b23-39d2"][vc_column_text]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Qualified Team" tab_id="ld-1575466494877-1af59567-b066"][vc_column_text]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-md-5"][ld_images_group_element parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="8" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="8658" margin="right_large:-12%25" translate_from_y="60" translate_to_y="-75"][/ld_images_group_element][/vc_column][vc_column][ld_spacer height="72px"][vc_row_inner enable_content_animation="yes" equal_height="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_delay="180" ca_init_translate_x="0"][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246569369{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-presentation" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246647927{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-target" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246618793{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-path" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246601414{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-mobile" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row gap="30" equal_height="yes" content_placement="middle" css=".vc_custom_1576240468850{margin-top: 110px !important;padding-bottom: 40px !important;}"][vc_column align="text-center" responsive_align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1576240186399{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" alignment="text-center" use_custom_fonts_title="true" fw="text_small:700"]Our Team[/ld_fancy_heading][vc_column_text]<span style="font-size: 18px; color: #818486;">As a leading college in Paris, we look to engage with our student beyond the conventional design and development school relationship, becoming a partner to the people.</span>[/vc_column_text][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-4" ca_init_translate_y="20" ca_duration="1200" ca_delay="150"][vc_single_image image="9093" css=".vc_custom_1610723814216{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fw="text_small:700" fs="text_small:25px"]Gilbert Hughes[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(144, 145, 151)" fs="text_small:10px" fw="text_small:400" ls="text_small:0.1em" padding="top_small:6px|right_small:6px|bottom_small:6px|left_small:6px" fh_bg="rgb(241, 244, 245)" margin="bottom_small:1em"]Proffessor[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.6em" margin="right_large:10%25"]Gilbert Hughes joined Hub Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-4" ca_init_translate_y="20" ca_start_delay="200" ca_duration="1200" ca_delay="150"][vc_single_image image="9092" css=".vc_custom_1610723823375{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:25px" fw="text_small:700"]Erik Genie[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(144, 145, 151)" fs="text_small:10px" fw="text_small:400" ls="text_small:0.1em" padding="top_small:6px|right_small:6px|bottom_small:6px|left_small:6px" fh_bg="rgb(241, 244, 245)" margin="bottom_small:1em"]Proffessor[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.6em" margin="right_large:10%25"]Gilbert Hughes joined Hub Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_init_translate_y="20" ca_start_delay="400" ca_duration="1200" ca_delay="150"][vc_single_image image="9091" css=".vc_custom_1610723901525{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:25px" fw="text_small:700"]Mary Hughes[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(144, 145, 151)" fs="text_small:10px" fw="text_small:400" ls="text_small:0.1em" padding="top_small:6px|right_small:6px|bottom_small:6px|left_small:6px" fh_bg="rgb(241, 244, 245)" margin="bottom_small:1em"]Proffessor[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.6em" margin="right_large:10%25"]Gilbert Hughes joined Hub Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][/vc_column][/vc_row][vc_row enable_overlay="yes" css=".vc_custom_1610724191291{margin-top: 50px !important;margin-bottom: 50px !important;padding-top: 115px !important;padding-bottom: 85px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2021/01/testimonials-bg@2x.jpg?id=9080) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(137deg, #184341 0%, rgba(45,53,68,0.83) 100%)"][vc_column width="1/4" align="text-center" responsive_align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="lqd-icn-ess icon-lqd-compass" icon_mb="1" css=".vc_custom_1607931787001{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter use_custom_fonts_title="true" counter_mb_checkbox="true" bottom_margin="15" enable_gradient="" enable_hover_gradient="" count="70+" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="Country" ls="1.5px" label="Country" color="rgb(255, 255, 255)" label_color="rgba(255, 255, 255, 0.7)" counter_mb="7"][/vc_column][vc_column width="1/4" align="text-center" responsive_align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="lqd-icn-ess icon-speech-bubble" icon_mb="1" css=".vc_custom_1610723915298{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter use_custom_fonts_title="true" counter_mb_checkbox="true" bottom_margin="15" enable_gradient="" enable_hover_gradient="" count="60" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="Country" ls="1.5px" label="Awards and Medals" color="rgb(255, 255, 255)" label_color="rgba(255, 255, 255, 0.7)" counter_mb="7"][/vc_column][vc_column width="1/4" align="text-center" responsive_align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="lqd-icn-ess icon-lqd-user" icon_mb="1" css=".vc_custom_1607931850464{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter use_custom_fonts_title="true" counter_mb_checkbox="true" bottom_margin="15" enable_gradient="" enable_hover_gradient="" count="130k+" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="Country" ls="1.5px" label="International Customers" color="rgb(255, 255, 255)" label_color="rgba(255, 255, 255, 0.7)" counter_mb="7"][/vc_column][vc_column width="1/4" align="text-center" responsive_align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="lqd-icn-ess icon-lqd-atom" icon_mb="1" css=".vc_custom_1607931915869{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter use_custom_fonts_title="true" counter_mb_checkbox="true" bottom_margin="15" enable_gradient="" enable_hover_gradient="" count="21+" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="Country" ls="1.5px" label="Facilities" color="rgb(255, 255, 255)" label_color="rgba(255, 255, 255, 0.7)" counter_mb="7"][/vc_column][/vc_row][vc_row equal_height="yes" bg_position="center center" css=".vc_custom_1610731024155{padding-top: 40px !important;padding-bottom: 80px !important;background-image: url(http://education.liquid-themes.com/wp-content/uploads/2019/12/map.jpg?id=53) !important;}" responsive_css="padding_bottom_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1575461297173{margin-bottom: 50px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h6"]A deep commitment to diversity[/ld_fancy_heading][ld_fancy_heading tag="h2" enable_fit="true" minfontsize="32"]Business Partners[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-6" css=".vc_custom_1607932308970{margin-bottom: 40px !important;}"][vc_row_inner equal_height="yes" gap="0"][vc_column_inner offset="vc_col-md-4" css=".vc_custom_1610724018562{background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2021/01/img-asas1@2x.jpg?id=9096) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="9096" invisible="yes" css=".vc_custom_1610723997273{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-md-8" css=".vc_custom_1607932340189{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 45px !important;padding-right: 15px !important;padding-bottom: 45px !important;padding-left: 15px !important;border-left-color: #f5f5f5 !important;border-left-style: solid !important;border-right-color: #f5f5f5 !important;border-right-style: solid !important;border-top-color: #f5f5f5 !important;border-top-style: solid !important;border-bottom-color: #f5f5f5 !important;border-bottom-style: solid !important;}" responsive_css="padding_right_medium:55px|padding_left_medium:55px|padding_right_small:35px|padding_left_small:35px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:16px" margin="bottom_small:20px"]Daniel James, Stripe[/ld_fancy_heading][ld_fancy_heading tag="p"]By enrolling in the Four Bear Program, UM guarantees you will graduate in four years with a bachelor’s degree. Discover the global city—filled with inspiration, opportunities to explore.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" offset="vc_col-md-6" css=".vc_custom_1607932321876{margin-bottom: 40px !important;}"][vc_row_inner equal_height="yes" gap="0"][vc_column_inner offset="vc_col-md-4" css=".vc_custom_1610724030425{background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2021/01/img-ss2@2x.jpg?id=9095) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="9095" invisible="yes" css=".vc_custom_1610724039178{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-md-8" css=".vc_custom_1607932352733{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 45px !important;padding-right: 15px !important;padding-bottom: 45px !important;padding-left: 15px !important;border-left-color: #f5f5f5 !important;border-left-style: solid !important;border-right-color: #f5f5f5 !important;border-right-style: solid !important;border-top-color: #f5f5f5 !important;border-top-style: solid !important;border-bottom-color: #f5f5f5 !important;border-bottom-style: solid !important;}" responsive_css="padding_right_medium:55px|padding_left_medium:55px|padding_right_small:35px|padding_left_small:35px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:16px" margin="bottom_small:20px"]Shane Dore, PayPal[/ld_fancy_heading][ld_fancy_heading tag="p"]By enrolling in the Four Bear Program, UM guarantees you will graduate in four years with a bachelor’s degree. Discover the global city—filled with inspiration, opportunities to explore.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" responsive_align="text-center"][ld_fancy_heading tag="p"]Our nearly 8,000 committed staff members are ready to help.[/ld_fancy_heading][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1610731000077{border-top-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-top-color: #efefef !important;border-top-style: solid !important;}"][vc_column css=".vc_custom_1610701116044{margin-bottom: 30px !important;}" offset="vc_col-md-3"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" ls="text_small:0.1em"]Trusted by global brands[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-8"][vc_row_inner][vc_column_inner width="1/5" css=".vc_custom_1610700678572{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9120" alignment="center" css=".vc_custom_1610730857045{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" css=".vc_custom_1610700690002{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9124" alignment="center" css=".vc_custom_1610730865485{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" css=".vc_custom_1610700701170{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9122" alignment="center" css=".vc_custom_1610730875086{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" responsive_css="margin_bottom_small:0px" css=".vc_custom_1610700458155{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9123" alignment="center" css=".vc_custom_1610730883006{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" css=".vc_custom_1610700720672{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9121" alignment="center" css=".vc_custom_1610730894187{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - Services
	$data = array();
	$data['name'] = esc_html__( 'Company - Services', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general services';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1608193681640{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column enable_pin="enable_pin" width="5/12" offset="vc_col-md-4" responsive_css="padding_right_medium:7%25"][vc_row_inner][vc_column_inner responsive_css="margin_bottom_medium:45px" css=".vc_custom_1608194013763{margin-bottom: 30px !important;}"][ld_custom_menu source="custom" use_theme_fonts="" menu_font="font_family:Montserrat%3Aregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Research%20and%20Development%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Startup%20Investment%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Leading%20Experience%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Zero%20Broker%20Commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%5D" fs="15px" color="rgb(51, 51, 51)" bg_color="rgb(247, 248, 250)" bg_hcolor="rgb(233, 233, 233)" spacing="3" fw="700" ls="0.01em"][/vc_column_inner][vc_column_inner css=".vc_custom_1608195737477{margin-bottom: 30px !important;padding-top: 35px !important;padding-right: 20px !important;padding-bottom: 35px !important;padding-left: 20px !important;background-color: #f7f8fa !important;border-radius: 5px !important;}" responsive_css="margin_bottom_medium:45px|padding_right_medium:35px|padding_left_medium:35px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:19px" margin="bottom_small:1.25em"]Get a Free Quote[/ld_fancy_heading][ld_cf7 id="259" shape="lqd-contact-form-inputs-filled" roundness="lqd-contact-form-inputs-round" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" bm="10px" fs="15px" submit_fs="15px" lqd_bg_color="rgb(255, 255, 255)" color="rgb(127, 130, 132)" css=".vc_custom_1612175247123{margin-bottom: 0px !important;}" h_color="rgb(0, 0, 0)" submit_bg_color="rgb(24, 67, 65)" submit_border_color="rgb(24, 67, 65)"][/vc_column_inner][vc_column_inner css=".vc_custom_1608195709893{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;border-left-color: rgba(112,112,112,0.15) !important;border-left-style: solid !important;border-right-color: rgba(112,112,112,0.15) !important;border-right-style: solid !important;border-top-color: rgba(112,112,112,0.15) !important;border-top-style: solid !important;border-bottom-color: rgba(112,112,112,0.15) !important;border-bottom-style: solid !important;border-radius: 3px !important;}" responsive_css="padding_right_large:35px|padding_left_large:50px|padding_right_medium:15px|padding_left_medium:15px|padding_right_small:10px|padding_left_small:10px"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-medium" i_shape="circle" i_border="" position="iconbox-side" items_alignment="align-items-center" i_icon_linea="lqd-icn-ess icon-lqd-pen" title="Toll Free Call Center:" custom_heading_size="15px" custom_i_size="65px" css=".vc_custom_1608194633885{margin-bottom: 0px !important;}" icon_size="20px" title_mb="1" i_color="rgb(38, 176, 95)" h_color="rgb(160, 160, 160)" shape_color="rgba(38, 176, 95, 0.1)"]<span style="font-size: 20px; color: #292929;">+48 4348 80 32</span>[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-0 vc_col-md-8" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1610729062932{margin-bottom: 35px !important;}"][ld_content_box template="s01b" box_height_b="h-pt-60" use_custom_fonts_title="true" title="Research and Development" image="9038" overlay_color="linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, rgba(24, 27, 49, 0.6) 100%)" ls="0" label="Business Analytics" fw="700"]Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_content_box][ld_spacer height="30pxpx" md_height="45px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Data Analysis[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off campus or even spend semesters overseas. One Construction employs over 3 000 employees, the majority of whom are based on project sites.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][vc_separator color="custom" accent_color="rgba(0,0,0,0.1)" css=".vc_custom_1608195050020{margin-top: 10px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Plan Benefits[/ld_fancy_heading][vc_row_inner][vc_column_inner width="1/2"][ld_custom_menu source="custom" icon_pos="icon-next-to-label" items="%5B%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Immediate%20settlement%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Zero%20broker%20commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Guaranteed%20by%20the%20services%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Infrastructure%20solutions%20%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" icon_color="rgb(38, 176, 95)" spacing="15"][/vc_column_inner][vc_column_inner width="1/2"][ld_custom_menu source="custom" icon_pos="icon-next-to-label" items="%5B%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Immediate%20settlement%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Zero%20broker%20commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Guaranteed%20by%20the%20services%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Infrastructure%20solutions%20%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" icon_color="rgb(38, 176, 95)" spacing="15"][/vc_column_inner][/vc_row_inner][vc_separator color="custom" accent_color="rgba(0,0,0,0.1)" css=".vc_custom_1608195223630{margin-top: 20px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Questions? You’re covered.[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="30px" fs="16px" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(247, 248, 250)" active_bg_color="rgb(24, 67, 65)" heading_color="rgb(24, 67, 65)" active_heading_color="rgb(255, 255, 255)" exp_color="rgb(24, 67, 65)" active_exp_color="rgb(255, 255, 255)" lh="1.5em" border_color="rgb(247, 248, 250)" active_border_color="rgb(24, 67, 65)"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608195246481-cdcf9380-7c98"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608195398248-a9ad0a33-4d60"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608195413119-53c7aa0b-0417"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - What We Do
	$data = array();
	$data['name'] = esc_html__( 'Company - What We Do', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-whatwedo.jpg' );
	$data['sort_name'] = 'What We Do';
	$data['custom_class'] = 'general what-we-do';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row gap="25" css=".vc_custom_1611248257778{padding-top: 80px !important;padding-bottom: 50px !important;}"][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" css=".vc_custom_1611049825683{margin-bottom: 45px !important;background-color: #ffffff !important;}" offset="vc_col-md-4" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:About||"][vc_single_image image="8738" css=".vc_custom_1607933290308{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Research and Development[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" css=".vc_custom_1611049834512{margin-bottom: 30px !important;background-color: #ffffff !important;}" offset="vc_col-md-4" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Course||"][vc_single_image image="8739" css=".vc_custom_1607933233844{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Science[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Startup Investment[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" css=".vc_custom_1611049844140{margin-bottom: 30px !important;background-color: #ffffff !important;}" offset="vc_col-md-4" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Course||"][vc_single_image image="8740" css=".vc_custom_1607933270102{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Leading Experience[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" offset="vc_col-md-4" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Service%20Detail||" css=".vc_custom_1611049851061{margin-bottom: 30px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D"][vc_single_image image="8740" css=".vc_custom_1607933282804{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Zero Commision[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" offset="vc_col-md-4" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Service%20Detail||" css=".vc_custom_1611049861827{margin-bottom: 30px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D"][vc_single_image image="8738" css=".vc_custom_1607933290308{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Science[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Leading Experience[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" offset="vc_col-md-4" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Service%20Detail||" css=".vc_custom_1611049869937{margin-bottom: 30px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D"][vc_single_image image="8739" css=".vc_custom_1607933309038{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Big Data Analysis[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - Case Studies
	$data = array();
	$data['name'] = esc_html__( 'Company - Case Studies', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-case-studies.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1611246786518{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column][ld_portfolio_listing style="style02" columns_gap="15" bottom_gap="30" post_type="liquid-portfolio" posts_per_page="10" show_button="yes" show_filter="yes" pagination="pagination" filter_enable_counter="yes" filter_lbl_all="All" filter_size="size-custom" filter_decoration="filters-underline" filter_align="justify-content-start" filter_mb="50" filter_weight="font-weight-medium" filter_title_size="size-lg" ib_style="btn-naked" ib_title="See more" color_type="lqd-pf-color-custom" filter_id="lqd-1608206666593-989a1a56-7757" color_primary="linear-gradient(0deg, #184341 0%, rgba(24, 67, 65, 0) 100%)" overlay_arrow_color="rgb(255, 255, 255)" filter_cats="marketing, analytics, business" filter_title="By Category" custom_filter_size="16px" filter_normal_color="rgb(152, 158, 155)" filter_hover_color="rgb(24, 67, 65)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - Help Center
	$data = array();
	$data['name'] = esc_html__( 'Company - Help Center', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-help-center.jpg' );
	$data['sort_name'] = 'Help Center';
	$data['custom_class'] = 'general help-center';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1608193681640{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column enable_pin="enable_pin" width="5/12" offset="vc_col-md-4"][vc_row_inner][vc_column_inner responsive_css="margin_bottom_medium:45px" css=".vc_custom_1608194013763{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" alignment="text-left" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" fs="text_small:15px" fh_bg="rgb(242, 244, 247)" padding="right_all:23%25|left_all:23%25|right_large:20px|left_large:20px|right_medium:30%25|left_medium:30%25|top_small:1em|right_small:25%25|bottom_small:1em|left_small:25%25" margin="bottom_small:2.5em"]Help Center[/ld_fancy_heading][ld_custom_menu source="custom" localscroll="yes" icon_pos="text-left" use_theme_fonts="" menu_font="font_family:Montserrat%3Aregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Research%20and%20Development%22%2C%22url%22%3A%22%23user-data-analysis%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Data%20Analysis%22%2C%22url%22%3A%22%23service-plans%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Startup%20Investment%22%2C%22url%22%3A%22%23business-consultation%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Leading%20Experience%22%2C%22url%22%3A%22%23user-data-analysis%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Zero%20Broker%20Commission%22%2C%22url%22%3A%22%23service-plans%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23business-consultation%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%5D" fs="15px" color="rgb(0, 0, 0)" hcolor="rgba(0, 0, 0, 0.8)" spacing="30"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="7/12" column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-7" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1608195694447{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em" el_id="user-data-analysis"]User Data Analysis[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="30px" fs="16px" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(247, 248, 250)" active_bg_color="rgb(24, 67, 65)" heading_color="rgb(24, 67, 65)" active_heading_color="rgb(255, 255, 255)" exp_color="rgb(24, 67, 65)" active_exp_color="rgb(255, 255, 255)" lh="1.5em" border_color="rgb(247, 248, 250)" active_border_color="rgb(24, 67, 65)"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608212680425-64a3c014-d69a"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608212680471-5ee8bf95-e50a"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608212680513-e1f720f5-ad09"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em" el_id="service-plans"]Service Plans[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="30px" fs="16px" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(247, 248, 250)" active_bg_color="rgb(24, 67, 65)" heading_color="rgb(24, 67, 65)" active_heading_color="rgb(255, 255, 255)" exp_color="rgb(24, 67, 65)" active_exp_color="rgb(255, 255, 255)" lh="1.5em" border_color="rgb(247, 248, 250)" active_border_color="rgb(24, 67, 65)"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608212710601-362f8763-2827"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608212710670-5bc8bcdb-700c"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608212710720-9d220adc-2ac1"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em" el_id="business-consultation"]Business Consultation[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="30px" fs="16px" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(247, 248, 250)" active_bg_color="rgb(24, 67, 65)" heading_color="rgb(24, 67, 65)" active_heading_color="rgb(255, 255, 255)" exp_color="rgb(24, 67, 65)" active_exp_color="rgb(255, 255, 255)" lh="1.5em" border_color="rgb(247, 248, 250)" active_border_color="rgb(24, 67, 65)"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608195246481-cdcf9380-7c98"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608195398248-a9ad0a33-4d60"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608195413119-53c7aa0b-0417"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - News
	$data = array();
	$data['name'] = esc_html__( 'Company - News', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-news.jpg' );
	$data['sort_name'] = 'News';
	$data['custom_class'] = 'general news';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1611050925587{padding-bottom: 60px !important;}" responsive_css="padding_bottom_medium:80px"][vc_column][ld_blog style="style16" grid_columns="2" pagination="ajax" ajax_trigger="click" post_type="post" posts_per_page="6" columns_gap="15" bottom_gap="50" ib_style="" ib_title="" ib_border="" filter_id="lqd-1534920817048-1378b2bc-925c" unique_id="1534920817049-ecdcfae3-4595" taxonomies="63" post_excerpt_length="20"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Company - Contact
	$data = array();
	$data['name'] = esc_html__( 'Company - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'company-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0"][vc_column][ld_google_map style="assassinsCreedIV" map_marker="html_marker" si_style="" si_size="" si_border="" zoom="14" address="Manhattan" map_height="580px"][/vc_column][vc_column css=".vc_custom_1607955432920{margin-top: -250px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:16px" margin="bottom_small:0.25em"]home - contact[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:50px" ls="text_small:-0.04em" fw="text_small:900" margin="bottom_small:0px"]contact us[/ld_fancy_heading][/vc_column][/vc_row][vc_row content_placement="middle"][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1607954640145{padding-top: 35px !important;padding-right: 50px !important;padding-bottom: 40px !important;padding-left: 50px !important;background-color: #ffffff !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.07)%22%7D%5D" responsive_css="margin_top_medium:-70px|padding_bottom_medium:20px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:1.1em" fs="text_small:20px"]Send a message[/ld_fancy_heading][ld_cf7 id="8654" shape="lqd-contact-form-inputs-filled" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" lqd_bg_color="rgb(247, 248, 248)" color="rgb(59, 75, 83)" css=".vc_custom_1607956230465{margin-bottom: 0px !important;}" submit_color="rgb(24, 67, 65)" bm="20px" submit_hbg_color="rgb(24, 67, 65)" submit_h_color="rgb(255, 255, 255)" submit_bg_color="rgb(255, 205, 40)" submit_border_color="rgb(255, 205, 40)" submit_hover_border_color="rgb(24, 67, 65)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" column_top_ontablet="yes" column_top_onmobile="yes" css=".vc_custom_1610101870866{padding-top: 80px !important;padding-bottom: 35px !important;}" offset="vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]Get in touch[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_large:14%25"]We’d love to hear from you.[/ld_fancy_heading][ld_fancy_heading tag="p"]We are here to answer any question you may have. As a partner of corporates, Liquid has more than 9,000 offices of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1607955116165{padding-top: 65px !important;padding-bottom: 65px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1577271562832{margin-bottom: 60px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_an_translate_y="0" responsive_align="text-center"][ld_fancy_heading tag="h2"]global offices[/ld_fancy_heading][ld_fancy_heading tag="p"]As a partner of corporates, Liquid has more than 9,000 offices of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" equal_height="yes" animation_preset="Fade In" ca_duration="1800" ca_delay="90"][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]Paris[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]290 Maryam Sprins 260,[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]Courbevoie, Paris, France[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+47 213 5941 295[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]Tokyo[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]37 Valentin Rapids Apt.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]Tokyo, Japan[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+17 113 6946 36[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]London[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]82 Bernie Greens Apt.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]London, UK[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+36 213 5941 295[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]New York[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]21 Valentin Rapids Apt.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]New Jersey, NYC[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+47 213 5941 295[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lookbook - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Lookbook - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'lookbook-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="top" equal_height="yes" content_placement="middle" responsive_css="padding_right_medium:100px" css=".vc_custom_1610708948914{background-color: #ffffff !important;}" data_tooltip="Lookbook"][vc_column width="1/2" offset="vc_col-md-6" el_class="z-index-2" responsive_css="padding_top_medium:0px|margin_bottom_small:0px|padding_right_small:0px|padding_left_small:0px" css=".vc_custom_1603706081765{margin-bottom: 30px !important;padding-top: 80px !important;padding-right: 15px !important;padding-left: 15px !important;}"][ld_hotspots image="4002" identities="%5B%7B%22title%22%3A%22Nike%20Air%20Max%20-%20%2499%22%2C%22description%22%3A%22A%20lookbook%20is%20a%20collection%20of%20photographs%20compiled%20to%20show%22%2C%22position%22%3A%22lqd-hotspot-t%22%2C%22top%22%3A%2233%25%22%2C%22right%22%3A%2225%25%22%7D%2C%7B%22title%22%3A%22Zara%20Top%20-%20%2439%22%2C%22description%22%3A%22A%20lookbook%20is%20a%20collection%20of%20photographs%20compiled%20to%20show%22%2C%22position%22%3A%22lqd-hotspot-b%22%2C%22top%22%3A%2253%25%22%2C%22left%22%3A%2247%25%22%7D%5D" custom_height="calc(100vh - 90px)"][ld_fancy_heading tag="h2" alignment="text-center" absolute_pos="yes" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:18vmin|text_small:38vw" lh="text_small:0.8em" position="right_small:0px|bottom_small:-0.175em|left_small:0px" margin="bottom_small:0px"]Look book[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-4" responsive_css="padding_top_medium:5vh|padding_right_medium:0px|padding_left_medium:0px|margin_top_small:0px" css=".vc_custom_1611259827164{margin-top: 32vw !important;padding-right: 15px !important;padding-left: 15px !important;}" responsive_align="text-center text-sm-left"][ld_fancy_heading tag="h6" alignment="text-center" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" vertical_txt="text-sm-vertical" absolute_pos="yes" use_custom_fonts_title="true" hover_text_outline_color="rgba(112, 112, 112, 0.3)" hover_text_outline_width="1px" fs="text_medium:45vh|text_small:30vw" margin="bottom_small:0px" position="left_medium:5vw|top_small:-6vw|right_small:5vw|left_small:17vw" el_class="z-index-0"]NEW[/ld_fancy_heading][ld_images_group_element img_size="50%" enable_hover3d="yes" image="3922" margin="bottom_small:35px" img_link="url:%23|||"][/ld_images_group_element][vc_row_inner][vc_column_inner responsive_align="text-center text-md-left"][ld_icon_box i_type="fontawesome" heading_size="custom" position="iconbox-inline" i_icon_fontawesome="fab fa-instagram" title="Kate Austen #hublookbook" title_mb="1" custom_heading_size="12px" icon_size="24px" i_color="rgb(203, 122, 64)" link="url:%23|||"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" css=".vc_custom_1610706659081{padding-top: 30px !important;padding-bottom: 30px !important;}" responsive_align="text-center"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="3.5%"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680551013-c4ceed9c-5033"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680669500-48e7a0c0-9aa4"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680690310-dbfa2d3b-f459"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680686463-d4457e6c-2630"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680685867-99f1df18-59f7"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680685273-64d8a2e0-7a83"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680684690-409cfc6e-a8f0"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680684146-5ff714e5-f19a"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680683551-95e4c64d-c441"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]2020 Editorial 2020 Editorial[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1610708893632{background-color: #ffffff !important;}" data_tooltip="Zara Women"][vc_column css=".vc_custom_1610376199246{margin-bottom: 60px !important;background-image: url(https://lookbookhub.liquid-themes.com/staging/wp-content/uploads/2021/01/image7@2x.jpg?id=3919) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-lg vc_hidden-md" responsive_css="margin_bottom_small:0px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-offset-3" responsive_align="text-center"][ld_fancy_heading tag="h2" alignment="text-center" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" vertical_txt="text-sm-vertical" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:50vh|text_small:80vw" margin="bottom_small:0px" hover_text_outline_color="rgb(255, 255, 255)" hover_text_outline_width="1px" lh="text_small:1em"]02[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_large:10vw|padding_left_large:35px|padding_right_medium:5vw|padding_left_medium:0px" css=".vc_custom_1603366557844{padding-right: 15px !important;padding-left: 15px !important;}" responsive_align="text-center text-sm-left"][vc_row_inner el_class="z-index-2"][vc_column_inner][ld_fancy_heading tag="h2" alignment="text-right" tag_to_inherite="h4" absolute_pos="yes" use_custom_fonts_title="true" use_inheritance="true" fs="text_small:38px" lh="text_small:1.2em" margin="bottom_small:0px" position="right_all:-20%25|left_all:60%25|top_medium:-50px|right_medium:-10%25|left_medium:50%25|top_small:-1em|left_small:0px"]Zara — [ld_br] Women[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_images_group_element img_size="50%" enable_hover3d="yes" image="4006" margin="bottom_small:35px" img_link="url:%23|||"][/ld_images_group_element][ld_button style="btn-naked" title="Shop this collection" hover_txt_effect="btn-hover-txt-liquid-x-alt" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)"][/vc_column][vc_column row_scale_bg_onhover="yes" width="1/2" css=".vc_custom_1610708615096{padding-top: 50vh !important;padding-bottom: 50vh !important;background-image: url(https://lookbookhub.liquid-themes.com/staging/wp-content/uploads/2021/01/image7@2x.jpg?id=3919) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_hidden-xs" responsive_align="text-center"][vc_row_inner][vc_column_inner offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h2" alignment="text-center" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" vertical_txt="text-sm-vertical" absolute_pos="yes" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.27)" fs="text_medium:50vh|text_small:80vw" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.22)" hover_text_outline_width="1px" lh="text_small:1em" position="top_small:-32vh|right_small:0px|left_small:0px"]02[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" luminosity="dark" enable_overlay="yes" responsive_css="padding_right_medium:12vw|padding_left_medium:12vw" overlay_bg="rgba(0, 0, 0, 0.35)" css=".vc_custom_1612252247744{background: #ffffff url(https://lookbookhub.liquid-themes.com/staging/wp-content/uploads/2021/02/fashionstore@2x.jpg?id=4017) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" data_tooltip="New Arrivals"][vc_column offset="vc_hidden-lg vc_hidden-md vc_hidden-sm" responsive_align="text-center"][ld_fancy_heading tag="h2" alignment="text-center" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" vertical_txt="text-sm-vertical" use_custom_fonts_title="true" fs="text_small:75vw" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.15)" hover_text_outline_width="1px" lh="text_small:1em"]03[/ld_fancy_heading][/vc_column][vc_column width="7/12"][ld_fancy_heading tag="h6" color="rgba(255, 255, 255, 0.7)"]Video Background[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:11vmin|text_small:16vw" lh="text_small:1.1em"]New Arrivals[/ld_fancy_heading][/vc_column][vc_column width="5/12" offset="vc_hidden-xs"][ld_fancy_heading tag="h2" alignment="text-center" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" vertical_txt="text-sm-vertical" use_custom_fonts_title="true" fs="text_small:50vh" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.15)" hover_text_outline_width="1px" lh="text_small:1em"]03[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1610708918033{padding-top: 80px !important;background-color: #ffffff !important;}" responsive_css="padding_top_small:0px" data_tooltip="Editorial"][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_large:10vw|padding_left_large:35px|padding_right_medium:5vw|padding_left_medium:0px" el_class="z-index-2" css=".vc_custom_1603365377988{padding-right: 15px !important;padding-left: 15px !important;}"][vc_row_inner el_class="z-index-2"][vc_column_inner][ld_fancy_heading tag="h2" alignment="text-right" tag_to_inherite="h4" absolute_pos="yes" use_custom_fonts_title="true" use_inheritance="true" fs="text_small:38px" lh="text_small:1.2em" margin="bottom_small:0px" position="left_large:-15%25|top_medium:-50px|left_medium:0px|top_small:-1em|left_small:0px"]Summer — [ld_br] Editorial[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_images_group_element img_size="50%" enable_hover3d="yes" image="3921" margin="bottom_small:35px" img_link="url:%23|||"][/ld_images_group_element][/vc_column][vc_column row_scale_bg_onhover="yes" width="1/2" css=".vc_custom_1610708636991{background-image: url(https://lookbookhub.liquid-themes.com/staging/wp-content/uploads/2021/01/Image5@2x.jpg?id=3920) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ld_spacer height="50vh" sm_height="100vh"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" responsive_css="padding_right_medium:100px" css=".vc_custom_1610708938843{background-color: #ffffff !important;}" data_tooltip="Collection"][vc_column width="1/2" css=".vc_custom_1610708688519{margin-bottom: 60px !important;padding-top: 50vh !important;padding-bottom: 50vh !important;background-image: url(https://lookbookhub.liquid-themes.com/staging/wp-content/uploads/2020/04/img-6@2x.jpg?id=42) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="margin_bottom_small:0px" responsive_align="text-center"][vc_row_inner][vc_column_inner offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h2" alignment="text-center" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" vertical_txt="text-sm-vertical" absolute_pos="yes" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.44)" fs="text_medium:50vh|text_small:80vw" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.5)" hover_text_outline_width="1px" lh="text_small:1em" position="top_small:-32vh|right_small:0px|left_small:0px"]05[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1603365631551{padding-right: 15px !important;padding-left: 15px !important;}"][ld_images_group_element img_size="50%" enable_side_label="yes" enable_hover3d="yes" image="43" label="Shop This Collection" label_color="rgb(0, 0, 0)" margin="bottom_small:35px" img_link="url:%23|||"][/ld_images_group_element][vc_row_inner responsive_css="padding_left_medium:55px"][vc_column_inner responsive_align="text-center text-md-left"][ld_icon_box i_type="fontawesome" heading_size="custom" position="iconbox-inline" i_icon_fontawesome="fab fa-instagram" title="Kate Austen #hublookbook" title_mb="1" custom_heading_size="12px" icon_size="24px" i_color="rgb(203, 122, 64)" link="url:%23|||"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" css=".vc_custom_1610376682116{margin-top: -90px !important;padding-top: 30px !important;padding-bottom: 30px !important;background-color: #ffffff !important;}" responsive_align="text-center"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="3.5%"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600680740127-d3ec6cd2-3889"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704659342-5573b344-effc"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704658636-c39339f2-37b3"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704658461-015ce51b-21d0"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704658302-caffcc72-5080"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704658122-1c36fc42-9457"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704657942-28dbefcd-f91b"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1610704657479-6c417581-420d"][ld_fancy_heading tag="p" whitespace="ws-nowrap" use_custom_fonts_title="true" color="rgb(185, 185, 185)" fs="text_small:15px" margin="bottom_small:0px"]New Arrivals New Arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Marketing - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Marketing - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'marketing-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center center" enable_overlay="yes" enable_row_dividers="yes" enable_loading_bg="yes" css=".vc_custom_1603179531850{padding-top: 160px !important;padding-bottom: 200px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/marketing-bg@2x-scaled.jpg?id=5865) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(12, 13, 14, 0.34)" responsive_css="padding_bottom_medium:100px|padding_top_small:100px" row_svg_divider="bottom_shape_type:12|bottom_shape_color:%23ffffff|bottom_shape_height:153"][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1595576723011{background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:13px" ls="text_small:0.1em" margin="bottom_small:1.8em"]Digital Marketing Agency[/ld_fancy_heading][ld_fancy_heading split_type="chars, words" highlight_type="lqd-highlight-custom-underline" duration="1300" delay="70" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" compressor="0.8" minfontsize="57" fs="text_large:100px|text_medium:90px|text_small:65px" lh="text_small:1.1em" ls="text_small:-0.02em" margin="bottom_small:0.3em" ca_init_translate_y="0" ca_init_translate_x="0" ca_init_rotate_z="3"]Unique digital ideas.[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" css=".vc_custom_1572887826278{margin-bottom: 30px !important;}"][ld_fancy_heading tag="p" delay="200" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.8)" fs="text_medium:21px|text_small:18px" start_delay="900" ca_init_translate_y="70" lh="text_small:1.62em"]We help our clients succeed by creating brand identities, digital experiences, and print materials.[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="1200" ca_delay="200" ca_init_translate_y="35"][ld_button style="btn-solid" title="Let's Talk" shape="circle" size="btn-lg" border="border-none" hover_txt_effect="btn-hover-txt-liquid-x" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1603179547119{margin-bottom: 10px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color="rgb(255, 0, 0)" fs="18px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color2="rgb(0, 127, 255)"][ld_button style="btn-default" title="Explore Hub" link_type="scroll_to_section" shape="circle" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1603179559060{margin-right: 12px !important;margin-bottom: 10px !important;margin-left: 12px !important;}" color="rgba(255, 255, 255, 0.25)" text_color="rgb(255, 255, 255)" lh="1.3em" fs="18px" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" bg_position="custom" css=".vc_custom_1595587371876{padding-top: 10px !important;padding-right: 25px !important;padding-bottom: 45px !important;padding-left: 25px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="-250px" bg_pos_v="40%" ca_duration="1800" ca_delay="200" ca_init_translate_y="45" ca_init_rotate_z="5" responsive_css="margin_top_medium:70px|padding_right_medium:0px|padding_left_medium:0px"][vc_column offset="vc_col-md-4" responsive_css="padding_right_medium:20px|padding_left_medium:20px"][ld_icon_box i_type="linea" heading_size="xs" i_shape="custombg" position="iconbox-side" title="Branding Strategy" icon_mb="1" css=".vc_custom_1612273959090{margin-bottom: 45px !important;}" i_shape_custom_bg="6223" i_icon_linea="lqd-icn-ess icon-lqd-compass" i_color="rgb(61, 94, 255)" i_color2="rgb(223, 57, 111)" custom_i_width="87px" custom_i_height="80px"]Creating brand identities, digital experiences, and prints.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" responsive_css="padding_right_medium:20px|padding_left_medium:20px"][ld_icon_box i_type="linea" heading_size="xs" i_shape="custombg" position="iconbox-side" title="Web Design" icon_mb="1" css=".vc_custom_1612273967100{margin-bottom: 45px !important;}" i_shape_custom_bg="6223" i_icon_linea="lqd-icn-ess icon-speech-bubble" i_color="rgb(61, 94, 255)" i_color2="rgb(223, 57, 111)"]Creating brand identities, digital experiences, and prints.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" responsive_css="padding_right_medium:20px|padding_left_medium:20px"][ld_icon_box i_type="linea" heading_size="xs" i_shape="custombg" position="iconbox-side" title="Trusted Experience" icon_mb="1" css=".vc_custom_1612273975310{margin-bottom: 45px !important;}" i_shape_custom_bg="6223" i_icon_linea="lqd-icn-ess icon-lqd-check" i_color="rgb(61, 94, 255)" i_color2="rgb(223, 57, 111)"]Creating brand identities, digital experiences, and prints.[/ld_icon_box][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1605623393505{padding-bottom: 90px !important;}" responsive_css="padding_top_medium:60px|padding_bottom_medium:60px|padding_bottom_small:90px"][vc_column align="text-center" responsive_align="text-md-left"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" cellalign="center" pagenationdots="yes" dots_bottom_offset="0px" dots_style="carousel-dots-style4"][ld_carousel_section title="Tab" tab_id="lqd-1595577691001-32470bc4-46d4"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-6" responsive_css="margin_top_medium:-10%25|padding_right_medium:7%25|padding_bottom_medium:0px" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" responsive_align="text-left" css=".vc_custom_1612274960212{padding-bottom: 30px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1.8em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:40px|text_small:32px"]Target mobile consumers and grow your brand.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_small:2.15em"]We provide digital experience services to startups and small businesses to looking for a partner of their digital media.[/ld_fancy_heading][ld_button style="btn-solid" title="Get Started" shape="circle" size="btn-sm" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1595578841603{padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color="rgb(255, 77, 84)" fs="18px" hover_color2="rgb(0, 127, 255)" i_margin_left="10px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_start_delay="500" ca_delay="180" css=".vc_custom_1606976246263{background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/Memphis-1-1.svg?id=5947) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_single_image image="6144" alignment="center"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595582162820-2fc3c6f6-ec7d"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-6" responsive_css="margin_top_medium:-10%25|padding_right_medium:7%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" responsive_align="text-center text-md-left" css=".vc_custom_1606977438759{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1.8em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2"]Let your audience know about your brand.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_small:2.15em"]We provide digital experience services to startups and small businesses to looking for a partner of their digital media.[/ld_fancy_heading][ld_button style="btn-solid" title="Get Started" shape="circle" size="btn-sm" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1595578841603{padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color="rgb(255, 77, 84)" fs="18px" hover_color2="rgb(0, 127, 255)" i_margin_left="10px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_start_delay="500" ca_delay="180" css=".vc_custom_1606976267414{background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/Memphis-1-1.svg?id=5947) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_single_image image="6057" alignment="center"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_move="yes" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1573301198431-6ff8827c-fef3" number="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23fd5c4c%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%234c7cfd%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%5D" size="4" move_speed="2"][/vc_column][/vc_row][vc_row css=".vc_custom_1605623456501{padding-top: 60px !important;padding-bottom: 50px !important;background-color: #f8fafc !important;}" el_id="portfolio" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" css=".vc_custom_1606977794931{margin-bottom: 20px !important;}" responsive_align="text-md-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1.8em"]Selected Projects[/ld_fancy_heading][ld_fancy_heading tag="h2"]Digital Case studies.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_small:2.15em" padding="right_large:15%25|left_large:15%25"]We provide digital experience services to startups and small businesses.[/ld_fancy_heading][/vc_column][vc_column][ld_portfolio_listing style="style01" columns_gap="15" bottom_gap="30" post_type="liquid-portfolio" posts_per_page="6" enable_item_animation="yes" show_filter="yes" custom_cursor_style="lqd-cc-icon-trigger" filter_enable_counter="yes" filter_lbl_all="All" filter_size="size-custom" filter_mb="30" show_button="yes" ib_style="btn-naked" ib_title="See more" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" color_type="lqd-pf-light" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" ib_i_add_icon="true" filter_id="1572892521874-40b18c53-ea57" color_primary="rgb(33, 33, 33)" pf_duration="1800" pf_delay="180" pf_init_translate_y="0" pf_init_rotate_x="0" filter_cats="branding, ecommerce, vertical-overlay" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_color="rgb(0, 0, 0)" ib_i_color="rgb(0, 0, 0)" custom_filter_size="16px"][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1602179251577{padding-top: 70px !important;padding-bottom: 25px !important;}" el_id="process" responsive_css="padding_top_medium:100px|padding_bottom_medium:80px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" css=".vc_custom_1612275012647{margin-bottom: 20px !important;}" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1em"]One step ahead[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:40px|text_small:32px"]Explore the creative process.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_small:2.15em" padding="right_large:15%25|left_large:15%25"]We provide digital experience services to startups and small businesses.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" responsive_css="padding_right_medium:10%25|padding_bottom_medium:0px" css=".vc_custom_1602178733584{padding-bottom: 30px !important;}"][ld_images_group_container parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" translate_from_y="95" translate_to_y="-110"][ld_images_group_element parallax="yes" scale_from_x="1.2" scale_from_y="1.2" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_overflow="yes" image="5871" translate_from_y="0"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_x="45" ca_init_rotate_z="2"][ld_icon_box i_type="linea" heading_size="sm" i_shape="circle" i_border="" position="iconbox-side" i_linked="iconbox-icon-linked" i_icon_linea="lqd-icn-ess icon-num-1" custom_i_size="64px" title="Global SEO Research" icon_size="22px" css=".vc_custom_1611261501272{margin-bottom: 55px !important;}"]Practical tools and features make it easier to build and manage your site.[/ld_icon_box][ld_icon_box i_type="linea" heading_size="sm" i_shape="circle" i_border="" position="iconbox-side" i_linked="iconbox-icon-linked" i_icon_linea="lqd-icn-ess icon-num-2" custom_i_size="64px" title="Social media integration" icon_size="22px" css=".vc_custom_1611261507728{margin-bottom: 55px !important;}"]Practical tools and features make it easier to build and manage your site.[/ld_icon_box][ld_icon_box i_type="linea" heading_size="sm" i_shape="circle" i_border="" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-num-3" custom_i_size="64px" title="Launching the Application" icon_size="22px" css=".vc_custom_1595583393498{margin-bottom: 55px !important;}"]Practical tools and features make it easier to build and manage your site.[/ld_icon_box][/vc_column][/vc_row][vc_row gap="0" row_scale_bg_onhover="yes"][vc_column row_scale_bg_onhover="yes" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2250px%22%2C%22blur_radius%22%3A%2280px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" css=".vc_custom_1606722264142{border-radius: 10px !important;}" translate_from_y="20" translate_to_y="-70"][vc_row_inner row_scale_bg_onhover="yes" bg_position="left center" enable_overlay="yes" responsive_css="padding_top_medium:300px|padding_bottom_medium:75px|padding_left_medium:50px" css=".vc_custom_1606722443480{padding-top: 70px !important;padding-right: 20px !important;padding-bottom: 70px !important;padding-left: 20px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2019/11/bg-2@2x.jpg?id=5820) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 10px !important;}" hover_overlay_bg="rgba(0, 0, 0, 0.19)"][vc_column_inner offset="vc_col-md-8" responsive_align="text-left"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" fs="text_large:35px|text_small:30px" lh="text_small:1.26em" margin="bottom_small:0.75em" compressor="0.7" minfontsize="38"]Watch the creative process behind the digital marketing.[/ld_fancy_heading][ld_button style="btn-naked" title="`{`ld_small`}`Click to Watch`{`/ld_small`}`See how it works" link_type="lightbox" i_type="linea" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" enable_icon_shadowbox="yes" i_add_icon="true" i_size="16px" i_shape_custom_size="62px" i_color="rgb(255, 255, 255)" i_fill_color2="rgba(255, 255, 255, 0.35)" i_fill_hcolor2="rgb(255, 255, 255)" fs="18px" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22rgba(255%2C255%2C255%2C0.35)%22%7D%5D" h_icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%23ffffff%22%7D%5D" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DIC9urbiVp4M|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_hcolor="rgb(0, 0, 0)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1612274798849{padding-top: 35px !important;padding-bottom: 85px !important;}" responsive_css="padding_top_medium:45px|padding_bottom_medium:45px" el_id="testimonials"][vc_column enable_column_shadowbox="yes" css=".vc_custom_1614760945508{margin-top: 85px !important;background-color: #ffffff !important;border-radius: 4px !important;}" offset="vc_col-lg-4 vc_col-md-5" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2235px%22%2C%22blur_radius%22%3A%2255px%22%2C%22shadow_color%22%3A%22rgba(83%2C%2083%2C%2097%2C%200.09)%22%7D%5D"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" ca_duration="1800" ca_delay="80"][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(254, 249, 246)" css=".vc_custom_1589206754553{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="6168" alignment="center" image_max_width="95px" css=".vc_custom_1610889250721{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(246, 254, 247)" css=".vc_custom_1589206742447{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="6185" alignment="center" css=".vc_custom_1611261468336{margin-bottom: 0px !important;}" image_max_width="105px"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(243, 243, 248)" css=".vc_custom_1589359018360{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="6164" alignment="center" image_max_width="105px" css=".vc_custom_1610887808174{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(246, 252, 254)" css=".vc_custom_1573385372520{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="6165" alignment="center" image_max_width="115px" css=".vc_custom_1610887790310{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(250, 246, 254)" css=".vc_custom_1589206775026{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="6186" alignment="center" image_max_width="95px" css=".vc_custom_1611261243408{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(252, 254, 246)" css=".vc_custom_1589206782722{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="6187" alignment="center" css=".vc_custom_1611261234336{margin-bottom: 0px !important;}" image_max_width="105px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" column_top_ontablet="yes" column_top_onmobile="yes" bg_position="left top" offset="vc_col-lg-8 vc_col-md-7" responsive_css="padding_top_medium:80px|padding_left_medium:8.5%25" css=".vc_custom_1612275026913{padding-top: 15px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2019/11/world.png?id=5822) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-left"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:40px|text_small:32px"]Hear from our happy clients.[/ld_fancy_heading][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" navarrow="6" navsize="carousel-nav-sm" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" shapesize="47px" nav_border_color="rgb(223, 223, 223)" nav_bg_hcolor="rgb(42, 42, 42)" nav_arrow_color_hover="rgb(255, 255, 255)"][ld_carousel_section title="Tab" tab_id="lqd-1595577808765-230a4d56-128a"][ld_testimonial template="style13" title="Matt Sanchez" position="ThemeForest Exclusive" avatar="6008"]“I think Hub is the best theme I ever saw this year. Amazing design, easy to customize and a design quality superlative account on its cloud platform.for the optimized performance”[/ld_testimonial][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595577265551-a0a6c56a-225f"][ld_testimonial template="style13" title="Daniel Rock" position="ThemeForest Exclusive" avatar="6010"]“I think Hub is the best theme I ever saw this year. Amazing design, easy to customize and a design quality superlative account on its cloud platform.for the optimized performance”[/ld_testimonial][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595577809214-bbaa1329-bddd"][ld_testimonial template="style13" title="Daniel Rock" position="ThemeForest Exclusive" avatar="6009"]“I think Hub is the best theme I ever saw this year. Amazing design, easy to customize and a design quality superlative account on its cloud platform.for the optimized performance”[/ld_testimonial][/ld_carousel_section][/ld_carousel_tab][ld_particles as_bg="yes" absolute_pos="yes" enable_density="yes" color_type="multi_color" opacity="1" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="top" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1579874781983-fb436513-72aa" height="100vh" position="right_small:0px|bottom_small:0px" number="7" multi_color_values="%5B%7B%22scolor%22%3A%22%23f27e3f%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%2C%7B%22scolor%22%3A%22%2348bb0f%22%7D%2C%7B%22scolor%22%3A%22%233ff292%22%7D%2C%7B%22scolor%22%3A%22%23899bff%22%7D%5D" size="5" anim_size_speed="1" anim_size_min="50" density="200"][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1602180575452{padding-bottom: 20px !important;}" responsive_css="padding_top_medium:35px|padding_right_medium:100px|padding_left_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" css=".vc_custom_1612275120149{margin-bottom: 20px !important;}" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1em"]One step ahead[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:40px|text_small:32px"]Read the latest news.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_large:2.15em|bottom_small:1.2em" padding="right_large:15%25|left_large:15%25"]We provide digital experience services to startups and small businesses.[/ld_fancy_heading][/vc_column][/vc_row][vc_row responsive_css="padding_right_medium:80px|padding_left_medium:80px"][vc_column][ld_blog style="style06" grid_columns="3" meta_type="cats" post_type="post" posts_per_page="3" columns_gap="20" bottom_gap="30" filter_id="lqd-1588852304002-aa9ed0ce-6ecf" unique_id="1588852304002-ce055b4b-b4fb" hover_title_color="rgb(0, 0, 0)" title_size="20px"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1602180654526{padding-top: 80px !important;padding-bottom: 80px !important;}" row_hide="hidden-xs hidden-sm"][vc_column offset="vc_col-md-2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(73, 75, 93)" fs="text_small:13px" lh="text_small:1.15em" margin="bottom_small:0.3em"]Looking for collaboration?[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:21px"]Hub Wired[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][vc_separator color="black" border_width="2" css=".vc_custom_1588076332680{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column][vc_column offset="vc_col-md-2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.21em" margin="bottom_small:0.75em"]290 Maryam Springs Courbevoie, NYC[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0.3em"]+1 827 48 89[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][vc_separator color="black" border_width="2" css=".vc_custom_1588076332680{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column][vc_column offset="vc_col-md-2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.21em" margin="bottom_small:0.75em"]Looking for a job? Send your resume[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0.3em"]info@hub.com[/ld_fancy_heading][/vc_column][/vc_row][vc_row enable_gradient="yes" enable_row_dividers="yes" css=".vc_custom_1612870817541{margin-top: 40px !important;padding-top: 160px !important;padding-bottom: 85px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/marketing-bg@2x-1-scaled.jpg?id=5958) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" gradient_bg="linear-gradient(90deg, rgb(52, 122, 255) 0.3184713375796178%, rgb(250, 65, 94) 100%)" row_svg_divider="top_shape_type:12|top_shape_color:%23ffffff|top_shape_height:65" responsive_css="margin_top_small:75px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" ca_duration="1600" ca_delay="200" ca_init_translate_y="65"][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" color="rgb(255, 255, 255)" fs="text_large:45px|text_small:32px" lh="text_small:1.26em" margin="bottom_small:0.75em" compressor="0.75" minfontsize="38"]Any questions à Projects? Let’s get started.[/ld_fancy_heading][ld_button style="btn-solid" title="Send a Message" shape="circle" size="btn-lg" i_type="linea" i_add_icon="true" css=".vc_custom_1595584965098{margin-right: 12px !important;margin-bottom: 15px !important;margin-left: 12px !important;padding-right: 1em !important;padding-left: 1em !important;}" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" lh="1.3em" fs="16px" hover_color="rgb(32, 35, 41)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-lqd-pen"][ld_button style="btn-default" title="Get started" shape="circle" size="btn-lg" css=".vc_custom_1573385436113{margin-right: 12px !important;margin-bottom: 15px !important;margin-left: 12px !important;padding-right: 1em !important;padding-left: 1em !important;}" color="rgba(255, 255, 255, 0.25)" text_color="rgb(255, 255, 255)" lh="1.3em" fs="16px" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//App Blocks - Homepage
	$data = array();
	$data['name'] = esc_html__( 'App Blocks - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'appblocks-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" data_tooltip="Find your music" responsive_css="padding_top_medium:6vh|padding_right_medium:10vw|padding_bottom_medium:0px|padding_left_medium:10vw|padding_bottom_small:100px" css=".vc_custom_1612169239907{padding-top: 160px !important;padding-bottom: 60px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;background-position: 0 0 !important;background-repeat: repeat !important;}" el_id="home"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1612169489054{margin-bottom: 35px !important;}" responsive_align="text-center text-sm-left" ca_duration="1600" ca_delay="160" ca_init_translate_y="45"][ld_fancy_heading use_custom_fonts_title="true" lh="text_small:1em" fs="text_large:5vw|text_medium:77px|text_small:17vw" color="rgb(0, 0, 0)" margin="bottom_small:0px" ls="text_small:-0.02em"]Experience[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" lh="text_small:1.1em" fs="text_large:5vw|text_medium:77px|text_small:23.5vw" gradient="linear-gradient(90deg, rgb(245, 58, 139) 15.923566878980886%, rgb(238, 112, 74) 50.63694267515923%, rgb(107,133,255) 99.68152866242038%)" ls="text_small:-0.02em" margin="bottom_small:0.35em"]magical sound.[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" padding="right_large:15%25" ca_init_translate_y="0"]Listen to playlists curated for every occasion. Get daily podcasts and music recommendations.[/ld_fancy_heading][vc_row_inner][vc_column_inner][ld_button style="btn-solid" title="App store `{`ld_span`}`Get it for free`{`/ld_span`}`" transformation="text-uppercase" shape="round" size="btn-lg" border="border-none" i_type="fontawesome" i_separator="btn-icon-sep" enable_row_shadowbox="yes" i_add_icon="true" i_icon_fontawesome="fab fa-apple" i_size="22px" color="rgb(44, 46, 49)" text_color="rgb(255, 255, 255)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.5em" fw="700" ls="0.05em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2240px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.13)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611745315515{margin-bottom: 25px !important;padding-top: 0.5em !important;padding-bottom: 0.5em !important;}"][vc_column_text]    Try for free. No credit card required.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_top_onmobile="yes" align="text-center" offset="vc_col-md-6" css=".vc_custom_1606982949576{margin-bottom: 30px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_align="text-center" responsive_css="margin_bottom_small:0px"][ld_images_group_element img_size="100%" image="189" margin="left_large:-18%25"][/ld_images_group_element][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1595673746671-a27c94f3-ba8e" number="7" multi_color_values="%5B%7B%22scolor%22%3A%22%2340f292%22%7D%2C%7B%22scolor%22%3A%22%2397dff4%22%7D%2C%7B%22scolor%22%3A%22%23ffefd2%22%7D%2C%7B%22scolor%22%3A%22%23ffe3d1%22%7D%5D" anim_opacity_speed="0.2" anim_opacity_min="0.5" size="4" move_speed="1.5" anim_size_speed="1" anim_size_min="70"][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" bg_position="right top" css=".vc_custom_1612169247317{padding-top: 80px !important;padding-bottom: 50px !important;background-color: #fafafa !important;}" data_tooltip="Simplify" responsive_css="padding_top_medium:17vh|padding_right_medium:6vw|padding_bottom_medium:6vh|padding_left_medium:6vw|padding_top_small:100px|padding_bottom_small:100px" el_id="about"][vc_column][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_large:0px|right_large:0px|top_medium:-2%25|right_medium:-39%25|top_small:-7%25|right_small:-100%25"][ld_images_group_element img_size="50%" image="108"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-left" offset="vc_col-md-7" ca_duration="1800" ca_delay="180" ca_init_translate_y="50" responsive_css="padding_right_medium:1vw|padding_left_medium:12%25" css=".vc_custom_1612169576217{margin-bottom: 50px !important;}" responsive_align="text-left"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="12px" fw="700" ls="0.05em" margin="bottom_small:1em"]App Store[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_large:4vw|text_medium:60px|text_small:12vw" lh="text_medium:1.25em|text_small:1.15em"]Simplify the playing music you love.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_large:20px" lh="text_large:1.4em" margin="right_all:3vw"]All in one  and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-5"][/vc_column][vc_column css=".vc_custom_1603190725904{background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/rowbg@2x.png?id=125) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_css="padding_top_medium:4vh|padding_right_medium:6vw|padding_left_medium:6vw"][vc_row_inner enable_content_animation="yes" gap="30" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="500" ca_delay="180" ca_init_translate_x="30" ca_init_translate_y="30" ca_init_rotate_z="2"][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1595673031105{margin-bottom: 45px !important;}"][ld_icon_box i_type="image" heading_size="custom" heading_weight="font-weight-semibold" title="Easy Connect." custom_heading_size="19px" title_mb="7" icon_mb="20" css=".vc_custom_1595837311240{margin-bottom: 0px !important;}" i_icon_image="140" svg_fill_color="rgb(255, 90, 65)"]Focus and target your audience through the right channels.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1595673037591{margin-bottom: 45px !important;}"][ld_icon_box i_type="image" heading_size="custom" heading_weight="font-weight-semibold" title="Live Podcast" custom_heading_size="19px" title_mb="7" icon_mb="20" css=".vc_custom_1595837226405{margin-bottom: 0px !important;}" i_icon_image="168" svg_fill_color="rgb(255, 90, 65)" custom_size="32px"]Focus and target your audience through the right channels.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1595673041485{margin-bottom: 45px !important;}"][ld_icon_box i_type="image" heading_size="custom" heading_weight="font-weight-semibold" title="Stream Music" custom_heading_size="19px" title_mb="7" icon_mb="20" css=".vc_custom_1595837208111{margin-bottom: 0px !important;}" i_icon_image="138" svg_fill_color="rgb(255, 90, 65)"]Focus and target your audience through the right channels.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1595673046558{margin-bottom: 45px !important;}"][ld_icon_box i_type="image" heading_size="custom" heading_weight="font-weight-semibold" title="Cross-Platform" custom_heading_size="19px" title_mb="7" icon_mb="20" css=".vc_custom_1595837193753{margin-bottom: 0px !important;}" i_icon_image="139" svg_fill_color="rgb(255, 90, 65)"]Focus and target your audience through the right channels.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_height="yes" content_placement="middle" css=".vc_custom_1612169257837{padding-top: 100px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;background-position: 0 0 !important;background-repeat: repeat !important;}" data_tooltip="Better Sound" responsive_css="padding_bottom_medium:150px|padding_top_small:150px" el_id="features"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_css="padding_top_medium:35px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" ls="text_small:0.05em" margin="bottom_small:1em"]Daily Podcasts[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:60px|text_small:12vw" lh="text_large:1.1em"]Enjoy live podcasts.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" ca_init_translate_y="0" start_delay="1150"]All in one  and startup solutions. Endless cases that make it highly flexible and adaptable in the app.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="High performance gaming mode" title_mb="1" custom_heading_size="18px" icon_size="21px" icon_mb="16" css=".vc_custom_1595835474587{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Smart and affordable mobility solutions" title_mb="1" custom_heading_size="18px" icon_size="21px" icon_mb="16" css=".vc_custom_1595835458681{margin-bottom: 15px !important;}"][/ld_icon_box][ld_spacer][ld_button style="btn-solid" title="See Live Podcasts" shape="round" i_type="fontawesome" i_add_icon="true" fs="18px" lh="1.15em" i_icon_fontawesome="fas fa-play" i_size="10px" i_margin_left="20px" color="rgb(44, 46, 49)" text_color="rgb(255, 255, 255)"][/vc_column][vc_column align="text-center" offset="vc_col-md-6" responsive_align="text-center"][ld_hotspots image="107" identities="%5B%7B%22title%22%3A%22Gaming%20Headphones%22%2C%22description%22%3A%22Focus%20and%20target%20your%20audience%20through%20the%20right%20channels.%22%2C%22position%22%3A%22lqd-hotspot-t%22%2C%22top%22%3A%2235%25%22%2C%22left%22%3A%2235%25%22%7D%2C%7B%22title%22%3A%22Smartphone%20Integration%22%2C%22description%22%3A%22Focus%20and%20target%20your%20audience%20through%20the%20right%20channels.%22%2C%22position%22%3A%22lqd-hotspot-t%22%2C%22top%22%3A%2220%25%22%2C%22right%22%3A%2227%25%22%7D%5D"][/vc_column][/vc_row][vc_row full_height="yes" content_placement="middle" luminosity="dark" css=".vc_custom_1612169328782{padding-top: 80px !important;padding-bottom: 80px !important;background-color: #000000 !important;background-position: 0 0 !important;background-repeat: repeat !important;}" data_tooltip="Better Sound" responsive_css="padding_top_medium:150px|padding_bottom_medium:150px|padding_top_small:100px|padding_bottom_small:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" ls="text_small:0.05em" margin="bottom_small:1em" color="rgba(255, 255, 255, 0.57)"]Live Composition Mode[/ld_fancy_heading][ld_fancy_heading tag="h2" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" ca_init_translate_x="0" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_x="0" lh="text_small:1.1em" padding="right_large:35%25" color="rgb(255, 255, 255)" fs="text_medium:65px|text_small:12vw"]Record and share.[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" ca_init_translate_y="0" color="rgba(255, 255, 255, 0.57)"]All in one  and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone in the community.[/ld_fancy_heading][ld_button style="btn-solid" title="Explore Daily Mix" shape="round" i_type="fontawesome" i_add_icon="true" fs="18px" lh="1.15em" i_icon_fontawesome="fas fa-music" i_size="13px" i_margin_left="20px" color="rgb(44, 46, 49)"][/vc_column][vc_column column_top_onmobile="yes" align="text-center" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|margin_bottom_small:0px|padding_top_small:60px" css=".vc_custom_1606983223802{margin-bottom: 20px !important;}" responsive_align="text-center"][ld_images_group_element img_size="60%" image="228"][/ld_images_group_element][/vc_column][/vc_row][vc_row full_height="yes" content_placement="bottom" css=".vc_custom_1606983448726{padding-top: 100px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;}" data_tooltip="Future. Here." responsive_css="padding_top_medium:0px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1603196621698{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" margin="bottom_small:0.5em" fs="text_medium:65px|text_small:12vw"]Enjoy live music.[/ld_fancy_heading][ld_fancy_heading tag="p" alignment="text-center" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_large:20px" lh="text_large:1.5em"]All in one  and startup solutions. Endless use-cases that make it highly flexible.[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="200" ca_delay="180" ca_init_translate_y="35"][ld_tabs style="style05" reverse_direction="true"][ld_tab_section title="Daily mix and playlists" tab_id="ld-1572605326229-8d6bb496-c1ed" desc="Enjoy nonstop music. Offering affordable goods from a global musicians."][vc_row_inner bg_position="center bottom" css=".vc_custom_1609869699461{padding-top: 30px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}"][vc_column_inner align="text-center" offset="vc_col-md-12" responsive_align="text-center"][vc_single_image image="233" alignment="center" css=".vc_custom_1611263315609{margin-bottom: 0px !important;}" image_max_width="250px"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Listen to music Ad-Free" tab_id="lqd-1595839609507-78032ced-fed5" desc="Enjoy nonstop music. Offering affordable goods from a global musicians."][vc_row_inner bg_position="center bottom" css=".vc_custom_1609869687806{padding-top: 30px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}"][vc_column_inner align="text-center" offset="vc_col-md-12" responsive_align="text-center"][vc_single_image image="225" alignment="center" css=".vc_custom_1609869949820{margin-bottom: 0px !important;}" image_max_width="300px"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Automated System" tab_id="ld-1572605342976-8de33163-8234" desc="Ad-free music listening, play offline, on-demand playback for everyone."][vc_row_inner bg_position="center bottom" css=".vc_custom_1609869715085{padding-top: 30px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}"][vc_column_inner align="text-center" offset="vc_col-md-12" responsive_align="text-center"][vc_single_image image="225" alignment="center" css=".vc_custom_1609869943833{margin-bottom: 0px !important;}" image_max_width="300px"][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row][vc_row full_height="yes" content_placement="middle" css=".vc_custom_1612169289087{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;background-position: 0 0 !important;background-repeat: repeat !important;}" data_tooltip="Available for all devices" el_id="download"][vc_column width="5/6" offset="vc_hidden-lg vc_hidden-md vc_col-xs-offset-1 vc_col-xs-10"][vc_single_image image="222" alignment="center"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_align="text-center text-md-left" ca_duration="1600" ca_delay="160" ca_init_translate_y="65"][ld_fancy_heading tag="h2" split_type="words" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" ca_init_translate_x="0" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_x="0" lh="text_small:1.1em" compressor="0.7" minfontsize="50" fs="text_medium:60px|text_small:12vw" padding="right_large:25%25"]Available for all devices.[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" padding="right_large:15%25" ca_init_translate_y="0"]All in one  and startup solutions. Endless use-cases that make it highly adaptable.[/ld_fancy_heading][vc_row_inner][vc_column_inner][ld_button style="btn-solid" title="App store `{`ld_span`}`Get it for free`{`/ld_span`}`" transformation="text-uppercase" shape="round" size="btn-lg" border="border-none" i_type="fontawesome" i_separator="btn-icon-sep" enable_row_shadowbox="yes" i_add_icon="true" i_icon_fontawesome="fab fa-apple" i_size="22px" color="rgb(44, 46, 49)" text_color="rgb(255, 255, 255)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.5em" fw="700" ls="0.05em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2240px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.13)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611745327563{margin-bottom: 25px !important;padding-top: 0.5em !important;padding-bottom: 0.5em !important;}"][vc_column_text]    Try for free. No credit card required.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs"][ld_images_group_element image="222" margin="bottom_large:-5vw"][/ld_images_group_element][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-ld-1572606562223-6c86d24f-61ae" number="7" multi_color_values="%5B%7B%22scolor%22%3A%22%2340f292%22%7D%2C%7B%22scolor%22%3A%22%2397dff4%22%7D%2C%7B%22scolor%22%3A%22%23ffefd2%22%7D%2C%7B%22scolor%22%3A%22%23ffe3d1%22%7D%5D" anim_opacity_speed="0.2" anim_opacity_min="0.5" size="4" move_speed="1.5" anim_size_speed="1" anim_size_min="70"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Sticky Blog - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Sticky Blog - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'stickyblog-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" responsive_css="margin_left_medium:100px"][vc_column enable_pin="enable_pin" pin_offset="0px" pin_push_followers="yes" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1607001456792{padding-top: 15px !important;padding-right: 15px !important;padding-left: 15px !important;}"][ld_blog style="style17" post_type="post" posts_per_page="1" columns_gap="0" bottom_gap="0" filter_id="lqd-1579080936230-00097ade-9266" unique_id="1579080936231-4d1ef364-ff6e" overlay_color="linear-gradient(0deg, rgb(0, 0, 0) 0%, rgba(0, 0, 0, 0) 50.318471337579616%)"][/vc_column][vc_column offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1603278639314{padding-top: 70px !important;padding-right: 15px !important;padding-bottom: 70px !important;padding-left: 15px !important;}" responsive_css="padding_right_medium:0px|padding_left_medium:0px"][ld_blog style="style16" post_type="post" posts_per_page="5" columns_gap="15" bottom_gap="30" filter_id="lqd-1579081090460-b0a83b24-4925" unique_id="1579081090461-4ef82d7c-eadc" offset="1" post_excerpt_length="15" title_color="rgb(255, 255, 255)" excerpt_color="rgba(255, 255, 255, 0.65)" btn_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Startup - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Startup - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'startup-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" css=".vc_custom_1607065376522{padding-top: 160px !important;}" responsive_css="padding_top_medium:0px|padding_right_medium:10vw|padding_left_medium:10vw"][vc_column][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_all:0px|top_large:-20%25|right_large:0px|top_medium:-15%25|top_small:-10%25|right_small:-10%25"][ld_images_group_element image="4409"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-5 vc_col-md-7"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22payments.%22%7D%2C%7B%22word%22%3A%22tax%20forms.%22%7D%2C%7B%22word%22%3A%22contracts.%22%7D%5D" use_custom_fonts_title="true" gradient="linear-gradient(156deg, #3d00c6 0%, rgb(241,77,255) 70.06369426751593%)" fs="text_large:6.5vw|text_small:17vw" lh="text_small:0.85em" ls="text_small:-0.02em" margin="bottom_small:0.35em" fw="text_small:700"]Online[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(49, 63, 88)" fs="text_small:20px" lh="text_small:1.45em" margin="bottom_small:1.25em"]The ultimate one-click collection crafted by world-class designers. Give it a try![/ld_fancy_heading][ld_spacer height="15px"][ld_newsletter use_opt_in="Yes" style="solid" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" inputs_border="ld-sf--border-none" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" btn_label="Get started" btn_position="ld-sf--button-inline" enable_btn_shadowbox="yes" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" placeholder_text="Enter your email address" fs="16px" label_fs="17px" btn_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%227px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22rgba(132%2C92%2C255%2C0.2)%22%7D%5D" txt_color="rgb(49, 63, 88)" bg_color="rgb(255, 255, 255)" txt_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(255, 255, 255)" btn_bg_color="rgb(132, 92, 255)" hover_btn_txt_color="rgb(255, 255, 255)" hover_btn_bg_color="rgb(132, 92, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="15px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" color="rgb(0, 0, 0)"]   Try for free. No credit card required.[/ld_fancy_heading][/vc_column][vc_column width="5/6" offset="vc_col-lg-offset-1 vc_col-lg-6 vc_col-md-offset-0 vc_col-md-5 vc_col-sm-offset-1"][ld_images_group_element enable_float_effect="yes" float_easing="ease-in-out" image="792"][/ld_images_group_element][/vc_column][/vc_row][vc_row bg_position="center top" css=".vc_custom_1614256024634{padding-top: 30px !important;padding-bottom: 50px !important;background-image: url(https://startuphub.liquid-themes.com/staging/wp-content/uploads/2020/04/bg-2.png?id=774) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" el_id="features"][vc_column enable_overlay="yes" offset="vc_col-md-1/5" hover_overlay_bg="rgb(255, 255, 255)"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_move="yes" enable_random_move="yes" move_out_mode="bounce" enable_bounce_move="yes" detect_on="canvas" enable_onhover="yes" onhover_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1572443460220-dc1d628a-7076" height="calc(100% - 2em)" number="80" size="2" move_speed="1.5" position="top_small:0px|right_small:0px" modes_bubble_distance="100" modes_bubble_size="5" modes_bubble_duration="2" color="#b7eef5"][ld_icon_box i_type="image" heading_size="sm" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow-hover" title="Private Cloud Servers" icon_mb="22" css=".vc_custom_1611667901263{padding-top: 22px !important;padding-right: 35px !important;padding-bottom: 22px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" title_mb="1" fill_color="rgba(255, 255, 255, 0)" i_icon_image="4415" custom_size="75px"][/ld_icon_box][/vc_column][vc_column width="1/2" enable_overlay="yes" offset="vc_col-md-1/5" hover_overlay_bg="rgb(255, 255, 255)"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_move="yes" enable_random_move="yes" move_out_mode="bounce" enable_bounce_move="yes" detect_on="canvas" enable_onhover="yes" onhover_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1572443517426-42b5ca63-7b62" height="calc(100% - 2em)" number="80" size="2" move_speed="1.5" position="top_small:0px|right_small:0px" modes_bubble_distance="100" modes_bubble_size="5" modes_bubble_duration="2" color="#c8aee2"][ld_icon_box i_type="image" heading_size="sm" get_bubble_classname="iconbox-bubble" get_content_hover_classname="iconbox-contents-show-onhover" shadow="iconbox-shadow-hover" title="Extended Network" icon_mb="22" css=".vc_custom_1614258441090{padding-top: 22px !important;padding-right: 35px !important;padding-bottom: 22px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" title_mb="1" i_icon_image="4426" custom_size="75px"]Solutions The ultimate one-click collection crafted by world-class designers.[/ld_icon_box][/vc_column][vc_column width="1/2" enable_overlay="yes" offset="vc_col-md-1/5" hover_overlay_bg="rgb(255, 255, 255)"][ld_icon_box i_type="image" heading_size="sm" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow-hover" title="Daily Auto Update" icon_mb="22" css=".vc_custom_1614258463142{padding-top: 22px !important;padding-right: 35px !important;padding-bottom: 22px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" title_mb="1" fill_color="rgba(255, 255, 255, 0)" i_icon_image="4418" custom_size="75px"][/ld_icon_box][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_move="yes" enable_random_move="yes" move_out_mode="bounce" enable_bounce_move="yes" detect_on="canvas" enable_onhover="yes" onhover_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1572443562777-00947b64-f0de" height="calc(100% - 2em)" number="80" size="2" move_speed="1.5" position="top_small:0px|right_small:0px" modes_bubble_distance="100" modes_bubble_size="5" modes_bubble_duration="2" color="#bbfff0"][/vc_column][vc_column width="1/2" enable_overlay="yes" offset="vc_col-md-1/5" hover_overlay_bg="rgb(255, 255, 255)"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_move="yes" enable_random_move="yes" move_out_mode="bounce" enable_bounce_move="yes" detect_on="canvas" enable_onhover="yes" onhover_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1572443575990-aa4c82da-ac33" height="calc(100% - 2em)" number="80" size="2" move_speed="1.5" position="top_small:0px|right_small:0px" modes_bubble_distance="100" modes_bubble_size="5" modes_bubble_duration="2" color="#b7eef5"][ld_icon_box i_type="image" heading_size="sm" get_bubble_classname="iconbox-bubble" get_content_hover_classname="iconbox-contents-show-onhover" shadow="iconbox-shadow-hover" title="Mobility Solutions" icon_mb="22" css=".vc_custom_1614258423638{padding-top: 22px !important;padding-right: 35px !important;padding-bottom: 22px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" title_mb="1" i_icon_image="4417" custom_size="75px"]Integration The ultimate one-click collection crafted by world-class designers.[/ld_icon_box][/vc_column][vc_column width="1/2" enable_overlay="yes" offset="vc_col-md-1/5" hover_overlay_bg="rgb(255, 255, 255)"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_move="yes" enable_random_move="yes" move_out_mode="bounce" enable_bounce_move="yes" detect_on="canvas" enable_onhover="yes" onhover_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1572442599474-6c8c8e25-e98c" height="calc(100% - 2em)" number="100" size="2" move_speed="1.5" position="top_small:0px|right_small:0px" modes_bubble_distance="100" modes_bubble_size="5" modes_bubble_duration="2" color="#f9b5c6"][ld_icon_box i_type="image" heading_size="sm" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow-hover" title="Google Analytics" icon_mb="22" css=".vc_custom_1611668087354{padding-top: 22px !important;padding-right: 35px !important;padding-bottom: 22px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" title_mb="1" fill_color="rgba(255, 255, 255, 0)" i_icon_image="4416" custom_size="75px"][/ld_icon_box][/vc_column][/vc_row][vc_row bg_position="custom" css=".vc_custom_1614256163581{padding-top: 50px !important;padding-bottom: 60px !important;background-image: url(https://startuphub.liquid-themes.com/staging/wp-content/uploads/2020/04/bg-3.svg?id=776) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="-250px" bg_pos_v="0px" responsive_css="padding_bottom_medium:100px" el_id="solutions"][vc_column][ld_tabs style="style09c" reverse_direction="true" use_custom_fonts_nav="true" text_color="rgb(6, 59, 82)" primary_hcolor="rgb(255, 255, 255)" text_hcolor="rgb(255, 77, 18)" fs="14px" lh="2em" ls="0.02em" nav_bg_color="rgb(235, 240, 243)"][ld_tab_section title="Connect and Start" tab_id="lqd-1595766376021-83e4c2ad-77e6"][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-5"][vc_single_image image="4402" alignment="right" image_max_width="480px"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-5"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:50px" lh="text_small:1.02em"]Secure and Affordable.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.45em" margin="bottom_small:1.25em"]Complete Design Toolkit – huge collection of elements, rich customization options, flexible layouts, and instant results! Choose a pre-built header or create a custom layout that perfectly suits your needs.[/ld_fancy_heading][ld_button style="btn-naked" title="Get started" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Private Chat Groups" tab_id="lqd-1588148933707-1ecc953f-1e65"][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-5"][vc_single_image image="4404" alignment="right" image_max_width="340px"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:50px" lh="text_small:1.02em"]Online payment discount[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.45em" margin="bottom_small:1.25em"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][ld_button style="btn-solid" title="Get started" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Edit Contact List" tab_id="lqd-1588151567327-2e3a34a8-3184"][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-5"][vc_single_image image="4403" alignment="right" image_max_width="410px"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:50px" lh="text_small:1.02em"]Track and analyze business reports.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.45em" margin="bottom_small:1.25em"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][ld_button style="btn-solid" title="Get started" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Platform Integration" tab_id="lqd-1595763290229-377fd0f7-fef1"][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-5"][vc_single_image image="4404" alignment="right" image_max_width="340px"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:50px" lh="text_small:1.02em"]Multiple Platform Integration.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.45em" margin="bottom_small:1.25em"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][ld_button style="btn-solid" title="Get started" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row][vc_row content_placement="middle" bg_position="custom" css=".vc_custom_1614256046606{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;padding-bottom: 50px !important;background-image: url(https://startuphub.liquid-themes.com/staging/wp-content/uploads/2020/07/startup-rowBG.svg?id=4407) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;border-left-color: #eeee22 !important;border-right-color: #eeee22 !important;border-top-color: #eeee22 !important;border-bottom-color: #eeee22 !important;}" bg_pos_h="66vw" bg_pos_v="0%" responsive_css="margin_top_medium:-40px|padding_top_medium:70px|padding_bottom_medium:70px" el_id="usecases"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="65" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1607065973424{margin-bottom: 60px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_animation="lqd-highlight-grow-bottom" highlight_reset_onhover="lqd-highlight-reset-onhover" use_custom_fonts_title="true" fs="text_small:50px" lh="text_small:1.02em" highlight_color="rgba(175, 124, 255, 0.15)"]Online payment [ld_highlight]discount[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:20px" lh="text_small:29px" margin="bottom_small:1.65em"]Ultra high performance, intuitive editor, exclusive features, and award-winning design collection.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="xs" heading_weight="font-weight-normal" i_shape="circle" i_border="" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Track your daily activity." custom_i_size="30px" i_color="rgb(132, 92, 255)" shape_color="rgb(233, 232, 243)" css=".vc_custom_1611667535766{margin-bottom: 0.2em !important;}" icon_size="17px"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="xs" heading_weight="font-weight-normal" i_shape="circle" i_border="" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Start a private group video call" custom_i_size="30px" i_color="rgb(132, 92, 255)" shape_color="rgb(233, 232, 243)" css=".vc_custom_1611667513283{margin-bottom: 0.2em !important;}" icon_size="17px"][/ld_icon_box][ld_spacer][ld_button style="btn-solid" title="Get started" shape="round" hover_txt_effect="btn-hover-txt-liquid-x-alt" i_type="linea" i_hover_reveal="btn-hover-reveal" enable_row_shadowbox="yes" i_add_icon="true" fs="17px" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22rgba(132%2C92%2C255%2C0.2)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" lh="1.25em" css=".vc_custom_1588154661739{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="icon-md-arrow-round-forward"][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-md-6"][vc_row_inner][vc_column_inner parallax="yes" width="1/2" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" animation_preset="Fade In" translate_from_y="27" translate_to_y="-84" ca_duration="1800" ca_delay="80" responsive_align="text-center text-md-left"][ld_icon_box i_type="image" heading_size="sm" show_label="yes" alignment="text-left" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" title="Secure and Affordable" title_mb="21" icon_mb="24" css=".vc_custom_1614258873850{padding-top: 45px !important;padding-right: 35px !important;padding-bottom: 45px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" i_icon_image="4418" custom_size="68px" label="Exclusive" hover_fill_color="rgb(255, 255, 255)" hover_text_color="rgb(0, 0, 0)"]Use a pre-built header or create a custom one that perfectly suits your needs.[/ld_icon_box][ld_icon_box i_type="image" heading_size="sm" alignment="text-left" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" title="Track and analyze business reports" title_mb="20" icon_mb="23" css=".vc_custom_1614250464901{padding-top: 45px !important;padding-right: 35px !important;padding-bottom: 45px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" i_icon_image="4416" custom_size="68px" hover_fill_color="rgb(255, 255, 255)" hover_text_color="rgb(26, 26, 26)"]Use a pre-built header or create a custom one that perfectly suits your needs.[/ld_icon_box][/vc_column_inner][vc_column_inner parallax="yes" width="1/2" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" animation_preset="Fade In" responsive_css="margin_top_medium:34px" translate_from_y="-27" translate_to_y="70" ca_duration="1800" ca_start_delay="250" ca_delay="80"][ld_icon_box i_type="image" heading_size="sm" alignment="text-left" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" title="Multiple Platform Integration" title_mb="20" icon_mb="23" css=".vc_custom_1614250445996{padding-top: 45px !important;padding-right: 35px !important;padding-bottom: 45px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" i_icon_image="4426" custom_size="68px" hover_fill_color="rgb(255, 255, 255)" hover_text_color="rgb(19, 19, 19)"]Use a pre-built header or create a custom one that perfectly suits your needs.[/ld_icon_box][ld_icon_box i_type="image" heading_size="sm" show_label="yes" alignment="text-left" fill="yes" border_radius="iconbox-round" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" title="Mobility solutions tailored to you" title_mb="20" icon_mb="23" css=".vc_custom_1614258886152{padding-top: 45px !important;padding-right: 35px !important;padding-bottom: 45px !important;padding-left: 35px !important;}" h_color="rgb(34, 34, 34)" i_icon_image="4414" custom_size="68px" label="New" hover_fill_color="rgb(255, 255, 255)" hover_text_color="rgb(20, 20, 20)"]Use a pre-built header or create a custom one that perfectly suits your needs.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row bg_position="center top" css=".vc_custom_1614256038099{padding-bottom: 50px !important;background-image: url(https://startuphub.liquid-themes.com/staging/wp-content/uploads/2020/04/bg-2.png?id=774) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="margin_bottom_medium:70px|padding_top_medium:50px" el_id="integration"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center" fadesides="lqd-fade-sides" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428714688-cc703bb5-fbc6"][ld_icon_box i_type="image" get_bubble_classname="iconbox-bubble" get_content_hover_classname="iconbox-contents-show-onhover" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="772" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428714845-f3b92a23-4344"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="771" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428741879-b1bfcf2a-7e76"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="770" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428745953-9c60f44f-9e15"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="769" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428749822-973048db-a108"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="767" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428754067-008dbae0-2d76"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="763" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428757948-460785e0-337b"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="764" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428761906-f45e00fa-53d9"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="773" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428766025-9da6ad0c-4cb6"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="768" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428771003-636fd2c4-7179"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="771" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600428775638-351cb4b1-22d2"][ld_icon_box i_type="image" i_shape="square" i_size="xs" i_border="" enable_shape_shadowbox="yes" i_icon_image="769" title_mb="1" icon_mb="1" i_shape_border_radius="25" custom_i_size="75px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.1)%22%7D%5D"][/ld_icon_box][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1596109247090{padding-top: 20px !important;padding-bottom: 10px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605832601085{margin-bottom: 40px !important;}"][ld_images_group_element img_size="80%" enable_hover3d="yes" enable_float_effect="yes" image="4380"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" use_custom_fonts_title="true" fs="text_large:48px|text_small:45px" lh="text_small:1.02em" margin="bottom_large:30px" highlight_color="rgba(157, 95, 255, 0.16)"]Platform [ld_highlight]Integration[/ld_highlight][/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-circle" active_style="yes" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="18px" lh="1.55em" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" heading_color="rgb(21, 21, 23)" active_heading_color="rgb(21, 21, 23)" exp_color="rgb(131, 131, 131)" active_exp_color="rgb(77, 102, 255)" active_tab="1" border_color="rgb(255, 255, 255)" bottom_margin="0px"][vc_accordion_tab title="Track and analyze business reports" tab_id="lqd-1587034043819-84b84fd6-594f"][ld_fancy_heading tag="p" color="rgb(47, 47, 47)"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Increase your conversion rate" tab_id="lqd-1596289116665-e12466c4-780e"][ld_fancy_heading tag="p" color="rgb(47, 47, 47)"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="End-to-end encryption for messages" tab_id="lqd-1587034043874-e9d0bbcd-65a3"][ld_fancy_heading tag="p" color="rgb(47, 47, 47)"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row css=".vc_custom_1605833009940{padding-top: 40px !important;padding-bottom: 80px !important;}" row_hide="hidden-xs hidden-sm"][vc_column custom_border_radius="50em" responsive_css="border_top_medium:1px|border_right_medium:1px|border_bottom_medium:1px|border_left_medium:1px|padding_top_medium:32px|padding_right_medium:60px|padding_bottom_medium:32px|padding_left_medium:60px" css=".vc_custom_1605833063145{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;border-left-color: rgba(212,214,219,0.35) !important;border-left-style: solid !important;border-right-color: rgba(212,214,219,0.35) !important;border-right-style: solid !important;border-top-color: rgba(212,214,219,0.35) !important;border-top-style: solid !important;border-bottom-color: rgba(212,214,219,0.35) !important;border-bottom-style: solid !important;}" responsive_align="text-center text-md-left"][ld_process_box_container template="style05"][ld_process_box use_custom_fonts_title="true" title="Register your email" fs="16px" ls="0px" title_color="rgb(17, 36, 70)" count="01" image="800"][/ld_process_box][ld_process_box use_custom_fonts_title="true" title="Accept Invitations" fs="16px" ls="0px" title_color="rgb(17, 36, 70)"][/ld_process_box][ld_process_box use_custom_fonts_title="true" title="Start using your email" fs="16px" ls="0px" title_color="rgb(17, 36, 70)"][/ld_process_box][/ld_process_box_container][/vc_column][/vc_row][vc_row enable_gradient="yes" css=".vc_custom_1614256108710{margin-top: 50px !important;padding-top: 60px !important;}" gradient_bg="linear-gradient(180deg, rgb(248, 251, 255) 0.6369426751592356%, rgb(255, 255, 255) 99.04458598726114%)" responsive_css="margin_top_medium:0px|padding_top_medium:100px|padding_bottom_medium:100px" el_id="pricing"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1607066650054{margin-bottom: 25px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" use_custom_fonts_title="true" fs="text_small:50px" lh="text_small:1.02em" highlight_color="rgba(175, 124, 255, 0.15)"][ld_highlight]Simple[/ld_highlight] pricing for everyone[/ld_fancy_heading][/vc_column][vc_column][ld_tabs style="style10" primary_color="rgb(0, 209, 130)"][ld_tab_section title="Monthly" tab_id="ld-1573564745147-a273eb06-234c"][vc_row_inner enable_content_animation="yes" gap="20" animation_preset="Fade In" ca_duration="1800" ca_delay="80"][vc_column_inner enable_hover_move="lqd-column-move-onhover" hover_move_value="-6px" width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style04" show_button="yes" pt_style="btn-solid" pt_title="FREE FOREVER" pt_transformation="text-uppercase" pt_shape="circle" pt_border="border-none" use_custom_fonts_title="true" title="Free" description="Yearly" price="$0" footer_text="`{`ld_span font-size=``12px`` text_decoration=``underline```}`Upgrade your plan`{`/ld_span`}`" pt_color="rgb(244, 245, 248)" pt_text_color="rgb(0, 0, 0)" pt_fs="11px" pt_lh="1.25em" pt_ls="0.15em" pt_css=".vc_custom_1614259688477{padding-top: 0.15em !important;padding-right: 0.75em !important;padding-bottom: 0.15em !important;padding-left: 0.75em !important;}" accent_color="rgb(24, 22, 62)" fs="13px"] Full Service Payroll - Monthly Automate All Contracts Self Service Employee Support Extended Knowledgebase [/ld_price_table][/vc_column_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" hover_move_value="-7px" width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style04" featured="yes" show_button="yes" pt_style="btn-solid" pt_title="JOIN THIS PLAN" pt_transformation="text-uppercase" pt_shape="circle" pt_border="border-none" use_custom_fonts_title="true" title="popular" description="Yearly" price="$29" footer_text="`{`ld_span font-size=``12px`` color=``#fff`` text_decoration=``underline```}`Get your 30 day free trial`{`/ld_span`}`" pt_color="rgb(244, 245, 248)" pt_text_color="rgb(0, 0, 0)" pt_fs="11px" pt_lh="1.25em" pt_ls="0.15em" pt_css=".vc_custom_1614259668739{padding-top: 0.15em !important;padding-right: 0.75em !important;padding-bottom: 0.15em !important;padding-left: 0.75em !important;}" accent_color="rgb(32, 30, 50)" fs="13px"] Full Service Payroll - Monthly Automate All Contracts Self Service Employee Support Extended Knowledgebase [/ld_price_table][/vc_column_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" hover_move_value="-6px" width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style04" show_button="yes" pt_style="btn-solid" pt_title="JOIN THIS PLAN" pt_transformation="text-uppercase" pt_shape="circle" pt_border="border-none" use_custom_fonts_title="true" title="Exclusive" description="Yearly" price="$99" footer_text="`{`ld_span font-size=``12px`` text_decoration=``underline```}`Get your 30 day free trial`{`/ld_span`}`" pt_color="rgb(244, 245, 248)" pt_text_color="rgb(0, 0, 0)" pt_fs="11px" pt_lh="1.25em" pt_ls="0.15em" pt_css=".vc_custom_1614259727838{padding-top: 0.15em !important;padding-right: 0.75em !important;padding-bottom: 0.15em !important;padding-left: 0.75em !important;}" accent_color="rgb(24, 22, 62)" fs="13px"] Full Service Payroll - Monthly Automate All Contracts Self Service Employee Support Extended Knowledgebase [/ld_price_table][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Annually - Save 30%" tab_id="lqd-1600669213539-640e5bf0-943b"][vc_row_inner enable_content_animation="yes" gap="20" animation_preset="Fade In" ca_duration="1800" ca_delay="80"][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style04" show_button="yes" pt_style="btn-solid" pt_title="FREE FOREVER" pt_transformation="text-uppercase" pt_shape="circle" pt_border="border-none" use_custom_fonts_title="true" title="Free" description="Yearly" price="$0" footer_text="`{`ld_span font-size=``12px`` text_decoration=``underline```}`Upgrade your plan`{`/ld_span`}`" pt_color="rgb(244, 245, 248)" pt_text_color="rgb(0, 0, 0)" pt_fs="11px" pt_lh="1.25em" pt_ls="0.15em" pt_css=".vc_custom_1596193284384{padding-top: 0.15em !important;padding-right: 0.75em !important;padding-bottom: 0.15em !important;padding-left: 0.75em !important;}" accent_color="rgb(24, 22, 62)" fs="13px"] 300 GB Storage Unlimited Photos Exclusive Support Custom Branding [/ld_price_table][/vc_column_inner][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style04" featured="yes" show_button="yes" pt_style="btn-solid" pt_title="JOIN THIS PLAN" pt_transformation="text-uppercase" pt_shape="circle" pt_border="border-none" use_custom_fonts_title="true" title="popular" description="Yearly" price="$79" footer_text="`{`ld_span font-size=``12px`` color=``#fff`` text_decoration=``underline```}`Get your 30 day free trial`{`/ld_span`}`" pt_color="rgb(244, 245, 248)" pt_text_color="rgb(0, 0, 0)" pt_fs="11px" pt_lh="1.25em" pt_ls="0.15em" pt_css=".vc_custom_1611667575854{padding-top: 0.15em !important;padding-right: 0.75em !important;padding-bottom: 0.15em !important;padding-left: 0.75em !important;}" accent_color="rgb(39, 39, 58)" fs="13px"] 300 GB Storage Unlimited Photos Exclusive Support Custom Branding [/ld_price_table][/vc_column_inner][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style04" show_button="yes" pt_style="btn-solid" pt_title="JOIN THIS PLAN" pt_transformation="text-uppercase" pt_shape="circle" pt_border="border-none" use_custom_fonts_title="true" title="Exclusive" description="Yearly" price="$99" footer_text="`{`ld_span font-size=``12px`` text_decoration=``underline```}`Get your 30 day free trial`{`/ld_span`}`" pt_color="rgb(244, 245, 248)" pt_text_color="rgb(0, 0, 0)" pt_fs="11px" pt_lh="1.25em" pt_ls="0.15em" pt_css=".vc_custom_1596193317572{padding-top: 0.15em !important;padding-right: 0.75em !important;padding-bottom: 0.15em !important;padding-left: 0.75em !important;}" accent_color="rgb(24, 22, 62)" fs="13px"] 300 GB Storage Unlimited Photos Exclusive Support Custom Branding [/ld_price_table][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" bg_position="center center" css=".vc_custom_1607067543054{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;padding-top: 50px !important;padding-bottom: 40px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;border-left-color: #f2f2f2 !important;border-right-color: #f2f2f2 !important;border-top-color: #f2f2f2 !important;border-bottom-color: #f2f2f2 !important;}" responsive_css="padding_bottom_medium:75px"][vc_column offset="vc_col-md-6"][ld_testimonial template="style04" network="fa-twitter" title="Maria Sanchez, Hub CEO" avatar="4478"]“Les services de paiement sont disponibles via des applications mobilese bureau. “[/ld_testimonial][ld_testimonial template="style04" network="fa-whatsapp" title="Maria Sanchez, Hub CEO" avatar="4479" margin="right_large:-65px|left_large:65px"]“Les services de paiement sont disponibles via des applications mobilese bureau. “[/ld_testimonial][ld_testimonial template="style04" network="fa-twitter" title="Tom Becks, Hub CEO" avatar="4477"]“Les services de paiement sont disponibles via des applications mobilese bureau. “[/ld_testimonial][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1607067598266{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" gradient="linear-gradient(90deg, rgb(11, 79, 238) 0%, #ac1de1 100%)"]Why StartupHub[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:20px" lh="text_small:29px" margin="bottom_small:1.75em"]Complete Design Toolkit – huge collection of elements, rich customization options, flexible layouts, and instant results! Choose a pre-built header or create a custom layout that perfectly suits your needs.[/ld_fancy_heading][ld_button style="btn-solid" title="Get started" shape="round" hover_txt_effect="btn-hover-txt-liquid-x-alt" i_type="linea" i_hover_reveal="btn-hover-reveal" enable_row_shadowbox="yes" i_add_icon="true" fs="17px" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22rgba(132%2C92%2C255%2C0.2)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" lh="1.25em" css=".vc_custom_1588154661739{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="icon-md-arrow-round-forward"][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1595673746671-a27c94f3-ba8e" number="7" multi_color_values="%5B%7B%22scolor%22%3A%22%2340f292%22%7D%2C%7B%22scolor%22%3A%22%2397dff4%22%7D%2C%7B%22scolor%22%3A%22%23ffefd2%22%7D%2C%7B%22scolor%22%3A%22%23ffe3d1%22%7D%5D" anim_opacity_speed="0.2" anim_opacity_min="0.5" size="4" move_speed="1.5" anim_size_speed="1" anim_size_min="70"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1605833709875{padding-bottom: 70px !important;}" responsive_css="padding_top_medium:40px|padding_bottom_medium:40px"][vc_column align="text-center" css=".vc_custom_1588159798471{margin-bottom: 45px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Trusted by[/ld_fancy_heading][/vc_column][vc_column align="text-center" responsive_align="text-center"][ld_carousel_marquee_tab columns="md:5|xs:3|spacing_xs:2%25" cellalign="center" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428250615-4989a97c-9694"][vc_single_image image="4682" css=".vc_custom_1611668430694{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428434207-1f7690cd-1757"][vc_single_image image="4685" css=".vc_custom_1611668420537{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428461710-d9abacf9-c67e"][vc_single_image image="800" img_size="30x24" css=".vc_custom_1600428674389{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428479085-8469b200-802c"][vc_single_image image="4684" css=".vc_custom_1611668446288{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428502839-5cb03a59-01b9"][vc_single_image image="4681" css=".vc_custom_1611668467470{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600428523133-611aa506-328a"][vc_single_image image="4680" css=".vc_custom_1611668490009{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1605833547205{padding-bottom: 60px !important;}" responsive_css="margin_bottom_medium:100px|padding_top_medium:100px|padding_bottom_medium:100px"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2"]Latest Posts[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em"]Performance. Rock-solid structure and next-gen technologies deliver the maximum performance with minimum resources.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1587039540134{padding-top: 40px !important;}"][ld_blog style="style06" grid_columns="3" meta_type="cats" post_type="post" posts_per_page="3" columns_gap="20" bottom_gap="30" filter_id="lqd-1595765357802-2a176e9f-4b2d" unique_id="lqd-1595765357802-8df74a1f-4cd6" title_size="20px"][ld_gdpr_box]🍪 This website uses cookies to improve your web experience.[/ld_gdpr_box][/vc_column][/vc_row][vc_row enable_gradient="yes" gradient_bg="linear-gradient(179deg, #eef7fa 0.6369426751592356%, rgb(255, 255, 255) 100%)" css=".vc_custom_1605833651153{padding-top: 70px !important;padding-bottom: 50px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="65"][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" margin="bottom_small:0.3em" highlight_color="rgba(157, 95, 255, 0.1)"]Start your [ld_highlight]free trial.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="h4" color="rgba(21, 86, 108, 0.45)" margin="bottom_small:1.5em"]Ready to get started?[/ld_fancy_heading][ld_newsletter style="solid" inputs_size="ld-sf--size-xl" inputs_radius="ld-sf--round" inputs_shadow="ld-sf--input-shadow" btn_style="naked" btn_display="label_icon" btn_label="GET STARTED" btn_position="ld-sf--button-inside" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" placeholder_text="Your email address" fs="18px" label_fs="15px" label_ls="0.01em" txt_color="rgb(128, 129, 171)" txt_f_color="rgb(0, 0, 0)" margin="bottom_small:15px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][vc_column_text]    Try for free. No credit card required.[/vc_column_text][/vc_column][vc_column offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5 vc_hidden-sm vc_hidden-xs"][ld_images_group_container margin="top_large:-50%25"][ld_images_group_element enable_hover3d="yes" enable_float_effect="yes" image="766"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Startup - Help Center
	$data = array();
	$data['name'] = esc_html__( 'Startup - Help Center', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'startup-help-center.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general help-center';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row enable_gradient="yes" css=".vc_custom_1615285704454{margin-top: 50px !important;border-bottom-width: 1px !important;padding-top: 60px !important;border-bottom-color: #e8e8e8 !important;border-bottom-style: solid !important;}" gradient_bg="linear-gradient(180deg, rgb(248, 251, 255) 0.6369426751592356%, rgb(255, 255, 255) 99.04458598726114%)" responsive_css="margin_top_medium:0px|padding_top_medium:100px|padding_bottom_medium:60px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1607066650054{margin-bottom: 25px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Frequently Asked Questions[/ld_fancy_heading][ld_fancy_heading alignment="text-center" enable_txt_rotator="yes" items="%5B%7B%7D%5D" use_custom_fonts_title="true" gradient="linear-gradient(156deg, #3d00c6 0%, rgb(241,77,255) 70.06369426751593%)" fs="text_large:6.5vw|text_small:17vw" lh="text_small:0.85em" ls="text_small:-0.02em" margin="bottom_small:0.35em" fw="text_small:700"]Help Center[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="text_small:29px" padding="right_all:12%25|left_all:12%25" fs="text_small:20px"]Passionate about solving problems through creative communications. Offering affordable goods.[/ld_fancy_heading][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1573545920395-493fe50f-7472" number="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23fdc14c%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%234cfd89%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%5D" size="4.5" move_speed="1.75"][ld_particles as_bg="yes" shape_type="circle,image" opacity="1" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1573557379206-051874b7-46df" number="6" size="52" move_speed="1.75" color="#f7fbfc" image="504" image_width="110" image_height="62" anim_size_speed="1" anim_size_min="80"][/vc_column][/vc_row][vc_row bg_position="custom" css=".vc_custom_1606474718115{padding-top: 85px !important;padding-bottom: 15px !important;background-image: url(https://mainhub.liquid-themes.com/staging/wp-content/uploads/2019/11/dots-bg-1.png?id=4186) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="-20%"][vc_column][ld_images_group_container parallax="yes" move_to_parent_row="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" translate_from_y="48" translate_to_y="-175" position="top_small:-45px|left_small:10%25"][ld_images_group_element image="4845"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="200" ca_init_translate_y="35"][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" fs="18px" border_color="rgb(240, 242, 250)" exp_color="rgb(0, 109, 255)" bottom_margin="15px" heading_color="rgb(0, 35, 82)" fw="600"][vc_accordion_tab title="1. Problems sending or receiving messages" tab_id="ld-1573557703923-2b536dc1-8433"][vc_column_text]Passionate about solving problems through creative communications. Offering affordable goods.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="2. End-to-end encryption for messages" tab_id="ld-1573557848857-fe47078b-be98"][vc_column_text]Passionate about solving problems through creative communications. Offering affordable goods.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="3. Restore your chat history?" tab_id="ld-1573557855085-a110d9e8-dd5b"][vc_column_text]Passionate about solving problems through creative communications. Offering affordable goods.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="4. Deleting and clearing chats in the application" tab_id="ld-1573557971281-cb873053-3190"][vc_column_text]Passionate about solving problems through creative communications. Offering affordable goods.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="5. Getting messages from businesses" tab_id="ld-1573557979674-b9d6884a-b21e"][vc_column_text]Passionate about solving problems through creative communications. Offering affordable goods.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="6. Calling unavailable in some countries" tab_id="ld-1573557986530-b01574dd-230b"][vc_column_text]Passionate about solving problems through creative communications. Offering affordable goods.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row gap="25" css=".vc_custom_1606474843457{padding-top: 45px !important;padding-bottom: 45px !important;}" responsive_css="padding_bottom_medium:85px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1606474775216{margin-bottom: 40px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" compressor="0.7" minfontsize="32" margin="bottom_small:0.25em" fs="text_small:40px"]Online Assistance.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="17px" lh="29px" padding="right_large:6.5%25|left_large:6.5%25" margin="bottom_small:1.75em"]Passionate about solving problems through creative communications. Offering affordable goods.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][vc_column_inner offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="xs" i_shape="circle" i_border="" show_button="yes" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" ib_style="btn-underlined" ib_title="Support Center" ib_border="border-thick" i_icon_linea="lqd-icn-ess icon-lqd-pen" title="Submit a Ticket" icon_size="45px" fill_color="rgb(255, 255, 255)" icon_mb="23" css=".vc_custom_1615045480827{padding-top: 35px !important;padding-right: 35px !important;padding-bottom: 35px !important;padding-left: 35px !important;}" custom_i_size="85px" shape_color="rgba(17, 108, 222, 0.09)" ib_color="rgb(0, 0, 0)" ib_b_color="rgb(239, 239, 239)" i_color="rgb(17, 108, 222)"]Feel free to reach our support team for further assistance.[/ld_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="xs" i_shape="circle" i_border="" show_button="yes" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" ib_style="btn-underlined" ib_title="mail@liquid.com" ib_border="border-thick" i_icon_linea="lqd-icn-ess icon-lqd-envelope" title="Send a message" icon_size="45px" fill_color="rgb(255, 255, 255)" icon_mb="23" css=".vc_custom_1615045463242{padding-top: 35px !important;padding-right: 35px !important;padding-bottom: 35px !important;padding-left: 35px !important;}" custom_i_size="85px" shape_color="rgba(17, 108, 222, 0.1)" i_color="rgb(17, 108, 222)" ib_color="rgb(0, 0, 0)" ib_b_color="rgb(239, 239, 239)"]Feel free to reach our support team for further assistance.[/ld_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="xs" i_shape="circle" i_border="" show_button="yes" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" ib_style="btn-underlined" ib_title="+ 1. 328 873 20" ib_border="border-thick" i_icon_linea="lqd-icn-ess icon-lqd-user" title="Contacts Us" icon_size="45px" fill_color="rgb(255, 255, 255)" icon_mb="23" css=".vc_custom_1615045440827{padding-top: 35px !important;padding-right: 35px !important;padding-bottom: 35px !important;padding-left: 35px !important;}" custom_i_size="85px" shape_color="rgba(17, 108, 222, 0.11)" i_color="rgb(17, 108, 222)" ib_color="rgb(0, 0, 0)" ib_b_color="rgb(239, 239, 239)"]Feel free to reach our support team for further assistance.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Newsletter - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Newsletter - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'newsletter-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center bottom" sticky_row="yes" css=".vc_custom_1610357228901{padding-top: 150px !important;padding-bottom: 380px !important;background: #f7f8fb url(https://newsletterhub.liquid-themes.com/staging/wp-content/uploads/2019/11/people-2.svg?id=36) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:80px|padding_bottom_small:180px"][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container enable_item_animation="yes" move_to_parent_row="yes" pf_init_scale_x="0.75" pf_init_scale_y="0.75" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" absolute_pos="yes" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" pf_duration="1800" pf_delay="220" pf_init_translate_y="117"][ld_images_group_element parallax="yes" scale_from_x="1.1" scale_from_y="1.1" scale_from_z="1" from_opacity="1" scale_to_x="1.4" scale_to_y="1.4" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="28" translate_from_y="16" translate_to_y="-129" position="right_small:0px|bottom_small:0px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="number" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" ca_duration="1800" ca_delay="200" ca_init_translate_y="70" ca_init_rotate_x="0" translate_from_y="1" translate_to_y="-125" parallax_trigger_number="0.3" responsive_align="text-center"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22online%20forms%22%7D%2C%7B%22word%22%3A%22offline%20forms%22%7D%2C%7B%22word%22%3A%22any%20forms%22%7D%5D" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" fs="text_large:65px|text_medium:55px|text_small:13vw" lh="text_small:1em" word_colors="rgb(43, 189, 204)" padding="right_large:4%25|left_large:4%25" compressor="0.7" minfontsize="44"]Generate more innovative leads and[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:20px" margin="bottom_small:2.5em"]Beautiful layouts, super customizable, blazing fast, customer first approach.[/ld_fancy_heading][ld_newsletter enable_name_field="yes" show_inline="ld-sf--inputs-inline" style="bordered" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" inputs_border="ld-sf--border-none" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" btn_label="Sign up" btn_position="ld-sf--button-inline" btn_padding="0px" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" fs="16px" label_fs="16px" margin="bottom_small:0px" bg_color="rgb(255, 255, 255)" placeholder_text="Email address" placeholder_nametext="Your Name" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" label_fw="700" txt_color="rgb(110, 121, 130)"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1607064674952{padding-top: 25px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" ca_start_delay="650" responsive_css="padding_top_small:5px"][vc_column_inner width="1/4" offset="vc_col-lg-offset-3 vc_col-lg-2 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="30 Day Free Trial" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="No Hidden Fees" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Cancel Anytime" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" shape_type="triangle" opacity="1" enable_move="yes" move_direction="top" modes_grab_opacity="1" particle_id="ld-1579791733747-f28cf823-c73d" number="10" multi_color_values="%5B%7B%22scolor%22%3A%22%23ff7cac%22%7D%2C%7B%22scolor%22%3A%22%237ef3d6%22%7D%2C%7B%22scolor%22%3A%22%23ffe798%22%7D%5D" size="5" move_speed="1.75"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1605846833928{padding-top: 60px !important;padding-bottom: 40px !important;background-color: #ffffff !important;}" el_id="lqd-features" responsive_css="padding_top_medium:120px|padding_bottom_medium:60px"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-lg-6 vc_col-md-7" translate_from_y="30" translate_to_y="-103"][ld_tabs style="style03" nav_alignment="justify-content-md-start" tab_trigger="hover" use_custom_fonts_nav="true" text_color="rgb(132, 141, 156)" fs="18px" lh="0.5em" primary_hcolor="rgb(43, 189, 204)" primary_color="rgba(255, 255, 255, 0)" fw="400" ls="0.01em"][ld_tab_section title="Chat Assistance" tab_id="lqd-1595933910664-4cabc592-ea1e"][vc_row_inner enable_content_animation="yes" content_placement="middle" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_delay="200" ca_init_translate_y="35"][vc_column_inner][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:52px|text_small:44px" margin="bottom_small:0.35em"]Artificial automation customizes process.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" margin="bottom_small:1.5em" lh="text_small:27px"]Intuitive Header Builder – Choose a pre-built header or create a custom layout that perfectly suits your needs. It’s easy, fast and mobile-friendly.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_button style="btn-solid" title="Let’s get started" shape="circle" i_type="linea" i_add_icon="true" css=".vc_custom_1595933906935{margin-bottom: 15px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" fs="16px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(42, 42, 42)"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="AI Suggestions" tab_id="lqd-1573138643738-900ac3c4-91a8"][vc_row_inner enable_content_animation="yes" content_placement="middle" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_delay="200" ca_init_translate_y="35"][vc_column_inner][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:52px|text_medium:44px|text_small:38px" margin="bottom_small:0.35em"]Chatbot integration on your dashboard.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" margin="bottom_small:1.5em" lh="text_small:27px"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_button style="btn-solid" title="Let’s get started" shape="circle" i_type="linea" i_add_icon="true" css=".vc_custom_1595933906935{margin-bottom: 15px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" fs="16px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(42, 42, 42)"][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" align="text-center" offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-5" responsive_align="text-center" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1610356568359{margin-bottom: 35px !important;}"][vc_single_image image="106" alignment="center"][/vc_column][/vc_row][vc_row content_placement="middle" bg_position="custom" css=".vc_custom_1605846234757{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;background: #eef6f9 url(https://newsletterhub.liquid-themes.com/staging/wp-content/uploads/2019/11/circles.svg?id=42) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="48vw" bg_pos_v="50%" responsive_css="padding_top_medium:200px|padding_right_medium:0px|padding_bottom_medium:200px|padding_left_medium:0px" el_id="lqd-dashboard"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1800" ca_delay="180" ca_init_translate_y="45"][vc_single_image image="41"][ld_fancy_heading tag="h2" highlight_offset="10px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" fs="text_large:52px|text_medium:44px|text_small:38px" margin="bottom_small:0.35em" compressor="0.7" minfontsize="44" highlight_color="rgba(0, 233, 135, 0.45)"]Track your daily [ld_highlight]visitors[/ld_highlight].[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:19px" margin="bottom_small:1.5em" padding="right_all:12%25" lh="text_small:27px"]Your time is precious for us. Install any demo, plugin or template in a matter of seconds. Just select the demo and one click.[/ld_fancy_heading][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" bg_position="center center" offset="vc_col-md-7" translate_from_y="-40" translate_to_y="45"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" enable_row_shadowbox="yes" css=".vc_custom_1595930555265{background-color: #ffffff !important;border-radius: 20px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2230px%22%2C%22blur_radius%22%3A%2280px%22%2C%22shadow_color%22%3A%22rgba(59%2C131%2C150%2C0.09)%22%7D%5D" ca_duration="1800" ca_delay="120" ca_start_delay="500"][vc_column_inner width="1/2" css=".vc_custom_1573198864529{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 30px !important;border-right-color: #eff6fc !important;border-right-style: solid !important;border-bottom-color: #eff6fc !important;border-bottom-style: solid !important;}"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" title="Targeted Accounts" custom_heading_size="17px" icon_size="18px" custom_i_size="35px" css=".vc_custom_1611310244557{margin-bottom: 0px !important;}" title_mb="5" shape_color="rgb(31, 221, 121)" i_icon_fontawesome="fas fa-compass"]Buy once, and it is yours forever. Perfect deal![/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1573198870414{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 30px !important;border-right-color: #eff6fc !important;border-right-style: solid !important;border-bottom-color: #eff6fc !important;border-bottom-style: solid !important;}"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" title="Highly Personalized" custom_heading_size="17px" icon_size="18px" custom_i_size="35px" css=".vc_custom_1611310257563{margin-bottom: 0px !important;}" title_mb="5" shape_color="rgb(31, 221, 121)" i_icon_fontawesome="fas fa-wrench"]Buy once, and it is yours forever. Perfect deal![/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1573198875430{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 30px !important;border-right-color: #eff6fc !important;border-right-style: solid !important;border-bottom-color: #eff6fc !important;border-bottom-style: solid !important;}"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" title="Increase Engagement" custom_heading_size="17px" icon_size="18px" custom_i_size="35px" css=".vc_custom_1611310269025{margin-bottom: 0px !important;}" title_mb="5" shape_color="rgb(31, 221, 121)" i_icon_fontawesome="fas fa-book-reader"]Buy once, and it is yours forever. Perfect deal![/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1573198880704{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 30px !important;border-right-color: #eff6fc !important;border-right-style: solid !important;border-bottom-color: #eff6fc !important;border-bottom-style: solid !important;}"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" title="Future Customers" custom_heading_size="17px" icon_size="18px" custom_i_size="35px" css=".vc_custom_1595930538351{margin-bottom: 0px !important;}" title_mb="5" shape_color="rgb(31, 221, 121)" i_icon_fontawesome="fas fa-chart-pie"]You can easily create the perfect conversation.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1573198891571{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 30px !important;border-right-color: #eff6fc !important;border-right-style: solid !important;border-bottom-color: #eff6fc !important;border-bottom-style: solid !important;}"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" title="Personal Connections" custom_heading_size="17px" icon_size="18px" custom_i_size="35px" css=".vc_custom_1611310279338{margin-bottom: 0px !important;}" title_mb="5" shape_color="rgb(31, 221, 121)" i_icon_fontawesome="fas fa-bell"]Buy once, and it is yours forever. Perfect deal![/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1573198887050{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 30px !important;border-right-color: #eff6fc !important;border-right-style: solid !important;border-bottom-color: #eff6fc !important;border-bottom-style: solid !important;}"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" title="Start Conversations" custom_heading_size="17px" icon_size="18px" custom_i_size="35px" css=".vc_custom_1611310288834{margin-bottom: 0px !important;}" title_mb="5" shape_color="rgb(31, 221, 121)" i_icon_fontawesome="fas fa-robot"]Buy once, and it is yours forever. Perfect deal![/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][ld_particles as_bg="yes" shape_type="circle,edge" opacity="1" enable_move="yes" move_direction="right" enable_random_move="yes" enable_onhover="yes" onhover_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1573195501913-ee0a8e1c-4455" number="9" size="3.5" move_speed="3" modes_bubble_size="5"][/vc_column][vc_column][ld_images_group_container move_to_parent_row="yes" position="right_small:70px|bottom_small:0px"][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="43" translate_from_y="30" translate_to_y="-160"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row][vc_row bg_position="center center" css=".vc_custom_1605846403514{padding-top: 60px !important;padding-bottom: 50px !important;background-color: #ffffff !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" el_id="lqd-integration" responsive_css="padding_top_medium:150px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1605846889965{margin-bottom: 5vh !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" fs="text_large:52px|text_medium:44px|text_small:38px" margin="bottom_small:0.35em" compressor="0.7" minfontsize="44"]Seamless Integration[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:19px" lh="text_small:27px" margin="bottom_large:1.5em|bottom_small:1em"]Intuitive Header Builder – Choose a pre-built header or create a custom layout that perfectly suits your needs.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner equal_height="yes"][vc_column_inner parallax="yes" width="1/2" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_css="margin_bottom_medium:0px|padding_top_medium:100px" translate_from_y="-40" translate_to_y="45" css=".vc_custom_1605846418682{margin-bottom: 35px !important;}"][ld_icon_box i_type="image" heading_size="sm" i_shape="circle" i_size="sm" i_border="" enable_shape_shadowbox="yes" i_icon_image="48" title="Slack Chat" icon_mb="35" custom_i_size="165px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.08)%22%7D%5D"][ld_highlight color="#033165"]Full Extension[/ld_highlight][/ld_icon_box][/vc_column_inner][vc_column_inner parallax="yes" width="1/2" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_medium:25px|margin_bottom_small:0px" translate_from_y="35" translate_to_y="-85" css=".vc_custom_1605846431116{margin-bottom: 45px !important;}"][ld_icon_box i_type="image" heading_size="sm" i_shape="circle" i_size="sm" i_border="" enable_shape_shadowbox="yes" i_icon_image="49" title="Trello Boards" icon_mb="35" custom_i_size="165px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.08)%22%7D%5D"][ld_highlight color="#033165"]3rd party[/ld_highlight][/ld_icon_box][/vc_column_inner][vc_column_inner parallax="yes" width="1/2" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_medium:90px" translate_from_y="-85" translate_to_y="50"][ld_icon_box i_type="image" heading_size="sm" i_shape="circle" i_border="" enable_shape_shadowbox="yes" i_icon_image="51" title="Google Docs" icon_mb="35" custom_i_size="165px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.08)%22%7D%5D"][ld_highlight color="#033165"]Full Extension[/ld_highlight][/ld_icon_box][/vc_column_inner][vc_column_inner parallax="yes" width="1/2" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-3 vc_col-xs-6" translate_from_y="80" translate_to_y="-90" responsive_css="margin_top_medium:-70px"][ld_icon_box i_type="image" heading_size="sm" i_shape="circle" i_border="" enable_shape_shadowbox="yes" i_icon_image="50" title="Jiara Tickets" icon_mb="35" custom_i_size="165px" shape_color="rgb(255, 255, 255)" shape_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(65%2C94%2C148%2C0.08)%22%7D%5D"][ld_highlight color="#033165"]Full Extension[/ld_highlight][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" bg_position="center top" css=".vc_custom_1605846739489{padding-bottom: 40px !important;background-color: #ffffff !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" el_id="lqd-testimonials" responsive_css="padding_top_medium:50px|padding_bottom_medium:80px"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" highlight_offset="10px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_large:52px|text_medium:44px|text_small:38px" margin="bottom_small:0.85em" highlight_color="rgba(0, 233, 135, 0.37)"]Hear from [ld_highlight]community[/ld_highlight][/ld_fancy_heading][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" adaptiveheight="yes" navarrow="6" navsize="carousel-nav-lg" navfill="carousel-nav-solid" navshape="carousel-nav-circle" navshadow="carousel-nav-shadowed-onhover" nav_arrow_color="rgb(32, 30, 37)" nav_arrow_color_hover="rgb(255, 255, 255)" nav_border_color="rgb(234, 239, 240)" nav_border_hcolor="rgb(32, 30, 37)" nav_bg_color="rgb(234, 239, 240)" nav_bg_hcolor="rgb(32, 30, 37)" navoffset="left: 15px"][ld_carousel_section title="Tab" tab_id="lqd-1595937964872-620d79f9-4454"][vc_row_inner css=".vc_custom_1573202975286{margin-bottom: 30px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" color="rgb(77, 85, 116)" margin="bottom_small:1em" lh="text_small:27px"]“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes! I’d recommend this theme in a heartbeat!”[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:17px" fw="text_small:500" margin="bottom_small:0px"]Daniel Rock[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:400" margin="bottom_small:0px" color="rgb(157, 175, 189)"]ThemeForest Exclusive[/ld_fancy_heading][ld_spacer height="15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595939090504-d9086944-9c86"][vc_row_inner css=".vc_custom_1573202975286{margin-bottom: 30px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:27px" color="rgb(77, 85, 116)" margin="bottom_small:1em"]“Not only easy to use but also impressed with the functionality, Ave is already shedding light on 2019 website trends. Excellent performance from this lightweight theme, UX is excellent, all these specs enables you to have the perfect website. I’m in love with it.”[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:17px" fw="text_small:500" margin="bottom_small:0px"]Marta Wealth[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:400" margin="bottom_small:0px" color="rgb(157, 175, 189)"]ThemeForest Exclusive[/ld_fancy_heading][ld_spacer height="15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595939089759-0f2a36cc-8780"][vc_row_inner css=".vc_custom_1573202975286{margin-bottom: 30px !important;}"][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:27px" color="rgb(77, 85, 116)" margin="bottom_small:1em"]“A beautiful theme, with excellent scores on pingdom speed tool and gtmetrix, that is one of the main reasons for my purchase. Well designed, demos also present elements in a useful way. “[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:17px" fw="text_small:500" margin="bottom_small:0px"]Daniel Rock[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:400" margin="bottom_small:0px" color="rgb(157, 175, 189)"]ThemeForest Exclusive[/ld_fancy_heading][ld_spacer height="15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="0.75" pf_init_scale_y="0.75" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" pf_duration="1800" pf_delay="180" pf_start_delay="350"][ld_images_group_element image="53"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="55" position="top_large:42%25|right_large:29%25" translate_from_y="20" translate_to_y="-30"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="59" position="top_large:17%25|left_large:9%25" translate_from_y="70" translate_to_y="-70"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="54" position="top_large:13%25|right_large:18%25" translate_from_y="50" translate_to_y="-60"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="58" position="bottom_large:26%25|left_large:16%25" translate_from_y="100" translate_to_y="-110"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="57" position="bottom_large:11%25|left_large:41%25" translate_from_y="75" translate_to_y="-80"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="56" position="right_large:15%25|bottom_large:30%25" translate_from_y="55" translate_to_y="-100"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column width="2/3" offset="vc_hidden-lg vc_hidden-md vc_col-sm-offset-2"][vc_single_image image="98" alignment="center" css=".vc_custom_1573311244574{margin-top: 35px !important;}"][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1605847058780{padding-top: 60px !important;padding-bottom: 20px !important;background-color: #edf7fa !important;}" el_id="join" responsive_css="padding_top_medium:120px|padding_bottom_medium:120px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1800" ca_delay="200" ca_init_translate_y="35" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1573388537490{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" highlight_offset="10px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" fs="text_large:52px|text_medium:44px|text_small:38px" margin="bottom_small:0.35em" compressor="0.7" minfontsize="44" highlight_color="rgba(46, 195, 104, 0.39)"]Start building your project [ld_highlight]for free.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:19px" lh="text_small:27px" margin="bottom_small:1.5em" padding="right_all:12%25"]Buy Hub and get access to premium and exclusive plugins for free.[/ld_fancy_heading][ld_newsletter style="solid" inputs_radius="ld-sf--round" inputs_border="ld-sf--border-none" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" btn_label="Try it for Free" btn_position="ld-sf--button-block" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" placeholder_text="Enter your email address" fs="16px" label_fs="16px" txt_color="rgb(110, 121, 130)" bg_color="rgb(255, 255, 255)" hover_btn_bg_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" label_fw="700"][ld_gdpr_box]🍪 This website uses cookies to improve your web experience.[/ld_gdpr_box][/vc_column][vc_column column_top_onmobile="yes" offset="vc_col-md-7"][vc_single_image image="181" css=".vc_custom_1595944046490{margin-top: 35px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Grid Portfolio - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Grid Portfolio - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'gridpf-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:150px|padding_bottom_medium:150px|padding_top_small:160px" css=".vc_custom_1603117181334{padding-top: 140px !important;padding-bottom: 100px !important;}" el_id="works"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" ca_init_translate_y="-20" ca_init_rotate_y="-46" ca_duration="1800" ca_delay="140" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Digital Designer based in London.[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" fs="text_large:81px|text_medium:68px|text_small:13.5vw" margin="bottom_small:0px"]Hi, I’m David. I create[/ld_fancy_heading][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22designs%22%7D%2C%7B%22word%22%3A%22illustrations%22%7D%2C%7B%22word%22%3A%22websites%22%7D%5D" use_custom_fonts_title="true" fs="text_large:81px|text_medium:68px|text_small:13.5vw" margin="bottom_small:0.35em"]beautiful[/ld_fancy_heading][ld_button style="btn-naked" title="— Would you like to work with me?" link_type="modal_window" hover_txt_effect="btn-hover-txt-liquid-y" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" css=".vc_custom_1615372919780{margin-top: 0.5em !important;}" anchor_id="#header-contact-modal"][ld_particles as_bg="yes" color_type="random_color" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1588757654892-fd309525-a54e" number="7" size="3"][/vc_column][vc_column][ld_modal_window modal_type="fullscreen" el_id="header-contact-modal"][vc_row_inner full_width="" equal_height="yes" content_placement="middle" bg_position="center center" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" css=".vc_custom_1615372857273{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://gridportfolio.liquid-themes.com/staging/wp-content/uploads/2021/03/bg-2@2x-scaled-1.jpeg?id=4893) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="h-vh-100 align-items-center"][vc_column_inner width="1/2" css=".vc_custom_1615219219533{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:10%25"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:122px|text_medium:48px|text_small:34px" fw="text_small:500" color="rgb(0, 0, 0)" lh="text_medium:0.75em|text_small:1em" margin="bottom_small:0.5em"]Send a message.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.5em"]We’re here to answer any question you may have.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_css="padding_top_medium:45px|padding_right_medium:65px|padding_bottom_medium:45px|padding_left_medium:65px" css=".vc_custom_1615219159553{margin-bottom: -130px !important;background-color: #ffffff !important;border-radius: 10px !important;}"][ld_cf7 id="4892" shape="lqd-contact-form-inputs-underlined" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="13px" submit_fs="17px" color="rgb(0, 0, 0)" h_color="rgb(0, 0, 0)" css=".vc_custom_1615372838390{margin-bottom: 0px !important;}" submit_fw="500" border_color="rgba(0, 0, 0, 0.12)" hover_border_color="rgb(0, 0, 0)" submit_lh="1.5em" bm="13px"][/vc_column_inner][vc_column_inner width="1/4"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:13px" fw="text_small:700" ls="text_small:0.1em" margin="bottom_small:1.25em" color="rgb(0, 0, 0)"]careers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" margin="bottom_small:0.75em" color="rgb(0, 0, 0)"]Would you like to join our growing team?[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" fw="text_small:700" color="rgb(0, 0, 0)"]careers@hub.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:13px" fw="text_small:700" ls="text_small:0.1em" margin="bottom_small:1.25em" color="rgb(0, 0, 0)"]Feedbacks[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" margin="bottom_small:0.75em" color="rgb(0, 0, 0)"]Have a project in mind? Send a message.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" fw="text_small:700" color="rgb(0, 0, 0)"]info@hub.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_modal_window][/vc_column][/vc_row][vc_row][vc_column][ld_portfolio_listing style="style02" grid_columns="2" columns_gap="27" bottom_gap="90" post_type="liquid-portfolio" posts_per_page="6" show_filter="yes" custom_cursor_style="lqd-cc-icon-trigger" filter_lbl_all="All" filter_mb="50" show_button="yes" ib_style="btn-naked" ib_title="See more" ib_i_type="linea" color_type="lqd-pf-color-custom" ib_i_add_icon="true" filter_id="lqd-1588770546136-5772c7db-b381" filter_cats="branding, custom-print, digital-design" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" filter_normal_color="rgb(77, 77, 77)" filter_hover_color="rgb(0, 0, 0)" filter_title="Filter by" ib_color="rgb(77, 77, 77)" color_primary="linear-gradient(0deg, rgb(91, 25, 183) 0.3184713375796178%, rgba(255, 255, 255, 0.36) 100%)" title_size="17px" overlay_arrow_color="rgba(255, 255, 255, 0)"][/vc_column][/vc_row][vc_row gap="0" equal_height="yes" el_id="about" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px" css=".vc_custom_1596327810853{padding-top: 20px !important;padding-bottom: 40px !important;}"][vc_column responsive_align="text-left text-md-center"][ld_fancy_heading tag="h6" alignment="text-center" margin="bottom_small:2.7em" color="rgb(0, 0, 0)"]— I’ve worked with global brands:[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" ca_delay="180" css=".vc_custom_1588770973128{background-color: #f3f3f7 !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772265264{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 76px !important;padding-bottom: 77px !important;border-left-color: #dbdbdb !important;border-left-style: solid !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="4146" alignment="center" css=".vc_custom_1610891617674{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772270206{border-top-width: 1px !important;border-right-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="4145" alignment="center" css=".vc_custom_1610891639947{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772275415{border-top-width: 1px !important;border-right-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="3957" alignment="center" css=".vc_custom_1595497357906{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772281264{border-top-width: 1px !important;border-right-width: 1px !important;padding-top: 80px !important;padding-bottom: 72px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="3953" alignment="center" css=".vc_custom_1595497361776{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1533036259034{margin-top: -10px !important;}"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" ca_delay="180" css=".vc_custom_1588770977062{background-color: #f3f3f7 !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772285903{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 82px !important;padding-bottom: 82px !important;border-left-color: #dbdbdb !important;border-left-style: solid !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="3952" alignment="center" css=".vc_custom_1595497379033{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772290644{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="3955" alignment="center" css=".vc_custom_1595497375335{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772295464{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 78px !important;padding-bottom: 79px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="4038" alignment="center" css=".vc_custom_1595497370735{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772300083{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 76px !important;padding-bottom: 76px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="3950" alignment="center" css=".vc_custom_1595497366539{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row gap="0" equal_height="yes" content_placement="top" css=".vc_custom_1588772707964{padding-top: 30px !important;padding-bottom: 30px !important;}" responsive_css="margin_top_medium:50px|margin_bottom_medium:50px"][vc_column offset="vc_col-lg-6 vc_col-md-7" responsive_css="padding_right_medium:50px" css=".vc_custom_1588757803815{padding-right: 15px !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h6" color="rgb(0, 0, 0)" margin="top_small:1em|bottom_small:2em"]— I build designs systems for companies[/ld_fancy_heading][ld_fancy_heading tag="h3" highlight_type="lqd-highlight-custom-underline" highlight_height="50%" duration="1400" delay="150" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:1.2em" lh="text_small:1.35em"]I am an award-winning digital designer from London, in the business of creating unforgettable interactive experiences.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_top_medium:0px|padding_left_medium:5%25|margin_top_small:0px|padding_right_small:30px|padding_left_small:30px" offset="vc_col-lg-offset-0 vc_col-md-6" css=".vc_custom_1605879852432{padding-right: 15px !important;padding-left: 15px !important;}"][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="0px" fs="20px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(20, 20, 20)" border_color="rgb(0, 0, 0)" exp_color="rgb(20, 20, 20)" active_exp_color="rgb(0, 0, 0)" ls="0px" active_heading_color="rgb(0, 0, 0)" active_border_color="rgb(0, 0, 0)"][vc_accordion_tab title="Understand the whole customer story" tab_id="lqd-1587831664813-aeecfaeb-451a"][ld_fancy_heading tag="p"]Hub gives you incomparable insight into what your customers are perusing, clicking, and craving.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Build trust and loyalty programs" tab_id="lqd-1587831664920-2b73c907-de32"][ld_fancy_heading tag="p"]Easily segment the clients, build loyalty programs with cross-selling automation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Analyze and optimize with data at your fingertips" tab_id="lqd-1587831665033-9829583b-1af9"][ld_fancy_heading tag="p"]Our design services starts and ends with a best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1605879890274{margin-top: 30px !important;margin-bottom: 40px !important;}" responsive_css="margin_top_medium:100px|margin_bottom_medium:100px"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes" reverse="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600669953490-1d6432ae-31e3"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]UI Design.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670046727-6e3f70d6-9e29"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Branding.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670050127-af9486df-0052"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Development.[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][ld_carousel_marquee_tab columns_auto_width="yes" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600669960959-c9e61543-b44e"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Motion Design.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670059663-52e16e4a-044c"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Art Direction.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670067403-b1936528-48cc"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Marketing Strategy.[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row equal_height="yes" css=".vc_custom_1595506854528{padding-bottom: 80px !important;}" responsive_css="margin_bottom_medium:50px" el_id="services"][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-3" ca_init_translate_y="35" ca_init_translate_x="0" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(241, 60, 70)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.2em"]01[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="36px" lh="1.11em"]Branded eCommerce[/ld_fancy_heading][ld_fancy_heading tag="p"]Our eCommerce design starts and ends with a best-in-class experience strategy that builds brands and drives transactions.[/ld_fancy_heading][ld_spacer height="35px"][ld_fancy_heading tag="p" transform="text-uppercase" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22CONTENT%20MANAGEMENT%22%7D%2C%7B%22word%22%3A%22CREATIVE%20SOLUTIONS%22%7D%2C%7B%22word%22%3A%22DIGITAL%20MARKETING%22%7D%5D" use_custom_fonts_title="true" fs="text_small:11px" fw="text_small:700" ls="text_small:0.1em" color="rgb(24, 27, 49)"][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Platform & Positioning[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Trends & Insights[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Marketing Strategy[/ld_fancy_heading][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg" md_height="0px" lg_height="0px"][/vc_column][vc_column width="2/3" align="text-center" offset="vc_col-md-offset-1 vc_col-md-4" responsive_align="text-center"][vc_row_inner][vc_column_inner width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-left" offset="vc_col-md-offset-1" ca_start_delay="250" ca_init_translate_y="38" ca_duration="1200" ca_delay="150" responsive_align="text-left"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(241, 60, 70)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.2em"]02[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="36px" lh="1.11em" margin="right_large:8%25"]Digital Experience[/ld_fancy_heading][ld_fancy_heading tag="p"]Through a deep understanding of our audience’s makeup and motivations, we design digital experiences that connect with people.[/ld_fancy_heading][ld_spacer height="35px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Web design[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]mobile app design[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22CONTENT%20MANAGEMENT%22%7D%2C%7B%22word%22%3A%22CREATIVE%20SOLUTIONS%22%7D%2C%7B%22word%22%3A%22DIGITAL%20MARKETING%22%7D%5D" use_custom_fonts_title="true" fs="text_small:11px" fw="text_small:700" ls="text_small:0.1em" color="rgb(24, 27, 49)"][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]dashboard & tool[/ld_fancy_heading][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg" md_height="0px" lg_height="0px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" ca_start_delay="500" ca_init_translate_y="40" ca_init_translate_x="0" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(241, 60, 70)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.2em"]03[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="36px" lh="1.11em"]Branding Strategy[/ld_fancy_heading][ld_fancy_heading tag="p"]We build and activate brands through cultural insight, strategic vision, and the power of emotion across every element.[/ld_fancy_heading][ld_spacer height="35px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Communications[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Logo & Identity[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Content Management[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]System & guides[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1606903969497{margin-top: 20px !important;margin-bottom: 20px !important;}"][vc_column][ld_fancy_heading tag="h6" margin="bottom_small:2.7em" color="rgb(0, 0, 0)"]— International Design Awards[/ld_fancy_heading][vc_separator color="black"][/vc_column][vc_column width="1/6" align="text-left" responsive_align="text-left"][ld_fancy_heading tag="p" alignment="text-left" color="rgb(0, 0, 0)"]— 2020[/ld_fancy_heading][/vc_column][vc_column width="7/12" offset="vc_col-xs-6"][vc_single_image image="4012" css=".vc_custom_1588769011827{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/4" responsive_align="text-right" offset="vc_col-xs-6"][ld_fancy_heading tag="p" margin="left_large:80px" color="rgb(0, 0, 0)"]— Honorable Mention x 4[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1606903990571{margin-top: 20px !important;margin-bottom: 20px !important;}"][vc_column][vc_separator color="black"][/vc_column][vc_column width="1/6" align="text-left" responsive_align="text-left"][ld_fancy_heading tag="p" alignment="text-left" color="rgb(0, 0, 0)"]— 2019[/ld_fancy_heading][/vc_column][vc_column width="7/12" offset="vc_col-xs-6"][vc_single_image image="4012" css=".vc_custom_1588769011827{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/4" responsive_align="text-right" offset="vc_col-xs-6"][ld_fancy_heading tag="p" margin="left_large:80px" color="rgb(0, 0, 0)"]— Honorable Mention x 4 Developer Award x3[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1606904002630{margin-top: 20px !important;padding-bottom: 150px !important;}"][vc_column][vc_separator color="black"][/vc_column][vc_column width="1/6" align="text-left" responsive_align="text-left"][ld_fancy_heading tag="p" alignment="text-left" color="rgb(0, 0, 0)"]— 2018[/ld_fancy_heading][/vc_column][vc_column width="7/12" offset="vc_col-xs-6"][vc_single_image image="4012" css=".vc_custom_1588769011827{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/4" responsive_align="text-right" offset="vc_col-xs-6"][ld_fancy_heading tag="p" margin="left_large:80px" color="rgb(0, 0, 0)"]— Honorable Mention x 4[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Grid Portfolio - Contact
	$data = array();
	$data['name'] = esc_html__( 'Grid Portfolio - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'gridpf-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" bg_position="center center" css=".vc_custom_1614937207357{background-image: url(https://gridportfolio.liquid-themes.com/staging/wp-content/uploads/2021/03/glow-figss.svg?id=4868) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1614944108586{padding-top: 80px !important;padding-bottom: 35px !important;}" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-left"][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_onclick="yes" onclick_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1614867775326-30fedaf3-eca4" number="7" size="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23ea48d5%22%7D%2C%7B%22scolor%22%3A%22%23bde89d%22%7D%2C%7B%22scolor%22%3A%22%23a2eff2%22%7D%2C%7B%22scolor%22%3A%22%23fd6059%22%7D%5D"][ld_fancy_heading use_custom_fonts_title="true" fs="text_large:72px|text_small:40px"]Have a cool ✌️ project in mind?[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" margin="bottom_large:2em|bottom_small:1em" fs="text_large:21px|text_small:18px" lh="text_small:1.5em" color="rgba(0, 0, 0, 0.66)"]Currently, I am not available for freelance work. But I always love to hear from you about interesting projects.[/ld_fancy_heading][vc_row_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p"]Project Offers[ld_br]info@hubcommerce.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p"]Say Hello[ld_br]Call me at +123 878 90 87[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1614947530323{padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 40px !important;padding-left: 20px !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%7D%5D" responsive_css="margin_top_medium:-65px|padding_bottom_medium:20px|padding_right_small:50px|padding_left_small:50px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center text-md-left"][ld_icon_box i_type="linea" heading_size="custom" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-lqd-circle" title="Available for freelance" icon_size="28px" i_color="rgb(132, 245, 176)" custom_heading_size="14px"][/ld_icon_box][ld_button style="btn-solid" title="Say hello at `{`ld_span`}`contact.at.hub.com`{`/ld_span`}`" shape="circle" size="btn-lg" border="border-none" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-lg" enable_icon_shadowbox="yes" enable_row_shadowbox="yes" i_add_icon="true" hover_color="rgba(251, 252, 255, 0.5)" color="rgb(255, 255, 255)" text_color="rgb(20, 20, 20)" i_size="22px" fs="text_all:25px|text_large:18px|text_medium:16px|text_small:15px" lh="text_small:1.3em" fw="text_small:700" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.12)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" ls="text_small:0.02em" icon_box_shadow="%5B%7B%22y_offset%22%3A%2213px%22%2C%22blur_radius%22%3A%2222px%22%2C%22shadow_color%22%3A%22rgba(10%2C10%2C10%2C0.17)%22%7D%5D" h_icon_box_shadow="%5B%7B%7D%5D" i_color="rgb(255, 255, 255)" i_fill_color="rgb(253, 96, 89)" i_icon_linea="lqd-icn-ess icon-lqd-pen" i_margin_left="70px" htext_color="rgb(0, 0, 0)" i_fill_hcolor="rgb(253, 96, 89)" i_hcolor="rgb(255, 255, 255)"][/vc_column][vc_column][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Li.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(0, 0, 0)" spacing="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Vertical Portfolio - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Vertical Portfolio - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'verticalpf-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" enable_cc_circle="yes" responsive_css="margin_left_medium:100px" cc_circle_color="rgb(255, 255, 255)"][vc_column][ld_slideshow_2 height="100vh"][ld_slideshow_section title="ScottBank" image="121"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:140px|text_small:18vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Nexa%20Mobile||"]Nexa Mobile[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][ld_slideshow_section title="Kontrast" image="66"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:140px|text_small:20vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|title:Nike%20Shopping||"]Kontrast[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][ld_slideshow_section title="S-Klasse" image="120"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:140px|text_medium:15vw|text_small:20vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|||"]S-Klasse[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][ld_slideshow_section title="Insider" image="123"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_all:140px|text_large:130px|text_small:20vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Finspiration-board%2F|||"]Insider[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Finspiration-board%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][/ld_slideshow_2][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Vertical Portfolio - About
	$data = array();
	$data['name'] = esc_html__( 'Vertical Portfolio - About', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'verticalpf-about.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" bg_position="center center" bg_attachment="fixed" css=".vc_custom_1608041552893{background-image: url(http://verticalportfolio.liquid-themes.com/staging/wp-content/uploads/2020/12/Ellipse-2.svg?id=91) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_left_medium:100px" ca_duration="1800" ca_delay="180" ca_init_translate_y="70"][vc_column row_scale_bg_onhover="yes" enable_pin="enable_pin" pin_offset="0px" width="1/2" bg_position="center top" css=".vc_custom_1610635204758{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(http://verticalportfolio.liquid-themes.com/staging/wp-content/uploads/2020/12/bg@2x.jpg?id=88) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_small:50vh|padding_bottom_small:50vh"][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" responsive_css="padding_top_medium:150px|padding_right_medium:5vw|padding_bottom_medium:150px|padding_left_medium:8vw|padding_left_small:30px" css=".vc_custom_1608041643359{padding-top: 70px !important;padding-right: 15px !important;padding-bottom: 70px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="100" ca_init_translate_y="55" ca_init_rotate_z="5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" margin="bottom_large:15px|bottom_small:30px"]Available for freelance[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:4.5vw" lh="text_small:1em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0"]Hi, I’m Jack.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:16px" lh="text_small:1.5em" color="rgb(0, 0, 0)" margin="bottom_small:1.5em"]My name is Roberto, I’m a freelance Branding and Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:16px" lh="text_small:1.5em" color="rgb(0, 0, 0)"]beauty and technical performance. Our design starts and ends best-in-class experience strategy that builds brands.[/ld_fancy_heading][ld_spacer height="60px" md_height="90px"][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" margin="bottom_small:1em"]Career[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2020     —     CEO     —     LiquidThemes[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2019     —     Senior Designer     —     Apple[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2018     —     Junior Designer     —     Google[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2015     —     Graduated from Yale[/ld_fancy_heading][ld_spacer height="60px" md_height="90px"][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" margin="bottom_small:1em"]Clients[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2020    —    Adidas     —    MicroSite[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2020    —    Apple Inc.    —  Illustration[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2019   —    RedBull   — Consultation[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:15px" lh="text_small:1.25em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]2018   —    Google  — Web Interactions[/ld_fancy_heading][ld_spacer height="60px" md_height="90px"][ld_fancy_heading tag="h3" margin="bottom_small:1em"]Skills[/ld_fancy_heading][vc_row_inner gap="0" responsive_css="padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1615463625533{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.45em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]Art Direction [ld_br] Brand Strategy [ld_br] Communication [ld_br] Graphic Design [ld_br] Print Design [ld_br] Motion Graphics[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.45em" color="rgb(0, 0, 0)" margin="bottom_small:1.75em"]Brand Guide [ld_br] Flayer Design [ld_br] Video Production [ld_br] Web Advertising [ld_br] Illustrations [ld_br] Content Creation[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_spacer height="60px" md_height="90px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:40px" lh="text_small:1.24em" fw="text_small:500" margin="bottom_small:0px"]Collaboration, work enquires or just say hello.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.3)" fs="text_small:12px" margin="bottom_small:35px"]I’m always interested in small or big freelance projects to take your business to the next level.[/ld_fancy_heading][ld_button style="btn-underlined" title="jack@hub.com" border="border-thick" color="rgb(0, 0, 0)" fs="32px" lh="0.75em" hover_color="rgba(0, 0, 0, 0.75)"][ld_spacer height="25px" md_height="40px"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(0, 0, 0)" spacing="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Vertical Portfolio - Contact
	$data = array();
	$data['name'] = esc_html__( 'Vertical Portfolio - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'verticalpf-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" equal_height="yes" content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" bg_position="center center" bg_attachment="fixed" css=".vc_custom_1614940575099{background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_left_medium:100px" ca_duration="1800" ca_delay="180" ca_init_translate_y="70"][vc_column row_scale_bg_onhover="yes" enable_pin="enable_pin" pin_offset="0px" width="1/2" bg_position="center top" css=".vc_custom_1610635204758{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(http://verticalportfolio.liquid-themes.com/staging/wp-content/uploads/2020/12/bg@2x.jpg?id=88) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_small:50vh|padding_bottom_small:50vh"][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" responsive_css="padding_right_medium:8vw|padding_left_medium:10vw|padding_left_small:30px" css=".vc_custom_1614938048653{padding-top: 70px !important;padding-right: 15px !important;padding-bottom: 70px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="100" ca_init_translate_y="55" ca_init_rotate_z="5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" margin="bottom_large:15px|bottom_small:30px"]Available for freelance[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:4.5vw" lh="text_small:1em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_small:0.2em"]Let's talk.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:21px|text_small:16px" lh="text_small:1.5em" color="rgb(0, 0, 0)"]Currently, I am available for freelance work. I always love to hear from you about interesting projects.[/ld_fancy_heading][ld_spacer height="25px" md_height="40px"][ld_cf7 id="4817" shape="lqd-contact-form-inputs-filled" roundness="lqd-contact-form-inputs-circle" thickness="lqd-contact-form-inputs-border-thick" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-circle" border_color="rgb(100, 100, 100)" color="rgb(53, 53, 53)" submit_bg_color="rgb(0, 0, 0)" submit_color="rgb(255, 255, 255)" submit_hbg_color="rgba(0, 0, 0, 0.74)" submit_h_color="rgb(255, 255, 255)" submit_border_color="rgb(0, 0, 0)" submit_hover_border_color="rgba(0, 0, 0, 0.74)" lqd_bg_color="rgba(0, 0, 0, 0.04)" bm="0px"][ld_button style="btn-underlined" title="jack@hub.com" border="border-thick" color="rgb(0, 0, 0)" fs="32px" lh="0.75em" hover_color="rgba(0, 0, 0, 0.75)"][ld_spacer height="25px" md_height="40px"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(0, 0, 0)" spacing="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Split - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Split - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'split-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" luminosity="dark" bg_position="left center" css=".vc_custom_1596194795190{background-color: #161616 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" data_tooltip="Mobile Connection" el_id="about"][vc_column offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:0px|padding_left_medium:10vmax" css=".vc_custom_1611748325327{padding-top: 160px !important;padding-right: 15px !important;padding-bottom: 5vh !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h2" transform="text-uppercase" enable_txt_rotator="yes" rotator_type="basic" items="%5B%7B%22word%22%3A%22experiences%22%7D%2C%7B%22word%22%3A%22illustrations%22%7D%2C%7B%22word%22%3A%22products%22%7D%2C%7B%22word%22%3A%22videos%22%7D%5D" highlight_type="lqd-highlight-custom-underline" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" maxfontsize="65" minfontsize="50" margin="bottom_small:0.35em" compressor="0.7" color="rgb(255, 255, 255)" start_delay="500" highlight_color_brush="rgb(255, 255, 255)" word_colors="rgb(255, 255, 255)" fs="text_large:7vmin|text_medium:8vw|text_small:11vw"]Hi, I'm David. [ld_br] I create[/ld_fancy_heading][ld_spacer height="22px"][ld_fancy_heading tag="p" split_type="words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.55)" fs="23px" lh="1.52em" margin="bottom_small:1.75em" start_delay="850" ca_init_translate_x="0" ca_init_translate_y="-1"]App Design / UX Research / Wireframing / Motion Design / Front-End Development[/ld_fancy_heading][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="1100" ca_delay="180" ca_init_translate_y="35"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_start_delay="1000"][ld_spacer height="15px"][ld_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-behance-square%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="27px" primary_color="rgba(255,255,255,0.43)" hover_color="#ffffff"][/vc_column_inner][/vc_row_inner][ld_gdpr_box]We use cookies to provide the best web experience possible . [/ld_gdpr_box][/vc_column][vc_column bg_position="center top" offset="vc_col-md-6" css=".vc_custom_1606209488800{padding-top: 20vh !important;padding-bottom: 20vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2020/07/split1@2x.jpg?id=1137) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610725640932{background-color: #f6dbb8 !important;}" data_tooltip="Pull and Bear" el_id="pull-and-bear"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(118, 56, 56)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(0, 0, 0)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(118, 56, 56)" lh="text_small:1em" ls="text_small:-0.02em"]Pull and Bear[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(118, 56, 56)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(118, 56, 56)" hover_color="rgb(0, 0, 0)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|title:Inspiration%20Board||"][/vc_column][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-6" css=".vc_custom_1612357592538{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-1@2x.jpg?id=4754) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|||"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610726102949{background-color: #002b3b !important;}" data_tooltip="Coast Drone" el_id="coast-drone"][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-6" css=".vc_custom_1612357648338{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-2@2x.jpg?id=4755) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fthe-portraits%2F|||"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_fancy_heading tag="h6" color="rgb(198, 229, 195)"]2021 - case study[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(198, 229, 195)" lh="text_small:1em" ls="text_small:-0.02em"]Coast Drone[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(198, 229, 195)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(198, 229, 195)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fthe-portraits%2F|title:The%20Portraits||"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" bg_position="center center" css=".vc_custom_1610726560646{background: #502e23 url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-4@2x.jpg?id=4756) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" data_tooltip="Mercedes S-klasse" el_id="mercedes-s-klasse"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(242, 235, 225)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(242, 235, 225)" lh="text_small:1em" ls="text_small:-0.02em" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fmercedez-benz-coupe%2F|||"]Mercedes S-klasse[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(242, 235, 225)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(242, 235, 225)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fmercedez-benz-coupe%2F|title:Mercedez-Benz%20Coupe||"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610726708653{background-color: #16161d !important;}" data_tooltip="Nexa mobile" el_id="nexa-mobile"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(255, 255, 255)" lh="text_small:1em" ls="text_small:-0.02em"]Nexa mobile[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(255, 255, 255)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Nexa%20Mobile||"][/vc_column][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-6" css=".vc_custom_1612357735534{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-5@2x.jpg?id=4757) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610726881702{background-color: #002B3B !important;}" data_tooltip="Insider Magazine" el_id="insider-magazine"][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1612357676542{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-7@2x.jpg?id=4758) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fphoto-retouching%2F|||"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" responsive_css="margin_left_medium:-15%25|padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610726927822{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(255, 255, 255)" lh="text_small:1em" ls="text_small:-0.02em"]Insider Magazine[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(255, 255, 255)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fphoto-retouching%2F|title:Photo%20Retouching||"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1578567359580{background-color: #ffffff !important;}" data_tooltip="Social Connection"][vc_column row_scale_bg_onhover="yes" enable_link="enable_column_link" bg_position="center center" align="text-center" offset="vc_col-md-6" css=".vc_custom_1612358796277{padding-top: 20vh !important;padding-bottom: 20vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2020/07/split-pf-3@2x.jpg?id=1154) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_align="text-center" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|||"][ld_button style="btn-naked" title="Play Video" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thick" i_shape_size="btn-icon-xlg" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" i_size="22px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DTCMnrssX1NE%26ab_channel%3DApple|||" hover_color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)"][/vc_column][vc_column offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:0px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1605618568268{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h6"]2021 - case study[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" lh="text_small:1em" ls="text_small:-0.02em"]Android Cast [/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|title:Nike%20Shopping||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Split - Contact
	$data = array();
	$data['name'] = esc_html__( 'Split - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'split-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" equal_height="yes" content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" bg_position="center center" bg_attachment="fixed" css=".vc_custom_1615466473776{background-color: #141414 !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="70"][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" responsive_css="padding_top_medium:150px|padding_right_medium:7vw|padding_bottom_medium:150px|padding_left_medium:8vw|padding_left_small:30px" css=".vc_custom_1614940706329{padding-top: 70px !important;padding-right: 15px !important;padding-bottom: 70px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="100" ca_init_translate_y="55" ca_init_rotate_z="5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:13px" margin="bottom_large:15px|bottom_small:30px"]Available for freelance[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:6vw" lh="text_small:1em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" color="rgba(255, 255, 255, 0.11)" margin="bottom_small:0px"]Let's talk.[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:60px|text_medium:40px|text_small:30px" lh="text_small:1.2em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_small:0.15em"]info@zack.com[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:21px|text_small:16px" lh="text_small:1.5em" margin="right_large:5%25|bottom_small:1.5em"]Currently, I am not available for freelance work. But I always love to hear from you about interesting projects.[/ld_fancy_heading][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" margin="bottom_small:1em"]Say Hello[/ld_fancy_heading][vc_row_inner responsive_css="margin_left_small:0.1em"][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:18px|text_small:15px" lh="text_small:1.45em" margin="bottom_small:1.75em"]290 Maryam Springs Courbevoie, NYC [ld_br] +1 827 48 89[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:18px|text_small:15px" lh="text_small:1.45em" margin="left_large:10px|bottom_small:1.75em"]290 Maryam Springs Courbevoie, NYC [ld_br] +1 827 48 89[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="28px"][/vc_column][vc_column row_scale_bg_onhover="yes" enable_pin="enable_pin" pin_offset="-80px" width="1/2" column_top_ontablet="yes" column_top_onmobile="yes" bg_position="center top" css=".vc_custom_1614943889033{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/bg@2x.jpg?id=4793) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_small:50vh|padding_bottom_small:50vh"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Modern Blocks - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Modern Blocks - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'modernblocks-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes"][vc_column][ld_animated_frames_container enable_scrolable="true" arrows_color="rgba(255, 255, 255, 0.75)" arrows_hcolor="rgb(255, 255, 255)" frame_color="rgb(0, 0, 0)"][ld_animated_frame show_button="yes" ib_style="btn-naked" ib_title="View Project" ib_transformation="text-uppercase" ib_hover_txt_effect="btn-hover-txt-liquid-y" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" use_custom_fonts_title="true" use_custom_fonts_txt="true" ib_i_add_icon="true" title="Nike Air" color="rgb(255, 255, 255)" txt_color="rgba(255, 255, 255, 0.59)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_i_size="20px" fs="clamp(70px, 9vw, 130px)" fs_txt="18px" ib_color="rgba(255, 255, 255, 0.84)" ib_hover_color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0)" lh="1.1em" image="116"]The aim is to build your website so that it is functional and user-friendly website.[/ld_animated_frame][ld_animated_frame media_type="yt_video" yt_video_url="https://www.youtube.com/watch?v=l5ZK0S8Q7JU" show_button="yes" ib_style="btn-naked" ib_title="View Project" ib_transformation="text-uppercase" ib_hover_txt_effect="btn-hover-txt-liquid-y" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" use_custom_fonts_title="true" use_custom_fonts_txt="true" ib_i_add_icon="true" title="Cyberpunk" color="rgb(255, 255, 255)" txt_color="rgba(255, 255, 255, 0.59)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_i_size="20px" fs="clamp(55px, 9vw, 130px)" fs_txt="18px" ib_color="rgba(255, 255, 255, 0.84)" ib_hover_color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.15)" lh="1.2em"]The aim is to build your website so that it is functional and user-friendly website.[/ld_animated_frame][ld_animated_frame show_button="yes" ib_style="btn-naked" ib_title="View Project" ib_transformation="text-uppercase" ib_hover_txt_effect="btn-hover-txt-liquid-y" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" use_custom_fonts_title="true" use_custom_fonts_txt="true" ib_i_add_icon="true" title="S-Klasse" color="rgb(255, 255, 255)" txt_color="rgba(255, 255, 255, 0.59)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_i_size="20px" fs="clamp(70px, 9vw, 130px)" fs_txt="18px" ib_color="rgba(255, 255, 255, 0.84)" ib_hover_color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.15)" image="183" lh="1.1em"]The aim is to build your website so that it is functional and user-friendly website.[/ld_animated_frame][ld_animated_frame show_button="yes" ib_style="btn-naked" ib_title="View Project" ib_transformation="text-uppercase" ib_hover_txt_effect="btn-hover-txt-liquid-y" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" use_custom_fonts_title="true" use_custom_fonts_txt="true" ib_i_add_icon="true" title="ScottBank" color="rgb(255, 255, 255)" txt_color="rgba(255, 255, 255, 0.59)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_i_size="20px" fs="clamp(60px, 9vw, 130px)" fs_txt="18px" ib_color="rgba(255, 255, 255, 0.84)" ib_hover_color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.15)" image="184" lh="1.1em"]The aim is to build your website so that it is functional and user-friendly website.[/ld_animated_frame][ld_animated_frame show_button="yes" ib_style="btn-naked" ib_title="View Project" ib_transformation="text-uppercase" ib_hover_txt_effect="btn-hover-txt-liquid-y" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" use_custom_fonts_title="true" use_custom_fonts_txt="true" ib_i_add_icon="true" title="Vision STR" color="rgb(255, 255, 255)" txt_color="rgba(255, 255, 255, 0.59)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_i_size="20px" fs="clamp(70px, 9vw, 130px)" fs_txt="18px" ib_color="rgba(255, 255, 255, 0.84)" ib_hover_color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.15)" image="35" lh="1.1em"]The aim is to build your website so that it is functional and user-friendly website.[/ld_animated_frame][/ld_animated_frames_container][/vc_column][/vc_row][vc_row][vc_column][ld_gdpr_box]This website uses cookies to improve your web experience.[/ld_gdpr_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Modern Blocks - Contact
	$data = array();
	$data['name'] = esc_html__( 'Modern Blocks - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'modernblocks-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" content_placement="middle" video_bg="yes" video_bg_source="youtube" video_bg_url="https://www.youtube.com/watch?v=5bnc8AxRTFc" enable_content_animation="yes" animation_preset="Fade In" responsive_css="padding_right_large:12vw|padding_left_large:12vw|padding_top_medium:200px|padding_right_medium:7vw|padding_bottom_medium:200px|padding_left_medium:7vw" css=".vc_custom_1614932776248{padding-top: 100px !important;padding-bottom: 100px !important;}" ca_delay="125"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.5em"]Looking for collaboration for your next project? Do not hesitate to contact us to say hello.[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="50px"][/vc_column][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22hello.%22%7D%2C%7B%22word%22%3A%22sallut.%22%7D%2C%7B%22word%22%3A%22%E4%BD%A0%E5%A5%BD%22%7D%2C%7B%22word%22%3A%22hallo.%20%22%7D%2C%7B%22word%22%3A%22merhaba.%22%7D%2C%7B%22word%22%3A%22%E3%82%82%E3%81%97%E3%82%82%E3%81%97.%22%7D%2C%7B%22word%22%3A%22hola.%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:3.5vw|text_small:50px" margin="bottom_large:0px" lh="text_small:1.2em"]Don't be shy. Say[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][vc_separator color="white" border_width="5" css=".vc_custom_1614943343984{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column][vc_column offset="vc_col-md-4"][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:35px" margin="bottom_large:0px"]info@hub.com[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="50px" md_height="80px"][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:15px" margin="bottom_small:0px"]Project Offers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0px" fw="text_small:700"]info@hub.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:15px" margin="bottom_small:0px"]Say hello[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0px" fw="text_small:700"]07388 252344[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][/vc_column][vc_column offset="vc_col-md-5" responsive_align="text-md-right"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Li%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="45" fs="16px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.6)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Modern Blocks - About
	$data = array();
	$data['name'] = esc_html__( 'Modern Blocks - About', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'modernblocks-about.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="bottom" enable_content_animation="yes" enable_cc_circle="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" bg_position="custom" css=".vc_custom_1608191242573{padding-bottom: 30px !important;background: #111214 url(https://modernblocks.liquid-themes.com/staging/wp-content/uploads/2020/12/bg@2x.jpg?id=166) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_right_medium:7%25|padding_bottom_medium:15vw|padding_left_medium:7%25" ca_duration="1600" ca_start_delay="850" ca_delay="160" ca_init_translate_y="25" cc_circle_color="rgb(255, 108, 79)" bg_pos_h="80%" bg_pos_v="50%"][vc_column][ld_fancy_heading tag="p" split_type="words" duration="1200" delay="40" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:23px" lh="text_small:1.13em" fw="text_small:700" start_delay="100"]                                       My name is Christian Thierry, I’m a freelance Branding and Digital Designer based by the valley in New York. I currently work at Liquid. I create <span style="text-decoration: underline;">brand identities, digital experiences</span>, and print materials that communicate clearly. My job is to build your website so that it is functional and user friendly.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1608189980216{padding-top: 17px !important;}"][vc_separator color="custom" accent_color="rgba(255,255,255,0.23)"][/vc_column][vc_column width="1/4" offset="vc_col-xs-3"][ld_custom_menu source="custom" inline="inline-nav" magnetic_items="true" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.85)"][/vc_column][vc_column width="1/4" offset="vc_col-xs-3"][ld_custom_menu source="custom" inline="inline-nav" magnetic_items="true" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.85)"][/vc_column][vc_column width="1/4" offset="vc_col-xs-3"][ld_custom_menu source="custom" inline="inline-nav" magnetic_items="true" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.85)"][/vc_column][vc_column width="1/4" offset="vc_col-xs-3"][ld_custom_menu source="custom" inline="inline-nav" magnetic_items="true" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Lk.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.85)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Classic - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row enable_loading_bg="yes" css=".vc_custom_1595415099940{padding-top: 140px !important;padding-bottom: 140px !important;background-image: url(https://classichub.liquid-themes.com/staging/wp-content/uploads/2020/03/bg-11@2x-scaled.jpg?id=59) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}" responsive_css="padding_right_large:140px|padding_left_large:140px|padding_right_medium:100px|padding_left_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" ca_init_rotate_z="0"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" ca_init_translate_y="0" ca_init_rotate_z="0" margin="bottom_small:0.35em"]Take your business to the next level.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:17px" lh="text_small:30px" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/3" offset="vc_col-md-6"][ld_button style="btn-solid" title="Explore hub" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1595490224601{padding-right: 0.6em !important;padding-left: 0.6em !important;}" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fw="700" hover_color="rgb(22, 22, 22)"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-6"][vc_column_text css=".vc_custom_1583768679211{margin-bottom: 0px !important;}"]Hotline: (733) 860-2906[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1596326945613{border-bottom-width: 1px !important;padding-top: 60px !important;padding-bottom: 35px !important;border-bottom-color: rgba(0,0,0,0.07) !important;border-bottom-style: solid !important;}" responsive_css="border_bottom_medium:1px|padding_top_medium:75px|padding_bottom_medium:45px|padding_top_small:70px|padding_bottom_small:45px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1606176773239{margin-bottom: 40px !important;}" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h6" transform="text-uppercase" margin="bottom_small:1em"]Digital Products[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_all:14%25|left_all:14%25"]Tech solutions for your business.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][vc_column_inner width="1/2" css=".vc_custom_1583835330693{margin-bottom: 18px !important;}" offset="vc_col-md-4"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_size="sm" i_border="" position="iconbox-side" title="ONLINE SECURITY" custom_heading_size="15px" custom_i_size="56px" title_mb="13" i_icon_fontawesome="fas fa-shield-alt" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(59, 59, 59)"]Huge collection of elements, and rich customization options for you.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1583835330693{margin-bottom: 18px !important;}" offset="vc_col-md-4"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_size="sm" i_border="" position="iconbox-side" title="BUSINESS CONSULTATION" custom_heading_size="15px" custom_i_size="56px" title_mb="13" i_icon_fontawesome="far fa-compass" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(59, 59, 59)"]Huge collection of elements, and rich customization options for you.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1583835330693{margin-bottom: 18px !important;}" offset="vc_col-md-4"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_size="sm" i_border="" position="iconbox-side" title="SOCIAL MEDIA" custom_heading_size="15px" custom_i_size="56px" title_mb="13" i_icon_fontawesome="fab fa-twitter" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(59, 59, 59)"]Huge collection of elements, and rich customization options for you.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1583835330693{margin-bottom: 18px !important;}" offset="vc_col-md-4"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_size="sm" i_border="" position="iconbox-side" title="WEB DEVELOPMENT" custom_heading_size="15px" custom_i_size="56px" title_mb="13" i_icon_fontawesome="fas fa-wrench" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(59, 59, 59)"]Huge collection of elements, and rich customization options for you.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1583835330693{margin-bottom: 18px !important;}" offset="vc_col-md-4"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_size="sm" i_border="" position="iconbox-side" title="BRANDING STRATEGY" custom_heading_size="15px" custom_i_size="56px" title_mb="13" i_icon_fontawesome="fas fa-chess-queen" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(59, 59, 59)"]Huge collection of elements, and rich customization options for you.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1583835330693{margin-bottom: 18px !important;}" offset="vc_col-md-4"][ld_icon_box i_type="fontawesome" heading_size="custom" i_shape="circle" i_size="sm" i_border="" position="iconbox-side" title="ECOMMERCE" custom_heading_size="15px" custom_i_size="56px" title_mb="13" i_icon_fontawesome="fas fa-store" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(59, 59, 59)"]Huge collection of elements, and rich customization options for you.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1606896214665{padding-top: 60px !important;padding-bottom: 40px !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:90px"][vc_column][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" dots_bottom_offset="-15px" size_dots="carousel-dots-sm" mobile_dots_position="carousel-dots-mobile-inside" dots_bg_color="rgb(239, 239, 239)" dots_bg_hcolor="rgb(62, 173, 60)"][ld_carousel_section title="Tab" tab_id="lqd-1595436733469-64c80d59-5a3f"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1583837552785{margin-bottom: 35px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:600" margin="bottom_small:1em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Personal data protection for tech businesses.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Business Consultation" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check" css=".vc_custom_1595434733716{margin-bottom: 0.5em !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Corporate Financial Advisory" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check"][/ld_icon_box][ld_button style="btn-solid" title="Learn more" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][ld_spacer height="40px" lg_hide="vc_hidden-lg"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1595348848944{margin-bottom: 35px !important;border-radius: 5px !important;}"][vc_single_image image="162" css=".vc_custom_1595434255206{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436734697-36414a0e-7dc0"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1583837552785{margin-bottom: 35px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:600" margin="bottom_small:1em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Personal data protection for tech businesses.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Business Consultation" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check" css=".vc_custom_1595434733716{margin-bottom: 0.5em !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Corporate Financial Advisory" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check"][/ld_icon_box][ld_button style="btn-solid" title="Explore hub" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][ld_spacer height="70px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg" md_height="0px" lg_height="0px"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1595348848944{margin-bottom: 35px !important;border-radius: 5px !important;}"][vc_single_image image="145" css=".vc_custom_1595435228458{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1602158157069{padding-top: 30px !important;padding-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="35" responsive_css="padding_top_medium:30px|padding_bottom_medium:70px|padding_top_small:30px|padding_bottom_small:60px"][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" i_shape="circle" i_size="xs" i_border="1" position="iconbox-side" title="SCHEDULE APPOINTMENT" custom_heading_size="14px" custom_i_size="47px" shape_hcolor="rgb(62, 173, 60)" border_shape_color="rgb(220, 228, 235)" border_shape_hcolor="rgb(62, 173, 60)" shape_color="rgb(255, 255, 255)" icon_size="16px" h_i_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-num-1" i_color="rgb(0, 0, 0)"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" i_shape="circle" i_size="xs" i_border="1" position="iconbox-side" title="BUSINESS CONSULTATION" custom_heading_size="14px" custom_i_size="47px" shape_hcolor="rgb(62, 173, 60)" border_shape_color="rgb(220, 228, 235)" border_shape_hcolor="rgb(62, 173, 60)" shape_color="rgb(255, 255, 255)" icon_size="16px" h_i_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-num-2" i_color="rgb(26, 26, 26)"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" i_shape="circle" i_size="xs" i_border="1" position="iconbox-side" title="LAUNCH YOUR BUSINESS" custom_heading_size="14px" custom_i_size="47px" shape_hcolor="rgb(62, 173, 60)" border_shape_color="rgb(220, 228, 235)" border_shape_hcolor="rgb(62, 173, 60)" shape_color="rgb(255, 255, 255)" icon_size="16px" h_i_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-num-3" i_color="rgb(22, 22, 22)"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_icon_box][/vc_column][/vc_row][vc_row css=".vc_custom_1606896290931{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f9f9f9 !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:100px|padding_top_small:60px|padding_bottom_small:60px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1606208905051{margin-bottom: 60px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22Solutions%22%7D%2C%7B%22word%22%3A%22Advisory%22%7D%2C%7B%22word%22%3A%22Platforms%22%7D%5D" margin="bottom_small:0.4em"]Smart Business[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:30px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][/vc_column][vc_column][ld_carousel_tab columns="md:3|xs:1|spacing_md:23px|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" dots_bottom_offset="-15px" size_dots="carousel-dots-sm" dots_bg_color="rgba(0, 0, 0, 0.1)" dots_bg_hcolor="rgb(62, 173, 60)"][ld_carousel_section title="Tab" tab_id="lqd-1595436846536-a4b426d5-3199"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="183" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501903417{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Business Consultation[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436847701-7a20ddd5-8d28"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="184" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501911919{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Financial Advisory[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347659412-b71932b0-5394"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="182" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501925705{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Platform Investments[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436845811-0c08bbc1-d269"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="187" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501919777{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Business Consultation[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1602158463860{padding-top: 60px !important;padding-bottom: 40px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:75px|padding_top_small:70px|padding_bottom_small:50px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1605888548110{margin-bottom: 35px !important;}" responsive_css="padding_right_large:20%25" ca_duration="1800" ca_delay="180" ca_init_translate_x="-35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:600" margin="bottom_small:1.5em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.35em"]Let your audience about your brand.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:2em" fs="text_small:17px" lh="text_small:28px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_progressbar size="liquid-progressbar-custom" roundness="liquid-progressbar-circle" label="DIGITAL SOLUTIONS - 7 YEARS" count="80" vertical_height="8px" background="rgb(239, 239, 239)" label_color="rgb(0, 0, 0)" margin="bottom_small:65px"][ld_progressbar size="liquid-progressbar-custom" roundness="liquid-progressbar-circle" label="SALES SERVICES" count="60" vertical_height="8px" background="rgb(239, 239, 239)" label_color="rgb(0, 0, 0)" margin="bottom_small:65px"][ld_progressbar size="liquid-progressbar-custom" roundness="liquid-progressbar-circle" label="ANDROID APPLICATIONS" count="75" vertical_height="8px" background="rgb(239, 239, 239)" label_color="rgb(0, 0, 0)" margin="bottom_small:65px"][/vc_column][/vc_row][vc_row row_scale_bg_onhover="yes" bg_position="custom" enable_overlay="yes" enable_row_shadowbox="yes" css=".vc_custom_1611924976884{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://classichub.liquid-themes.com/staging/wp-content/uploads/2020/03/bg-2@2x-scaled.jpg?id=69) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(43, 43, 43, 0.35)" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2222px%22%2C%22blur_radius%22%3A%2255px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.13)%22%7D%5D" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px|padding_top_small:60px|padding_bottom_small:60px" bg_pos_h="25%" bg_pos_v="50%"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_inheritance="true" enable_split="true" color="rgb(255, 255, 255)" padding="right_large:7%25|left_large:7%25"]We help people to build and expand their services.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:2em" fs="text_small:17px" lh="text_small:28px" color="rgba(255, 255, 255, 0.8)" padding="right_large:15%25|left_large:15%25"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][ld_button style="btn-solid" title="Explore hub" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][/vc_column][/vc_row][vc_row css=".vc_custom_1602158512448{border-bottom-width: 1px !important;padding-top: 60px !important;padding-bottom: 60px !important;border-bottom-color: rgba(0,0,0,0.07) !important;border-bottom-style: solid !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:80px|padding_top_small:90px|padding_bottom_small:80px"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1606176912954{margin-bottom: 35px !important;}" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h6" transform="text-uppercase"]Digital Products[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_all:14%25|left_all:14%25"]Hear from our clients.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1606895363427{margin-bottom: 20px !important;}"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" wraparound="yes" el_id="testi-avatars"][ld_carousel_section title="Tab" tab_id="lqd-1595347850721-ecc362b9-2c20"][vc_column_text] Matt Atwell Founder [/vc_column_text][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347850841-d00f696d-7795"][vc_column_text] Matt Atwell Founder [/vc_column_text][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347850951-53dce317-6bd9"][vc_column_text] Matt Atwell Founder [/vc_column_text][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column offset="vc_col-md-8"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" navarrow="6" navsize="carousel-nav-lg" navslidernumberstoarrows="yes" mobile_dots_bottom_offset_outside="-0.5em" controllingcarousels="#testi-avatars"][ld_carousel_section title="Tab" tab_id="lqd-1595347863097-4b39de55-bca3"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="32px" color="rgb(78, 78, 78)" margin="bottom_small:2em"]“I think Hub is the best theme I ever seen this year. Amazing design, easy to customize and a design quality superlative. A startup or start-up is started by individual founders or entrepreneurs.”[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347863217-fce914be-bece"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="32px" color="rgb(78, 78, 78)" margin="bottom_small:2em"]“I think Hub is the best theme I ever seen this year. Amazing design, easy to customize and a design quality superlative. A startup or start-up is started by individual founders or entrepreneurs.”[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347863333-3c669e95-7ee7"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="32px" color="rgb(78, 78, 78)" margin="bottom_small:2em"]“I think Hub is the best theme I ever seen this year. Amazing design, easy to customize and a design quality superlative. A startup or start-up is started by individual founders or entrepreneurs.”[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row css=".vc_custom_1596326557783{padding-top: 55px !important;padding-bottom: 55px !important;}" row_hide="hidden-xs"][vc_column offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1596325944900{margin-bottom: 35px !important;}" responsive_align="text-xs-center"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="14px" fw="400" margin="bottom_small:1em"]GLOBAL EXPERTS[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-9"][ld_carousel_tab columns="md:5|sm:4|xs:3|spacing_sm:4%25|spacing_xs:3%25" inactiv_opacity="1" wraparound="yes" equalheightcells="yes" middlealigncontent="yes"][ld_carousel_section title="Tab" tab_id="lqd-1595348147795-a5d223c2-99cd"][vc_single_image image="170" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512753938{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347985125-5118c773-7b5a"][vc_single_image image="3518" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512782879{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436615090-f639f0f8-79da"][vc_single_image image="172" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512790551{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595502568530-1eb6e334-c01a"][vc_single_image image="3550" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512798013{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595348177750-4c0ed434-b4a4"][vc_single_image image="3519" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512805862{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595348137797-04705869-b534"][vc_single_image image="171" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512815723{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595348167153-50f0755f-ea71"][vc_single_image image="173" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512822828{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row content_placement="middle" row_scale_bg_onhover="yes" enable_overlay="yes" css=".vc_custom_1610893415509{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://classichub.liquid-themes.com/staging/wp-content/uploads/2020/03/bg-3@2x-scaled.jpg?id=77) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.22)" hover_overlay_bg="rgba(0, 0, 0, 0.4)" responsive_css="padding_top_medium:100px|padding_bottom_medium:80px|padding_top_small:60px|padding_bottom_small:60px"][vc_column align="text-center" offset="vc_col-md-7" responsive_align="text-md-left" css=".vc_custom_1595400834749{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_medium:45px|text_small:35px" ls="text_small:-0.01em" margin="bottom_small:0px" ca_init_translate_y="90"]Schedule a meeting to take your business to the next level.[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-3" ca_init_translate_y="39" responsive_align="text-md-right"][ld_button style="btn-solid" title="Get in Touch" transformation="text-uppercase" link_type="scroll_to_section" shape="round" size="btn-xlg" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Services
	$data = array();
	$data['name'] = esc_html__( 'Classic - Services', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general services';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" css=".vc_custom_1608550148416{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Global Data Analysis" image="183" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Research and Development" image="182" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Startup Investment" image="184" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="RD Service Plan" image="184" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Growth Plan" image="183" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Business Consultation" image="182" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Services Details
	$data = array();
	$data['name'] = esc_html__( 'Classic - Services Details', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-services-details.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general services';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1608193681640{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="5/12" offset="vc_col-md-4"][vc_row_inner][vc_column_inner responsive_css="margin_bottom_medium:45px" css=".vc_custom_1608194013763{margin-bottom: 30px !important;}"][ld_custom_menu source="custom" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Research%20and%20Development%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Startup%20Investment%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Leading%20Experience%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Zero%20Broker%20Commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-forward%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%5D" fs="15px" color="rgb(51, 51, 51)" bg_color="rgb(247, 248, 250)" bg_hcolor="rgb(233, 236, 240)" spacing="3"][/vc_column_inner][vc_column_inner css=".vc_custom_1608195737477{margin-bottom: 30px !important;padding-top: 35px !important;padding-right: 20px !important;padding-bottom: 35px !important;padding-left: 20px !important;background-color: #f7f8fa !important;border-radius: 5px !important;}" responsive_css="margin_bottom_medium:45px|padding_right_medium:35px|padding_left_medium:35px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:19px" margin="bottom_small:1.25em"]Get a Free Quote[/ld_fancy_heading][ld_cf7 id="259" shape="lqd-contact-form-inputs-filled" roundness="lqd-contact-form-inputs-round" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" bm="10px" fs="15px" submit_fs="15px" lqd_bg_color="rgb(255, 255, 255)" color="rgb(127, 130, 132)" css=".vc_custom_1608194393263{margin-bottom: 0px !important;}" h_color="rgb(0, 0, 0)"][/vc_column_inner][vc_column_inner css=".vc_custom_1608195709893{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;border-left-color: rgba(112,112,112,0.15) !important;border-left-style: solid !important;border-right-color: rgba(112,112,112,0.15) !important;border-right-style: solid !important;border-top-color: rgba(112,112,112,0.15) !important;border-top-style: solid !important;border-bottom-color: rgba(112,112,112,0.15) !important;border-bottom-style: solid !important;border-radius: 3px !important;}" responsive_css="padding_right_large:35px|padding_left_large:50px|padding_right_medium:15px|padding_left_medium:15px|padding_right_small:10px|padding_left_small:10px"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-medium" i_shape="circle" i_border="" position="iconbox-side" items_alignment="align-items-center" i_icon_linea="lqd-icn-ess icon-lqd-pen" title="Toll Free Call Center:" custom_heading_size="15px" custom_i_size="65px" css=".vc_custom_1608194633885{margin-bottom: 0px !important;}" icon_size="20px" title_mb="1" i_color="rgb(38, 176, 95)" h_color="rgb(160, 160, 160)" shape_color="rgba(38, 176, 95, 0.1)"]+48 4348 80 32[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="7/12" column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-7" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1608195694447{margin-bottom: 35px !important;}"][ld_content_box template="s06" box_height_6="h-pt-60" i_type="linea" use_custom_fonts_title="true" title="Research and Development" subtitle="analytics" image="261" i_icon_linea="lqd-icn-ess icon-lqd-laptop" overlay_color="linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, rgba(24, 27, 49, 0.6) 100%)" ls="0"][/ld_content_box][ld_spacer height="30pxpx" md_height="45px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Data Analysis[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off campus or even spend semesters overseas. One Construction employs over 3 000 employees, the majority of whom are based on project sites.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][vc_separator color="custom" accent_color="rgba(0,0,0,0.1)" css=".vc_custom_1608195050020{margin-top: 10px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Plan Benefits[/ld_fancy_heading][vc_row_inner][vc_column_inner width="1/2"][ld_custom_menu source="custom" items="%5B%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Immediate%20settlement%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Zero%20broker%20commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Guaranteed%20by%20the%20services%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Infrastructure%20solutions%20%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" icon_color="rgb(38, 176, 95)" spacing="15"][/vc_column_inner][vc_column_inner width="1/2"][ld_custom_menu source="custom" items="%5B%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Immediate%20settlement%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Zero%20broker%20commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Guaranteed%20by%20the%20services%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Infrastructure%20solutions%20%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" icon_color="rgb(38, 176, 95)" spacing="15"][/vc_column_inner][/vc_row_inner][vc_separator color="custom" accent_color="rgba(0,0,0,0.1)" css=".vc_custom_1608195223630{margin-top: 20px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Questions? You’re covered.[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" fs="17px" fw="500" exp_color="rgb(38, 176, 95)" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608195246481-cdcf9380-7c98"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608195398248-a9ad0a33-4d60"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608195413119-53c7aa0b-0417"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Case Studies
	$data = array();
	$data['name'] = esc_html__( 'Classic - Case Studies', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-case-studies.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1611323405556{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column][ld_portfolio_listing style="style02" columns_gap="20" bottom_gap="30" post_type="liquid-portfolio" posts_per_page="9" show_button="yes" show_filter="yes" filter_enable_counter="yes" filter_lbl_all="All" filter_size="size-custom" filter_decoration="filters-underline" filter_align="justify-content-start" filter_mb="50" filter_weight="font-weight-medium" filter_title_size="size-md" ib_style="btn-naked" ib_title="See more" ib_i_type="linea" color_type="lqd-pf-color-custom" ib_i_add_icon="true" filter_id="lqd-1608206666593-989a1a56-7757" color_primary="rgba(62, 173, 60, 0.9)" overlay_arrow_color="rgb(255, 255, 255)" filter_cats="marketing, analytics, business" filter_title="By Category" custom_filter_size="15px" filter_underline_height="1px" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_fs="15px" ib_ls="0px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Case Details
	$data = array();
	$data['name'] = esc_html__( 'Classic - Case Details', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-case-details.jpg' );
	$data['sort_name'] = 'Case Details';
	$data['custom_class'] = 'general case-studies';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1608208821057{padding-top: 55px !important;padding-bottom: 30px !important;}"][vc_column][ld_carousel_tab columns="xs:1|spacing_xs:0px" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" wraparound="yes" adaptiveheight="yes" fadeeffect="yes" autoplay="yes" navarrow="4" navsize="carousel-nav-lg" navfill="carousel-nav-solid" navshape="carousel-nav-square" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" mobile_dots_position="carousel-dots-mobile-inside" nav_arrow_color="rgb(0, 0, 0)" nav_bg_color="rgb(255, 255, 255)" autoplaytime="3000" mobile_dots_bg_color="rgba(255, 255, 255, 0.4)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1608208615375-86b0277c-bc6b"][vc_single_image image="3476" css=".vc_custom_1608208750206{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608208796091-c88e5950-eb37"][vc_single_image image="3453" css=".vc_custom_1611324461165{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608208793192-7fcdfd6f-89b2"][vc_single_image image="261" css=".vc_custom_1611324666304{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row css=".vc_custom_1608208830310{padding-top: 30px !important;padding-bottom: 60px !important;}"][vc_column enable_pin="enable_pin" width="1/3" offset="vc_col-md-3"][vc_row_inner][vc_column_inner css=".vc_custom_1608208949369{margin-bottom: 30px !important;padding-top: 35px !important;padding-right: 20px !important;padding-bottom: 15px !important;padding-left: 20px !important;background-color: #f7f8fa !important;border-radius: 5px !important;}" responsive_css="padding_right_large:45px|padding_left_large:45px|margin_bottom_medium:45px|padding_right_small:20px|padding_left_small:20px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:19px" margin="bottom_small:1.25em"]Project Details[/ld_fancy_heading][ld_single_portfolio_meta columns="1"][/vc_column_inner][vc_column_inner css=".vc_custom_1608208963857{margin-bottom: 30px !important;padding-top: 35px !important;padding-right: 20px !important;padding-bottom: 35px !important;padding-left: 20px !important;background-color: #f7f8fa !important;border-radius: 5px !important;}" responsive_css="padding_right_large:30px|padding_left_large:30px|margin_bottom_medium:45px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:19px" margin="bottom_small:1.25em"]Get a Free Quote[/ld_fancy_heading][ld_cf7 id="259" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-sm" roundness="lqd-contact-form-inputs-round" btn_size="lqd-contact-form-button-md" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" bm="10px" fs="15px" submit_fs="15px" lqd_bg_color="rgb(255, 255, 255)" color="rgb(127, 130, 132)" css=".vc_custom_1608208190835{margin-bottom: 0px !important;}" h_color="rgb(0, 0, 0)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-8" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1608208994618{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Data Analysis[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off campus or even spend semesters overseas. One Construction employs over 3 000 employees, the majority of whom are based on project sites.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][ld_spacer height="0px" md_height="30px"][vc_row_inner equal_height="yes" content_placement="middle" gap="0" css=".vc_custom_1608208367027{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #ebebeb !important;border-left-style: solid !important;border-right-color: #ebebeb !important;border-right-style: solid !important;border-top-color: #ebebeb !important;border-top-style: solid !important;border-bottom-color: #ebebeb !important;border-bottom-style: solid !important;}"][vc_column_inner responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_right_medium:40px|padding_left_medium:40px|padding_right_small:20px|padding_left_small:20px" css=".vc_custom_1608209048884{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 35px !important;padding-right: 35px !important;padding-bottom: 35px !important;padding-left: 35px !important;border-right-color: #ebebeb !important;border-right-style: solid !important;border-bottom-color: #ebebeb !important;border-bottom-style: solid !important;}" offset="vc_col-md-7"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:0.75em"]RD Service Plan[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Through a unique combination of engineering, construction and design disciplines and expertise, Concor delivers world class infrastructure solutions. We embrace holistic development and support for employees.[/ld_fancy_heading][ld_button style="btn-solid" title="Get in Touch" shape="round" width="btn-block" fs="16px" fw="600" ls="0px"][/vc_column_inner][vc_column_inner css=".vc_custom_1608209027397{padding-top: 35px !important;padding-right: 15px !important;padding-bottom: 35px !important;padding-left: 15px !important;}" responsive_css="padding_left_medium:35px" offset="vc_col-md-5"][ld_custom_menu source="custom" items="%5B%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Immediate%20settlement%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Zero%20broker%20commission%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Guaranteed%20by%20the%20services%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Infrastructure%20solutions%20%22%2C%22url%22%3A%22%23%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-checkmark%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" icon_color="rgb(38, 176, 95)" spacing="15"][/vc_column_inner][/vc_row_inner][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em"]Questions? You’re covered.[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" fs="17px" fw="500" exp_color="rgb(38, 176, 95)" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608195246481-cdcf9380-7c98"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608195398248-a9ad0a33-4d60"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608195413119-53c7aa0b-0417"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Service Plans
	$data = array();
	$data['name'] = esc_html__( 'Classic - Service Plans', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-service-plans.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general services';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row gap="20" css=".vc_custom_1608200964837{border-bottom-width: 1px !important;padding-top: 60px !important;padding-bottom: 60px !important;border-bottom-color: #ededed !important;border-bottom-style: solid !important;}"][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style07" show_button="yes" pt_style="btn-solid" pt_title="Apply for this plan" pt_shape="round" title="Individual Text about your service plan" description="A startup or start-up is started by individual founders entrepreneurs." price="£3Per month" pt_ls="0px" pt_fw="600" pt_fs="14px" border_color="rgb(227, 227, 227)"] Auto Direct Payment Project Estimation Dashboard Access Unlimited Team Projects [/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style07" show_button="yes" pt_style="btn-solid" pt_title="Apply for this plan" pt_shape="round" title="Business Text about your service plan" description="A startup or start-up is started by individual founders entrepreneurs." price="£8Per month" pt_ls="0px" pt_fw="600" pt_fs="14px" border_color="rgb(227, 227, 227)"] Montly Direct Payment Project Estimation Dashboard Access Unlimited Team Projects [/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table template="style07" show_button="yes" pt_style="btn-solid" pt_title="Apply for this plan" pt_shape="round" title="Corporate Text about your service plan" description="A startup or start-up is started by individual founders entrepreneurs." price="£23Per month" pt_ls="0px" pt_fw="600" pt_fs="14px" border_color="rgb(227, 227, 227)"] Auto Direct Payment Project Estimation Dashboard Access Unlimited Team Projects [/ld_price_table][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1608201371488{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" offset="vc_col-md-4" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1608201382689{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:13px" ls="text_small:0.1em" color="rgb(0, 0, 0)" margin="bottom_small:1.5em"]Frequently asked questions[/ld_fancy_heading][ld_fancy_heading tag="h2"]Need help? You’re covered.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.64em"]Passionate about solving problems through creative communications.[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1"][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="17px" active_heading_color="rgb(54, 131, 103)" exp_color="rgb(38, 176, 95)" active_exp_color="rgb(38, 176, 95)" fw="500" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608201167721-289990ce-8c18"][ld_fancy_heading tag="p"]A startup or start-up is started by individual founders entrepreneurs to search for a repeatable and scalable business model.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608201293303-00841012-25cc"][ld_fancy_heading tag="p"]A startup or start-up is started by individual founders entrepreneurs to search for a repeatable and scalable business model.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608201309458-ed3cc3ad-a05b"][ld_fancy_heading tag="p"]A startup or start-up is started by individual founders entrepreneurs to search for a repeatable and scalable business model.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Help
	$data = array();
	$data['name'] = esc_html__( 'Classic - Help', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-help.jpg' );
	$data['sort_name'] = 'Help';
	$data['custom_class'] = 'general help';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1608193681640{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column enable_pin="enable_pin" width="5/12" offset="vc_col-md-4"][vc_row_inner][vc_column_inner responsive_css="margin_bottom_medium:45px" css=".vc_custom_1608194013763{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" alignment="text-center" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" fs="text_small:15px" fh_bg="rgb(242, 244, 247)" padding="right_all:23%25|left_all:23%25|right_large:20px|left_large:20px|right_medium:30%25|left_medium:30%25|top_small:1em|right_small:25%25|bottom_small:1em|left_small:25%25" margin="bottom_small:2.5em"]Frequently Asked Questions[/ld_fancy_heading][ld_custom_menu source="custom" localscroll="yes" icon_pos="text-left" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Research%20and%20Development%22%2C%22url%22%3A%22%23user-data-analysis%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Data%20Analysis%22%2C%22url%22%3A%22%23service-plans%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Startup%20Investment%22%2C%22url%22%3A%22%23business-consultation%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Leading%20Experience%22%2C%22url%22%3A%22%23user-data-analysis%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Zero%20Broker%20Commission%22%2C%22url%22%3A%22%23service-plans%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%2C%7B%22label%22%3A%22Global%20Data%20Analysis%22%2C%22url%22%3A%22%23business-consultation%22%2C%22icon_classname%22%3A%22lqd-icn-ess%20icon-ion-ios-arrow-down%22%2C%22icon_alignment%22%3A%22right-icon%22%7D%5D" fs="15px" color="rgb(0, 0, 0)" hcolor="rgba(0, 0, 0, 0.8)" spacing="30" fw="400"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="7/12" column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-7" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1608195694447{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em" el_id="user-data-analysis"]User Data Analysis[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" fs="17px" fw="500" exp_color="rgb(38, 176, 95)" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608212680425-64a3c014-d69a"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608212680471-5ee8bf95-e50a"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608212680513-e1f720f5-ad09"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em" el_id="service-plans"]Service Plans[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" fs="17px" fw="500" exp_color="rgb(38, 176, 95)" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608212710601-362f8763-2827"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608212710670-5bc8bcdb-700c"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608212710720-9d220adc-2ac1"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:25px" margin="bottom_small:1em" el_id="business-consultation"]Business Consultation[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" fs="17px" fw="500" exp_color="rgb(38, 176, 95)" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Guaranteed by the trusted aviation services" tab_id="lqd-1608195246481-cdcf9380-7c98"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Professional end to end encryption for companies" tab_id="lqd-1608195398248-a9ad0a33-4d60"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Zero broker commission for data research and analysis" tab_id="lqd-1608195413119-53c7aa0b-0417"][ld_fancy_heading tag="p" margin="bottom_small:0px"]We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors. Through a unique combination of engineering, construction and design disciplines and expertise.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic - Contact
	$data = array();
	$data['name'] = esc_html__( 'Classic - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'classic-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0"][vc_column][ld_google_map style="classic" map_marker="html_marker" si_style="" si_size="" si_shape="" si_border="" si_orientation="" zoom="14" map_controls="fullscreenControl" address="Gateway Battery Park City Apartment" map_height="440px" si_identities="" si_font_size="" si_custom_size="" si_hover_color="" si_bg_color="" si_hbg_color="" si_border_color="" si_hborder_color=""][/vc_column][/vc_row][vc_row content_placement="middle" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" css=".vc_custom_1608199084580{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" responsive_css="margin_bottom_medium:0px|padding_right_medium:60px|padding_left_medium:60px|padding_top_small:55px|padding_right_small:20px|padding_bottom_small:35px|padding_left_small:20px" css=".vc_custom_1608199163750{margin-bottom: 30px !important;border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 45px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 20px !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;border-radius: 3px !important;}"][ld_fancy_heading use_custom_fonts_title="true" fs="text_small:34px" fw="text_small:500"]Get in touch[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.5em"]We are here to answer any question you may have. Feel free to reach via contact form.[/ld_fancy_heading][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_fontawesome="fas fa-map-marker-alt" title="290 Maryam Springs 260,`{`ld_br`}`Courbevoie, Paris" custom_heading_size="15px" icon_size="16px" icon_mb="15" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1608198980988{margin-bottom: 10px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_fontawesome="fas fa-envelope" title="Email: hello@liquid-themes.com" custom_heading_size="15px" icon_size="16px" icon_mb="15" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1608198973172{margin-bottom: 10px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_fontawesome="fas fa-mobile" title="Phone: +47 213 5941 295" custom_heading_size="15px" icon_size="16px" icon_mb="15" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1608198966267{margin-bottom: 10px !important;}"][/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_medium:12%25"][ld_cf7 id="259" shape="lqd-contact-form-inputs-filled" roundness="lqd-contact-form-inputs-round" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="13px" submit_fs="14px" lqd_bg_color="rgb(247, 248, 248)" color="rgb(123, 131, 142)" h_color="rgb(0, 0, 0)" css=".vc_custom_1608199148075{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Photography - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Photography - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'photography-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" responsive_css="padding_top_medium:220px|padding_right_medium:35px|padding_left_medium:35px" css=".vc_custom_1611750213101{padding-top: 120px !important;}"][vc_column offset="vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:0.5em" ls="text_small:-0.02em" fs="text_small:17px"]Hi, I’m Tom.[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:0.5em" ls="text_small:-0.02em"]I’m a freelance Branding and Digital Designer based in NYC.[/ld_fancy_heading][ld_button style="btn-naked" title="— Would you like to work with me?" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column][/vc_row][vc_row full_width="stretch_row" responsive_css="padding_right_medium:35px|padding_left_medium:35px" css=".vc_custom_1579684978296{padding-top: 60px !important;}"][vc_column][ld_portfolio_listing style="style01" columns_gap="5" bottom_gap="11" post_type="liquid-portfolio" posts_per_page="21" enable_item_animation="yes" show_button="yes" show_filter="yes" enable_gallery="listing-lightbox-gallery" enable_parallax="no" custom_cursor_style="lqd-cc-icon-trigger" filter_enable_counter="yes" filter_lbl_all="All" filter_mb="20" ib_style="btn-naked" ib_title="See All" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" ib_i_add_icon="true" filter_id="lqd-1595755870230-8d40b9f3-c0c2" pf_duration="1800" pf_delay="80" filter_cats="branding, custom-print, digital-design, ecommerce" filter_normal_color="rgb(152, 152, 152)" filter_hover_color="rgb(0, 0, 0)" ib_fs="13px" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_css=".vc_custom_1605172090997{margin-bottom: 30px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Photography - Contact
	$data = array();
	$data['name'] = esc_html__( 'Photography - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'photography-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" content_placement="middle"][vc_column row_scale_bg_onhover="yes" width="1/2" bg_position="center top" css=".vc_custom_1611326725988{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://photography.liquid-themes.com/staging/wp-content/uploads/2020/12/ethan-haddox-__ng3cRXmFE-unsplash@2x.jpg?id=4508) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_origin_z="100px" ca_an_opacity="1" offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1608625382276{padding-top: 35px !important;padding-right: 15px !important;padding-bottom: 35px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="100" ca_init_translate_y="35" ca_init_rotate_x="65" responsive_css="padding_right_small:30px|padding_left_small:30px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" margin="bottom_large:15px|bottom_small:30px"]<i class="lqd-icn-ess icon-lqd-circle mr-2" style="color: #00cc76; font-size: 18px; vertical-align: text-top;"></i>Available for freelance[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:4.5vw" lh="text_small:1em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_small:0.2em"]Let's talk.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:21px|text_small:16px" lh="text_small:1.5em" color="rgb(0, 0, 0)"]Currently, I am available for freelance work. I always love to hear from you about interesting projects.[/ld_fancy_heading][ld_spacer height="25px" md_height="40px"][ld_cf7 id="4554" shape="lqd-contact-form-inputs-filled" roundness="lqd-contact-form-inputs-circle" thickness="lqd-contact-form-inputs-border-thick" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-circle" border_color="rgb(100, 100, 100)" color="rgb(53, 53, 53)" submit_bg_color="rgb(0, 0, 0)" submit_color="rgb(255, 255, 255)" submit_hbg_color="rgba(0, 0, 0, 0.74)" submit_h_color="rgb(255, 255, 255)" submit_border_color="rgb(0, 0, 0)" submit_hover_border_color="rgba(0, 0, 0, 0.74)" lqd_bg_color="rgba(0, 0, 0, 0.04)" bm="0px"][ld_button style="btn-underlined" title="jack@hub.com" border="border-thick" color="rgb(0, 0, 0)" fs="32px" lh="0.75em" hover_color="rgba(0, 0, 0, 0.75)"][ld_spacer height="25px" md_height="40px"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(0, 0, 0)" spacing="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Photography - About
	$data = array();
	$data['name'] = esc_html__( 'Photography - About', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'photography-about.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" content_placement="middle"][vc_column row_scale_bg_onhover="yes" width="1/2" bg_position="center top" css=".vc_custom_1611326725988{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://photography.liquid-themes.com/staging/wp-content/uploads/2020/12/ethan-haddox-__ng3cRXmFE-unsplash@2x.jpg?id=4508) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_origin_z="100px" ca_an_opacity="1" offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1608625382276{padding-top: 35px !important;padding-right: 15px !important;padding-bottom: 35px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="100" ca_init_translate_y="35" ca_init_rotate_x="65" responsive_css="padding_right_small:30px|padding_left_small:30px"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:13px" lh="text_small:1.5em" margin="bottom_small:2em|left_small:-0.4em"] Available for freelance[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:18px" lh="text_small:1.28em" color="rgb(0, 0, 0)" margin="bottom_small:1.25em"]My name is Roberto, I’m a freelance Branding and Digital Designer based by the valley in San Francisco. I currently work at Liquid. [ld_br][ld_br]I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic. beauty and technical performance.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:18px" lh="text_small:1.28em" color="rgb(0, 0, 0)" margin="bottom_small:0px"]For more information and project collaborations say hello at[/ld_fancy_heading][ld_button style="btn-naked" title="daniel@hub.com" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(0, 0, 0)" hover_color="rgb(80, 80, 80)" fs="22px" css=".vc_custom_1611326603751{margin-top: 30px !important;}" i_icon_linea="lqd-icn-ess icon-lqd-envelope"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Product Shop - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Product Shop - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'productshop-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center top" css=".vc_custom_1602670018904{padding-top: 80px !important;padding-bottom: 80px !important;background: #bcb1cf url(https://productshop.liquid-themes.com/staging/wp-content/uploads/2020/10/Banner@2x.jpg?id=165) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-lg-5" responsive_css="padding_right_medium:18%25" css=".vc_custom_1603288619112{padding-bottom: 70px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:10px" ls="text_small:0.08em" fw="text_small:700" margin="bottom_small:1.5em"]  Hub Wired Collection[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" fs="text_small:59px" lh="text_small:1em" color="rgb(0, 0, 0)" ls="text_small:-0.01em" margin="bottom_small:0.25em"]Easy skin care routine.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:19px" padding="right_all:7%25" margin="bottom_small:1.85em"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_fancy_heading][ld_button style="btn-solid" title="Shop Products" shape="circle" size="btn-sm" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" lh="1.35em" color="rgb(35, 38, 27)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" css=".vc_custom_1610714720297{padding-right: 0.65em !important;padding-left: 0.65em !important;}" fw="500"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1602671540471{margin-top: -75px !important;padding-top: 25px !important;padding-bottom: 25px !important;background-color: #ffd78b !important;}"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288497441-8bf20fef-4083"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670644137-e38675d2-149a"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I feel amazing when I use Hub Cosmetics.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288409283-989c28c2-d697"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288483752{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602671192095-46abc435-ec95"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670963432-11920b84-244e"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670954055-fa8296fb-8b7e"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288526674-65d262fc-eff4"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670975168-2be5953e-7120"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288521994-c8c46d08-1455"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602671209218-19459e63-0fea"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row css=".vc_custom_1610714622209{padding-top: 80px !important;padding-bottom: 20px !important;background-color: #23261b !important;}"][vc_column align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" fadeeffect="yes" navarrow="6" navsize="carousel-nav-lg" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" nav_arrow_color="rgb(255, 255, 255)" nav_arrow_color_hover="rgba(255, 255, 255, 0.6)" prevoffset="-12%" nextoffset="-12%" mobile_dots_bg_color="rgba(255, 255, 255, 0.6)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Tab" tab_id="lqd-1595925595009-fe57db21-b7e8"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(250, 242, 220)" fs="text_small:18px" lh="text_small:1.22em"]"Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition. It's simply the best product i've ever used!"[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1612365055707-c5511143-aaaa"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(250, 242, 220)" fs="text_small:18px" lh="text_small:1.22em"]"Hub offers a range of skincare products that are feminine, delicate and ltricies eget, tempor sit amet, ante. Pellentesque habitant morbi tristique senectus et netus et malesuada.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1612365055168-b39b35bf-548c"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(250, 242, 220)" fs="text_small:18px" lh="text_small:1.22em"]"Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition. It's simply the best product i've ever used!"[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column][ld_spacer height="60px"][/vc_column][vc_column width="1/3" align="text-center" responsive_align="text-md-left" css=".vc_custom_1603288732328{margin-bottom: 35px !important;}" offset="vc_col-xs-4"][vc_single_image image="31" image_max_width="131px"][/vc_column][vc_column width="1/3" align="text-center" css=".vc_custom_1603288740656{margin-bottom: 35px !important;}" responsive_align="text-center" offset="vc_col-xs-4"][vc_single_image image="32" image_max_width="131px"][/vc_column][vc_column width="1/3" align="text-center" responsive_align="text-md-right" css=".vc_custom_1603288747454{margin-bottom: 35px !important;}" offset="vc_col-xs-4"][vc_single_image image="33" image_max_width="131px"][/vc_column][/vc_row][vc_row css=".vc_custom_1610715136384{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;background-color: #fff6e5 !important;border-bottom-color: #707070 !important;border-bottom-style: solid !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:0.15em"]Revolutionary Ingredients[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" lh="text_small:1.5em" margin="bottom_small:0px"]We eliminated single-use plastic materials.[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1610715142668{padding-top: 50px !important;padding-bottom: 50px !important;background-color: #fff6e5 !important;}"][vc_column offset="vc_col-md-1/5 vc_col-xs-6"][ld_icon_box i_type="image" heading_size="custom" i_shape="circle" i_size="sm" i_border="2" i_icon_image="34" title="Cream or Bottle" title_mb="1" custom_heading_size="15px" custom_size="26px" icon_mb="18" custom_i_size="50px" shape_color="rgba(0, 0, 0, 0)" border_shape_color="rgb(0, 0, 0)"]Easy to Apply[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-1/5 vc_col-xs-6"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_size="sm" i_border="2" title="Cream or Bottle" title_mb="1" custom_heading_size="15px" icon_mb="18" custom_i_size="50px" shape_color="rgba(0, 0, 0, 0)" border_shape_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-speech-bubble" i_color="rgb(0, 0, 0)"]Easy to Apply[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-1/5 vc_col-xs-6"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_size="sm" i_border="2" title="Cream or Bottle" title_mb="1" custom_heading_size="15px" icon_mb="18" custom_i_size="50px" shape_color="rgba(0, 0, 0, 0)" border_shape_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-ld-cart" i_color="rgb(0, 0, 0)"]Easy to Apply[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-1/5 vc_col-xs-6"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_size="sm" i_border="2" title="Cream or Bottle" title_mb="1" custom_heading_size="15px" icon_mb="18" custom_i_size="50px" shape_color="rgba(0, 0, 0, 0)" border_shape_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-lqd-eye" i_color="rgb(0, 0, 0)"]Easy to Apply[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-1/5" responsive_align="text-center text-md-left"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_size="sm" i_border="2" title="Cream or Bottle" title_mb="1" custom_heading_size="15px" icon_mb="18" custom_i_size="50px" shape_color="rgba(0, 0, 0, 0)" border_shape_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-lqd-check" i_color="rgb(0, 0, 0)"]Easy to Apply[/ld_icon_box][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1605622148793{padding-top: 60px !important;padding-bottom: 80px !important;}" responsive_css="padding_top_medium:120px|padding_bottom_medium:140px"][vc_column offset="vc_col-md-4" responsive_css="padding_right_large:10%25|padding_bottom_medium:0px" css=".vc_custom_1605622117741{padding-bottom: 40px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:2em"]Hub wired collection[/ld_fancy_heading][ld_fancy_heading tag="h2"]Easy skin care routine.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_fancy_heading][ld_button style="btn-naked" title="Shop collection" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" fs="13px" ls="0.1em"][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_hover3d="yes" enable_roudness="yes" image_roudness="2" enable_shadow="yes" image="37"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_hover3d="yes" enable_roudness="yes" image_roudness="2" enable_shadow="yes" absolute_pos="yes" image="280" position="bottom_small:-10%25|left_small:45%25" shadow_delay="500"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row][vc_row parallax="enable_parallax" row_scale_bg_onhover="yes" css=".vc_custom_1610715186481{padding-top: 200px !important;padding-bottom: 200px !important;background-image: url(https://productshop.liquid-themes.com/staging/wp-content/uploads/2020/12/beauty-portrait-of-sensual-ginger-woman-with-long-hair-posing-with-green-leaf23@2x.jpg?id=238) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:78px|text_small:48px"]Comfy makeup. Easy routine.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1589975456359{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="5%"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600678689394-2596da0d-3e48"][ld_fancy_heading tag="h2" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" use_inheritance="true" hover_text_outline_color="rgb(149, 149, 149)" hover_text_outline_width="1px" fs="text_small:12vw" margin="bottom_small:0px" lh="text_small:1.2em"]High quality[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600678689525-816059df-e3a5"][ld_fancy_heading tag="h2" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" use_inheritance="true" hover_text_outline_color="rgb(149, 149, 149)" hover_text_outline_width="1px" fs="text_small:12vw" margin="bottom_small:0px" lh="text_small:1.2em"]ingredients[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="5%" reverse="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600678696407-cd36d528-787b"][ld_fancy_heading tag="h2" whitespace="ws-nowrap" use_custom_fonts_title="true" use_inheritance="true" fs="text_small:12vw" margin="bottom_small:0px" lh="text_small:1.15em"]No plastic materials[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600678696539-9e2ce809-e266"][ld_fancy_heading tag="h2" whitespace="ws-nowrap" use_custom_fonts_title="true" use_inheritance="true" fs="text_small:12vw" margin="bottom_small:0px" lh="text_small:1.15em"]No plastic materials[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row css=".vc_custom_1605622394399{padding-bottom: 60px !important;}" responsive_css="padding_top_medium:60px"][vc_column css=".vc_custom_1589980317303{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #707070 !important;border-left-style: solid !important;border-right-color: #707070 !important;border-right-style: solid !important;border-top-color: #707070 !important;border-top-style: solid !important;border-bottom-color: #707070 !important;border-bottom-style: solid !important;}"][vc_row_inner equal_height="yes" content_placement="middle" gap="0" css=".vc_custom_1589980636656{border-bottom-width: 1px !important;border-bottom-color: #707070 !important;border-bottom-style: solid !important;}"][vc_column_inner width="1/3" css=".vc_custom_1606206352204{border-right-width: 0px !important;padding-top: 21px !important;padding-right: 40px !important;padding-bottom: 10px !important;padding-left: 40px !important;border-right-color: #707070 !important;border-right-style: solid !important;}" responsive_css="border_right_small:1px|padding_bottom_small:21px"][ld_fancy_heading tag="h6" margin="bottom_small:0px"]Classification[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:11px"]Antioxidant[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1606206341338{border-right-width: 0px !important;padding-right: 40px !important;padding-left: 40px !important;border-right-color: #707070 !important;border-right-style: solid !important;}" responsive_css="border_right_small:1px|padding_top_small:20px|padding_bottom_small:20px"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Micro Ingredients[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1589980520776{padding-top: 20px !important;padding-right: 40px !important;padding-bottom: 20px !important;padding-left: 40px !important;}"][ld_fancy_heading tag="p" margin="bottom_small:0px"]4-98[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" gap="0" css=".vc_custom_1589980636656{border-bottom-width: 1px !important;border-bottom-color: #707070 !important;border-bottom-style: solid !important;}"][vc_column_inner width="1/3" css=".vc_custom_1606206360837{border-right-width: 0px !important;padding-top: 21px !important;padding-right: 40px !important;padding-bottom: 10px !important;padding-left: 40px !important;border-right-color: #707070 !important;border-right-style: solid !important;}" responsive_css="border_right_small:1px|padding_bottom_small:20px"][ld_fancy_heading tag="h6" margin="bottom_small:0px"]Classification[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:11px"]Antioxidant[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1606206370097{border-right-width: 0px !important;padding-right: 40px !important;padding-left: 40px !important;border-right-color: #707070 !important;border-right-style: solid !important;}" responsive_css="border_right_small:1px|padding_top_small:20px|padding_bottom_small:20px"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Micro Ingredients[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1589980520776{padding-top: 20px !important;padding-right: 40px !important;padding-bottom: 20px !important;padding-left: 40px !important;}"][ld_fancy_heading tag="p" margin="bottom_small:0px"]4-98[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" gap="0"][vc_column_inner width="1/3" css=".vc_custom_1606206393460{border-right-width: 0px !important;padding-top: 21px !important;padding-right: 40px !important;padding-bottom: 10px !important;padding-left: 40px !important;border-right-color: #707070 !important;border-right-style: solid !important;}" responsive_css="border_right_small:1px|padding_bottom_small:20px"][ld_fancy_heading tag="h6" margin="bottom_small:0px"]Classification[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:11px"]Antioxidant[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1606206402830{border-right-width: 0px !important;padding-right: 40px !important;padding-left: 40px !important;border-right-color: #707070 !important;border-right-style: solid !important;}" responsive_css="border_right_small:1px|padding_top_small:20px|padding_bottom_small:20px"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Micro Ingredients[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1589980520776{padding-top: 20px !important;padding-right: 40px !important;padding-bottom: 20px !important;padding-left: 40px !important;}"][ld_fancy_heading tag="p" margin="bottom_small:0px"]4-98[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1611152797537{padding-bottom: 40px !important;}" responsive_css="padding_top_medium:60px|padding_bottom_medium:60px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1606168712191{margin-bottom: 40px !important;}" responsive_align="text-center" responsive_css="margin_bottom_medium:60px"][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:0.15em"]Shop Hub Products[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" lh="text_small:1.5em" margin="bottom_small:0px"]Get discounts for a limited time only.[/ld_fancy_heading][/vc_column][vc_column][ld_woo_products_list template="grid" columns_gap="0" limit="3"][/vc_column][/vc_row][vc_row css=".vc_custom_1610715066440{padding-bottom: 40px !important;}" responsive_css="padding_top_medium:30px|padding_bottom_medium:40px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1590400188926{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" responsive_align="text-center"][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true"]Subscribe and get 20% off your first purchase.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-8 vc_col-xs-offset-1 vc_col-xs-10"][ld_images_group_element absolute_pos="yes" image="102" position="top_small:-60px|right_small:-50px"][/ld_images_group_element][ld_newsletter use_opt_in="Yes" style="underlined" btn_style="naked" btn_label="Submit" btn_position="ld-sf--button-inside" use_custom_fonts_input="true" use_custom_fonts_label="true" placeholder_text="Enter your email address" fs="15px" label_fs="15px" txt_color="rgb(0, 0, 0)" brd_color="rgb(151, 151, 151)" txt_f_color="rgb(151, 151, 151)" brd_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(0, 0, 0)"][/vc_column][/vc_row][vc_row css=".vc_custom_1605622972829{padding-bottom: 40px !important;}" responsive_css="padding_bottom_medium:60px"][vc_column responsive_css="padding_right_medium:65px" offset="vc_col-md-4" responsive_align="text-center text-md-left"][ld_icon_box i_type="fontawesome" heading_size="xs" alignment="text-left" i_icon_fontawesome="far fa-circle" title="Cruelty-Free Products" title_mb="37" icon_size="22px" icon_mb="20"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_icon_box][vc_separator color="custom" accent_color="#000000"][/vc_column][vc_column responsive_css="padding_left_medium:65px" offset="vc_col-md-4" responsive_align="text-center text-md-left"][ld_icon_box i_type="fontawesome" heading_size="xs" alignment="text-left" i_icon_fontawesome="far fa-circle" title="Cruelty-Free Products" title_mb="37" icon_size="22px" icon_mb="20"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_icon_box][vc_separator color="custom" accent_color="#000000"][/vc_column][vc_column responsive_css="padding_left_medium:65px" offset="vc_col-md-4" responsive_align="text-center text-md-left"][ld_icon_box i_type="fontawesome" heading_size="xs" alignment="text-left" i_icon_fontawesome="far fa-circle" title="Cruelty-Free Products" title_mb="37" icon_size="22px" icon_mb="20"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_icon_box][vc_separator color="custom" accent_color="#000000"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1605622781017{padding-bottom: 40px !important;}" responsive_css="padding_top_medium:60px|padding_bottom_medium:60px" row_hide="hidden-xs hidden-sm"][vc_column align="text-center" css=".vc_custom_1590405292325{margin-bottom: 240px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h4"]Follow us on Instagram[/ld_fancy_heading][/vc_column][vc_column align="text-center" responsive_align="text-center"][ld_images_group_container][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="123" position="top_small:-32%25|left_small:63%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" image="121" margin="left_small:10%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="124" position="top_small:-40%25|left_small:36%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="127" position="top_small:-20%25|left_small:15%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="145" position="top_small:30%25|left_small:2%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="122" position="top_small:25%25|left_small:83%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1590402997288{margin-top: 60px !important;border-top-width: 1px !important;padding-top: 20px !important;padding-bottom: 20px !important;border-top-color: #3e4536 !important;border-top-style: solid !important;}"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1.5%"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600678707930-dd6b187c-1008"][ld_fancy_heading tag="h5" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1em" margin="bottom_small:0px"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678963766-579fdc0d-4fa2"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="far fa-circle" title_mb="1" icon_size="12px" icon_mb="1" css=".vc_custom_1590402945944{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678969552-07b327e8-7d61"][ld_fancy_heading tag="h5" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1em" margin="bottom_small:0px"]I feel amazing when I use Hub Cosmetics.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678972442-d9f5353a-8275"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="far fa-circle" title_mb="1" icon_size="12px" icon_mb="1" css=".vc_custom_1590402945944{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678975429-d3dfffae-9120"][ld_fancy_heading tag="h5" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1em" margin="bottom_small:0px"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678978990-9c807ec5-c26b"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="far fa-circle" title_mb="1" icon_size="12px" icon_mb="1" css=".vc_custom_1590402945944{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678982153-7c7292af-8697"][ld_fancy_heading tag="h5" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1em" margin="bottom_small:0px"]I feel amazing when I use Hub Cosmetics.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678984945-166b7a4d-8f79"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="far fa-circle" title_mb="1" icon_size="12px" icon_mb="1" css=".vc_custom_1590402945944{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678988002-41f8819d-1a4d"][ld_fancy_heading tag="h5" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1em" margin="bottom_small:0px"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678991344-94993920-adf1"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="far fa-circle" title_mb="1" icon_size="12px" icon_mb="1" css=".vc_custom_1590402945944{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678994443-e25ddeba-3892"][ld_fancy_heading tag="h5" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1em" margin="bottom_small:0px"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600678998059-83fbf481-0e61"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="far fa-circle" title_mb="1" icon_size="12px" icon_mb="1" css=".vc_custom_1590402945944{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Product Shop - About
	$data = array();
	$data['name'] = esc_html__( 'Product Shop - About', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'productshop-about.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column row_scale_bg_onhover="yes" width="1/2" css=".vc_custom_1608287425817{padding-top: 25vh !important;padding-right: 15px !important;padding-bottom: 25vh !important;padding-left: 15px !important;background-image: url(https://productshop.liquid-themes.com/staging/wp-content/uploads/2020/12/img-1@2x.jpg?id=201) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_align="text-center"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22about%20hubcare.%22%7D%2C%7B%22word%22%3A%22high%20quality%22%7D%2C%7B%22word%22%3A%22top%20rated%22%7D%2C%7B%22word%22%3A%22clean%20formula%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:50px|text_small:38px" fw="text_small:700" ls="text_small:-0.01em"][/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1608289786091{padding-top: 60px !important;padding-bottom: 60px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="31" responsive_css="padding_top_medium:90px"][vc_row_inner responsive_css="padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1608286604862{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10"][ld_fancy_heading tag="h5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:0.75em"]our story.[/ld_fancy_heading][/vc_column_inner][vc_column_inner][vc_separator color="custom" accent_color="#0a0a0a" css=".vc_custom_1608286151078{margin-bottom: 25px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="text_small:15px" lh="text_small:1.46em"]Over 25 years of experience, we have crafted thousands of strategic discovery process that enables us to peel back the layers which enable us to understand, connect, represent and dominate your market. Because we know just how hard it is to get the size, color and even the garment right in the fashion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_spacer height="35px" md_height="20vh"][vc_row_inner responsive_css="padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1608286615106{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10"][ld_fancy_heading tag="h5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:0.75em"]redefining skin care.[/ld_fancy_heading][/vc_column_inner][vc_column_inner][vc_separator color="custom" accent_color="#0a0a0a" css=".vc_custom_1608286151078{margin-bottom: 25px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="text_small:15px" lh="text_small:1.46em"]The planet and your conscience will thank you. To help stem the flow of plastic into the ocean, we have committed to eliminating single-use plastic from th product range and food outlets by 2020.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Dark Portfolio - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Dark Portfolio - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'darkpf-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:250px|padding_bottom_medium:90px" css=".vc_custom_1605845068060{padding-top: 140px !important;padding-bottom: 50px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-12" ca_duration="1800" ca_delay="180" ca_init_translate_y="70" ca_init_rotate_x="-6"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22user%20interface%20designer%22%7D%2C%7B%22word%22%3A%22digital%20designer%22%7D%2C%7B%22word%22%3A%22developer%22%7D%5D" use_custom_fonts_title="true" enable_fit="true" word_colors="rgb(255, 255, 255)" color="rgb(157, 157, 157)" fs="text_large:52px|text_small:8vw" margin="bottom_small:0px" compressor="1.25" minfontsize="30" lh="text_small:1.15em"]I’m a passionate[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" enable_fit="true" color="rgb(157, 157, 157)" fs="text_large:52px|text_small:8vw" compressor="1.25" minfontsize="30"]looking for collaboration.[/ld_fancy_heading][ld_spacer][ld_portfolio_listing style="style01" columns_gap="15" bottom_gap="48" post_type="liquid-portfolio" posts_per_page="7" enable_item_animation="yes" show_filter="yes" custom_cursor_style="lqd-cc-icon-trigger" filter_lbl_all="All" filter_size="size-custom" filter_mb="25" show_button="yes" ib_style="btn-naked" ib_title="See more" ib_i_type="linea" color_type="lqd-pf-light" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" ib_i_add_icon="true" filter_id="lqd-1574935331891-8b9c5c11-0395" filter_cats="branding, custom-print, digital-design" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_i_margin_left="15px" ib_color="rgb(112, 112, 112)" ib_hover_color="rgb(255, 255, 255)" ib_fs="13px" filter_normal_color="rgb(112, 112, 112)" filter_hover_color="rgb(255, 255, 255)" custom_filter_size="14px" pf_duration="1800" pf_delay="180" pf_init_translate_y="60" pf_start_delay="500" color_primary="rgb(20, 20, 20)"][/vc_column][/vc_row][vc_row css=".vc_custom_1605844944964{padding-bottom: 70px !important;}" el_id="about" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px"][vc_column offset="vc_col-md-3" css=".vc_custom_1575033873278{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h5" margin="bottom_small:1em"]About me[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-9"][ld_images_group_element enable_effects="yes" parallax="yes" enable_reveal="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="4342" reveal_color="rgb(116, 116, 116)" translate_from_y="55" translate_to_y="-100"][/ld_images_group_element][vc_row_inner][vc_column_inner width="5/12" offset="vc_col-md-offset-6 vc_col-md-3 vc_col-xs-6" responsive_align="text-md-right" css=".vc_custom_1575034340553{margin-top: -170px !important;}"][ld_counter use_custom_fonts_title="true" enable_blur="true" count="9" fs="300px" color="rgb(194, 137, 92)" lh="1em"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-3 vc_col-xs-6"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:21px" lh="text_medium:1.25em|text_small:0.9em"]Years of [ld_br] experience[/ld_fancy_heading][/vc_column_inner][vc_column_inner responsive_css="margin_top_medium:-4.5em"][ld_fancy_heading tag="p" delay="250" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="18px" lh="27px" ca_init_translate_y="80"]Hi, my name is Jason! Aim is to build your website so that it is functional and user friendly but at the same time attractive. My aim is to bring across your message and identity in the also have major skills in motion graphics.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1605844973705{padding-bottom: 50px !important;}" el_id="services" responsive_css="padding_top_medium:80px"][vc_column offset="vc_col-md-3" css=".vc_custom_1575033888174{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h5" margin="bottom_small:1em"]Services[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-9"][vc_row_inner enable_content_animation="yes" equal_height="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_delay="180" ca_init_translate_x="65"][vc_column_inner width="1/2" offset="vc_col-md-4 vc_col-xs-6" responsive_css="margin_bottom_medium:50px"][ld_icon_box i_type="image" heading_size="xs" alignment="text-left" i_icon_image="4348" title="Application Design" title_mb="15" icon_mb="35" h_color="rgb(255, 255, 255)"]I enjoy turning complex problems into simple solutions.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4 vc_col-xs-6" responsive_css="margin_bottom_medium:90px"][ld_icon_box i_type="image" heading_size="xs" alignment="text-left" i_icon_image="4347" title="Search Engine Opt." title_mb="15" icon_mb="35" h_color="rgb(255, 255, 255)"]Creating brand identities, digital experiences, that communicate[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4 vc_col-xs-6" responsive_css="margin_bottom_medium:90px"][ld_icon_box i_type="image" heading_size="xs" alignment="text-left" i_icon_image="4346" title="User Interface" title_mb="15" icon_mb="35" h_color="rgb(255, 255, 255)"]Beautiful and intuitive interface designs for clients.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4 vc_col-xs-6" responsive_css="margin_bottom_medium:90px"][ld_icon_box i_type="image" heading_size="xs" alignment="text-left" i_icon_image="4345" title="Social Media" title_mb="15" icon_mb="35" h_color="rgb(255, 255, 255)"]Creating brand identities, digital experiences, that communicate[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4 vc_col-xs-6" responsive_css="margin_bottom_medium:90px"][ld_icon_box i_type="image" heading_size="xs" alignment="text-left" i_icon_image="4344" title="App Development" title_mb="15" icon_mb="35" h_color="rgb(255, 255, 255)"]My aim is to bring across your digital message and identity.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4 vc_col-xs-6" responsive_css="margin_bottom_medium:90px"][ld_icon_box i_type="image" heading_size="xs" alignment="text-left" i_icon_image="4343" title="Branding Strategy" title_mb="15" icon_mb="35" h_color="rgb(255, 255, 255)"]Great work for clients with meaningful missions.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1605844997940{padding-bottom: 70px !important;}" responsive_css="padding_top_medium:50px|padding_bottom_medium:220px"][vc_column offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1575033906022{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h5" margin="bottom_small:1em"]Clients[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-9"][ld_carousel_tab columns="md:5|sm:4|xs:3|spacing_sm:50px|spacing_xs:25px" inactiv_opacity="1" enable_item_animation="yes" wraparound="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1"][ld_carousel_section title="Tab" tab_id="lqd-1594635756583-9440a3c2-6d75"][vc_single_image image="4494" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332163643{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635786754-dbc6eed8-e2f1"][vc_single_image image="4492" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332175238{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635790230-f87f18e0-0be8"][vc_single_image image="4491" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332190199{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635793597-d67b304b-a8db"][vc_single_image image="4489" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332203086{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635797036-7a912cd2-511c"][vc_single_image image="4490" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332219968{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635800274-4eeddc9b-d34b"][vc_single_image image="4488" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332267594{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Dark Portfolio - Contact
	$data = array();
	$data['name'] = esc_html__( 'Dark Portfolio - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'darkpf-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" content_placement="middle" enable_content_animation="yes" animation_preset="Fade In" responsive_css="padding_right_large:12vw|padding_left_large:12vw|padding_top_medium:200px|padding_right_medium:7vw|padding_bottom_medium:200px|padding_left_medium:7vw" css=".vc_custom_1614945804570{padding-top: 100px !important;padding-bottom: 100px !important;}" ca_delay="125"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.5em"]Looking for collaboration for your next project? Do not hesitate to contact us to say hello.[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="50px"][/vc_column][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22hello.%22%7D%2C%7B%22word%22%3A%22sallut.%22%7D%2C%7B%22word%22%3A%22%E4%BD%A0%E5%A5%BD%22%7D%2C%7B%22word%22%3A%22hallo.%20%22%7D%2C%7B%22word%22%3A%22merhaba.%22%7D%2C%7B%22word%22%3A%22%E3%82%82%E3%81%97%E3%82%82%E3%81%97.%22%7D%2C%7B%22word%22%3A%22hola.%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:3.5vw|text_small:50px" margin="bottom_large:0px" lh="text_small:1.2em"]Don't be shy. Say[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][vc_separator color="white" border_width="5" css=".vc_custom_1614943343984{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column][vc_column offset="vc_col-md-4"][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:35px" margin="bottom_large:0px"]info@hub.com[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="50px" md_height="80px"][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:15px" margin="bottom_small:0px"]Project Offers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0px" fw="text_small:700"]info@hub.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:15px" margin="bottom_small:0px"]Say hello[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0px" fw="text_small:700"]07388 252344[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][/vc_column][vc_column offset="vc_col-md-5" responsive_align="text-md-right"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Li%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="45" fs="16px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.6)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shadow - Homepage
	$data = array();
	$data['name'] = esc_html__( 'Shadow - Homepage', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'shadow-homepage.jpg' );
	$data['sort_name'] = 'Homepage';
	$data['custom_class'] = 'general homepage';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" bg_position="custom" css=".vc_custom_1603434252834{padding-top: 160px !important;padding-bottom: 50px !important;background-image: url(https://shadow.liquid-themes.com/staging/wp-content/uploads/2020/05/bg-1.png?id=29) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="-145px" responsive_css="padding_top_medium:200px|padding_right_medium:7vw|padding_left_medium:7vw"][vc_column][ld_images_group_element img_size="50%" absolute_pos="yes" image="36" position="top_small:8%25|right_small:5vw" el_class="z-index-3"][/ld_images_group_element][vc_row_inner el_class="z-index-2"][vc_column_inner][ld_fancy_heading transform="text-uppercase" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22UX%20Designer%22%7D%2C%7B%22word%22%3A%22Illustrator%22%7D%2C%7B%22word%22%3A%22Developer%22%7D%5D" use_custom_fonts_title="true" fs="text_large:11vw|text_small:13vw" lh="text_small:0.9em" margin="left_large:2vw|bottom_small:0px"][/ld_fancy_heading][ld_fancy_heading tag="h2" alignment="text-right" transform="text-uppercase" split_type="chars, words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" gradient="linear-gradient(180deg, rgba(19, 17, 23, 0.65) 0%, rgb(255, 255, 255) 100%)" fs="text_large:11vw|text_small:13vw" lh="text_small:0.9em" margin="bottom_small:0px"]In London[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_small:11vw" lh="text_small:0.9em" margin="bottom_small:0px" el_class="z-index-1" hover_text_outline_color="rgba(255, 255, 255, 0.33)" hover_text_outline_width="1px"]See my works[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1588350020344{padding-top: 50px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:70px|padding_right_medium:12vw|padding_bottom_medium:70px|padding_left_medium:12vw"][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_images_group_element enable_lightbox="yes" lightbox_group_id="shadow-lightbox" enable_hover3d="yes" image="109" margin="bottom_small:25px" img_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DnnZeDt2c8Yo|||"][/ld_images_group_element][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:24px" lh="text_small:1.5em" margin="bottom_small:0.35em"]Digital Numbers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.37)"]Creating brand identities, digital experiences, that communicate clearly.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1588350026905{padding-top: 50px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:70px|padding_right_medium:12vw|padding_bottom_medium:70px|padding_left_medium:12vw"][vc_column offset="vc_col-md-offset-4 vc_col-md-6"][ld_images_group_element enable_lightbox="yes" lightbox_group_id="shadow-lightbox" enable_hover3d="yes" image="110" margin="bottom_small:25px" img_link="|||"][/ld_images_group_element][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:24px" lh="text_small:1.5em" margin="bottom_small:0.35em"]Information Kit[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.4)"]Creating brand identities, digital experiences, that communicate clearly.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1588350033988{padding-top: 50px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:70px|padding_right_medium:12vw|padding_bottom_medium:70px|padding_left_medium:12vw"][vc_column offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5" responsive_css="margin_left_medium:-4.5vw"][ld_images_group_element enable_lightbox="yes" lightbox_group_id="shadow-lightbox" enable_hover3d="yes" image="111" margin="bottom_small:25px" img_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJ2U9Hmmpqhc|||"][/ld_images_group_element][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:24px" lh="text_small:1.5em" margin="bottom_small:0.35em"]3D iPhone[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.4)"]Creating brand identities, digital experiences, that communicate clearly.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6" responsive_css="padding_top_medium:30vh" css=".vc_custom_1605606203818{padding-top: 10vh !important;}"][ld_images_group_element enable_lightbox="yes" lightbox_group_id="shadow-lightbox" enable_hover3d="yes" image="112" margin="bottom_small:25px" img_link="|||"][/ld_images_group_element][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:24px" lh="text_small:1.5em" margin="bottom_small:0.35em"]Rotation[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.4)"]Creating brand identities, digital experiences, that communicate clearly.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1605606230955{padding-top: 60px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column align="text-center" responsive_align="text-center"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center" fadesides="lqd-fade-sides" marquee_speed="2"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603433760082-6eae0819-1090"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Webgl[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433967213-165b3b46-9d5d"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Ruby[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433970644-39e52cac-75ce"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Java[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433973732-5dd9bbb5-1239"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Dart[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][vc_row_inner responsive_css="padding_right_medium:8vw|padding_left_medium:8vw"][vc_column_inner][vc_separator color="white" border_width="2" css=".vc_custom_1588404151561{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center" fadesides="lqd-fade-sides" reverse="yes" marquee_speed="2"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603433802208-9e944f5d-8ecd"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:12vw" margin="bottom_small:0px"]Social[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433867498-a43b9d62-800b"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:12vw" margin="bottom_small:0px"]Ecommerce[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433871018-e034fb2c-ae87"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:12vw" margin="bottom_small:0px"]UI Design[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][vc_row css=".vc_custom_1605606348218{padding-top: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column offset="vc_col-lg-4 vc_col-md-5"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:24px" lh="text_small:1.5em"]Hi, I’m Daniel.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.46em" color="rgba(255, 255, 255, 0.6)"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][vc_accordion size="md" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="19px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgba(255, 255, 255, 0.56)" active_heading_color="rgb(255, 255, 255)" border_color="rgb(185, 185, 185)"][vc_accordion_tab title="Developing core applications" tab_id="lqd-1588404458746-15ba10e7-18eb"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.6)"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Digital business consultation" tab_id="lqd-1596793559971-4fb7d693-bff9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Tailor-made digital products" tab_id="lqd-1588404722047-49fc3c81-db7f"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row content_placement="middle" bg_position="right bottom" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px" css=".vc_custom_1598364173202{padding-top: 50px !important;padding-bottom: 50px !important;background-image: url(http://asymmetric-freelancer.liquid-themes.com/wp-content/uploads/2020/04/bg-2.png?id=49) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column offset="vc_col-md-offset-1 vc_col-md-4" responsive_css="padding_bottom_medium:0px" css=".vc_custom_1605606676578{padding-bottom: 20px !important;}"][ld_images_group_element image="91" margin="right_large:2vw|left_large:-8vw"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-md-offset-0 vc_col-md-2/5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605606722741{margin-bottom: 50px !important;}"][ld_fancy_heading tag="h6" margin="bottom_large:4em|bottom_small:1em"]— this is Robert Sanchez.[/ld_fancy_heading][ld_fancy_heading tag="p" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" color="rgba(255, 255, 255, 0.6)"]My name is Roberto, I’m a freelance Branding & Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic. beauty and technical performance. Our design starts and ends a best-in-class experience strategy that builds brands.[/ld_fancy_heading][ld_spacer height="45px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0.3em"]2020 — CEO — LiquidThemes[/ld_fancy_heading][vc_separator color="custom" accent_color="rgba(112,112,112,0.3)" css=".vc_custom_1588697544183{margin-top: 0px !important;margin-bottom: 0.9em !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0.3em"]2019 — Genius Tech — Apple[/ld_fancy_heading][vc_separator color="custom" accent_color="rgba(112,112,112,0.3)" css=".vc_custom_1588697544183{margin-top: 0px !important;margin-bottom: 0.9em !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0.3em"]2018 — Tech Special — Google[/ld_fancy_heading][vc_separator color="custom" accent_color="rgba(112,112,112,0.3)" css=".vc_custom_1588697544183{margin-top: 0px !important;margin-bottom: 0.9em !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0.3em"]2015 — Graduated from Yale[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-0 vc_col-md-2" responsive_css="padding_left_medium:30px"][ld_fancy_heading tag="h6" margin="bottom_large:4em|bottom_small:1em"]— services[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Art Direction[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Brand Strategy[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Tone of Voice[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Graphic Design[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Print Design[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Graphic Design[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Print Design[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Illustration &[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Packaging Design[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Tone of Voice[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Brand Identity[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Art Direction[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Brand Strategy[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:0.25em"]- Graphic Design[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1605606757404{padding-top: 40px !important;padding-bottom: 30px !important;}" responsive_css="padding_top_medium:100px|padding_right_medium:12vw|padding_bottom_medium:100px|padding_left_medium:12vw"][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341529275{margin-bottom: 15px !important;}"][vc_single_image image="53" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1596795189745{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341519612{margin-bottom: 15px !important;}"][vc_single_image image="50" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405494382{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341541786{margin-bottom: 15px !important;}"][vc_single_image image="54" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405512606{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341548479{margin-bottom: 15px !important;}"][vc_single_image image="56" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405539697{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341555590{margin-bottom: 15px !important;}"][vc_single_image image="51" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1596795213357{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341562768{margin-bottom: 15px !important;}"][vc_single_image image="55" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405607034{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1605944416251{padding-top: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:50px"][vc_column css=".vc_custom_1608024487095{border-top-width: 1px !important;padding-top: 35px !important;padding-bottom: 35px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}" responsive_css="padding_bottom_medium:35px"][vc_row_inner][vc_column_inner width="1/6" offset="vc_col-md-1 vc_col-xs-2"][ld_fancy_heading tag="p"]2020[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="7/12" offset="vc_col-md-2"][vc_single_image image="57" image_max_width="50px"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-offset-2 vc_col-md-7" responsive_align="text-md-right"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px"]Honorable Mention x 4[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1608024487095{border-top-width: 1px !important;padding-top: 35px !important;padding-bottom: 35px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}" responsive_css="padding_bottom_medium:35px"][vc_row_inner][vc_column_inner width="1/6" offset="vc_col-md-1 vc_col-xs-2"][ld_fancy_heading tag="p"]2017[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="7/12" offset="vc_col-md-2"][vc_single_image image="57" image_max_width="50px"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-offset-2 vc_col-md-7" responsive_align="text-md-right"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px"]Developer Award x3[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1608024487095{border-top-width: 1px !important;padding-top: 35px !important;padding-bottom: 35px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}" responsive_css="padding_bottom_medium:35px"][vc_row_inner][vc_column_inner width="1/6" offset="vc_col-md-1 vc_col-xs-2"][ld_fancy_heading tag="p"]2019[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="7/12" offset="vc_col-md-2"][vc_single_image image="57" image_max_width="50px"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-offset-2 vc_col-md-7" responsive_align="text-md-right"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px"]Honorable Mention x 4[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px"]Developer Award x3[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" responsive_css="padding_bottom_medium:100px"][vc_column width="1/3" offset="vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024402921{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:11px" margin="bottom_small:0px"]Looking for collaboration?[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:18px"]Hub wire[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs"][vc_separator color="white" border_width="2"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-1 vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024409989{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em"]290 Maryam Springs Courbevoie, NYC[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:18px"]+1 827 48 89[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs"][vc_separator color="white" border_width="2"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-1 vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024417804{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em"]Looking for a job? Send your resume[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:18px"]info@hub.com[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shadow - About
	$data = array();
	$data['name'] = esc_html__( 'Shadow - About', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'shadow-about.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="bottom" content_placement="middle" parallax="enable_parallax" bg_position="center center" enable_overlay="yes" css=".vc_custom_1608027163774{padding-bottom: 50px !important;background-image: url(https://shadow.liquid-themes.com/staging/wp-content/uploads/2020/12/bg-image@2x.jpg?id=247) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}" overlay_bg="linear-gradient(180deg, rgba(0, 0, 0, 0) 70%, rgb(23, 25, 26) 99.68152866242038%)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1608020287127{margin-bottom: 35px !important;}" responsive_css="margin_bottom_medium:0px" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_start_delay="650"][ld_fancy_heading split_type="chars, words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_all:160px|text_large:120px|text_medium:16vw|text_small:25vw" lh="text_small:0.85em" ls="text_small:-0.05em" margin="bottom_small:0.1em" ca_init_translate_y="0" ca_init_rotate_z="3" ca_init_translate_x="60" ca_init_rotate_x="0" ca_init_rotate_y="12"]Zack[ld_br]Cherry[/ld_fancy_heading][ld_button style="btn-naked" title="Interaction. Design. .Strategy. `{`ld_br`}` Mobile App. Development" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.9)" i_margin_left="1em"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs" responsive_css="margin_bottom_medium:0px|padding_top_medium:75px|padding_right_medium:15px|padding_left_medium:15px" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_start_delay="650" css=".vc_custom_1612016898745{margin-bottom: 15px !important;}"][vc_separator color="custom" border_width="10" accent_color="#ffffff" css=".vc_custom_1608019633241{margin-bottom: 0px !important;}"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_start_delay="900"][ld_fancy_heading tag="h2" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_all:138px|text_large:100px|text_medium:11vw|text_small:20vw" margin="bottom_large:-0.5em|bottom_small:0px" ls="text_small:-0.05em" hover_text_outline_color="rgb(255, 255, 255)"]About[/ld_fancy_heading][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" responsive_css="padding_top_medium:120px" css=".vc_custom_1608021659478{padding-top: 70px !important;padding-bottom: 20px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="100"][vc_column width="1/2"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]About me[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5" ca_duration="1600" ca_start_delay="850" ca_delay="160" ca_init_translate_y="45"][ld_fancy_heading tag="p" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.7)" lh="text_small:1.68em" ca_init_translate_y="80" ca_init_rotate_z="7" start_delay="200"]My name is Roberto, I’m a freelance Branding & Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic. beauty and technical performance. Our design starts and ends best-in-class experience strategy that builds brands.[/ld_fancy_heading][ld_spacer height="20px" md_height="45px"][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" fs="16px" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgba(255, 255, 255, 0.7)" active_heading_color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.2)" fw="400"][vc_accordion_tab title="Digital UI Design" tab_id="lqd-1608021215877-f7b3b98d-a88d"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:14px" lh="text_small:1.68em"]I’m a freelance Branding & Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences,[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Product Design" tab_id="lqd-1608021462145-1e37d61a-421f"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:14px" lh="text_small:1.68em"]I’m a freelance Branding & Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences,[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Business Consultation" tab_id="lqd-1608021475881-a987be52-c29d"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:14px" lh="text_small:1.68em"]I’m a freelance Branding & Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences,[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1608023689024{padding-top: 30px !important;padding-bottom: 30px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="100"][vc_column width="1/2"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]Experience[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5" ca_duration="1600" ca_start_delay="850" ca_delay="160" ca_init_translate_y="45"][ld_custom_menu source="custom" items="%5B%7B%22label%22%3A%222020%20%3Ci%20class%3D%5C%22lqd-icn-ess%20icon-lqd-circle%20mx-4%5C%22%3E%3C%2Fi%3E%20CEO%20%20%E2%80%94%20LiquidThemes%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222019%20%3Ci%20class%3D%5C%22lqd-icn-ess%20icon-lqd-circle%20mx-4%5C%22%3E%3C%2Fi%3E%20Senior%20Designer%20%20%E2%80%94%20Apple%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222018%20%3Ci%20class%3D%5C%22lqd-icn-ess%20icon-lqd-circle%20mx-4%5C%22%3E%3C%2Fi%3E%20Junior%20Designer%20%20%E2%80%94%20%20Google%20%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222015%20%3Ci%20class%3D%5C%22lqd-icn-ess%20icon-lqd-circle%20mx-4%5C%22%3E%3C%2Fi%3E%20Graduated%20from%20Yale%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" color="rgba(255, 255, 255, 0.7)" hcolor="rgb(255, 255, 255)" spacing="30"][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1608025876286{padding-top: 40px !important;padding-bottom: 40px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="100"][vc_column width="1/2"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]Skills[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5" ca_duration="1600" ca_start_delay="850" ca_delay="160" ca_init_translate_y="45"][vc_row_inner][vc_column_inner width="1/2"][ld_custom_menu source="custom" magnetic_items="true" items="%5B%7B%22label%22%3A%22Art%20Direction%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%20Brand%20Strategy%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%20Communication%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Graphic%20Design%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%20Print%20Design%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%20Motion%20Graphics%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="15" color="rgba(255, 255, 255, 0.7)" hcolor="rgb(255, 255, 255)"][/vc_column_inner][vc_column_inner width="1/2"][ld_custom_menu source="custom" magnetic_items="true" items="%5B%7B%22label%22%3A%22Brand%20Guide%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Flayer%20Design%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Video%20Production%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Web%20Advertising%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Illustrations%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Content%20Creation%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="15" color="rgba(255, 255, 255, 0.7)" hcolor="rgb(255, 255, 255)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1608025866035{padding-top: 40px !important;padding-bottom: 40px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="100"][vc_column width="1/2"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]Awards[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5" ca_duration="1600" ca_start_delay="850" ca_delay="160" ca_init_translate_y="45"][ld_custom_menu source="custom" magnetic_items="true" items="%5B%7B%22label%22%3A%22%3Ci%20class%3D%5C%22mr-5%5C%22%20style%3D%5C%22font-style%3A%20normal%3B%20opacity%3A%200.7%5C%22%3E3x%3C%2Fi%3E%20AW%20Site%20of%20the%20Day%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%3Ci%20class%3D%5C%22mr-5%5C%22%20style%3D%5C%22font-style%3A%20normal%3B%20opacity%3A%200.7%5C%22%3E1x%3C%2Fi%3E%20FTA%20Best%20Interactivity%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%3Ci%20class%3D%5C%22mr-5%5C%22%20style%3D%5C%22font-style%3A%20normal%3B%20opacity%3A%200.7%5C%22%3E2x%3C%2Fi%3E%20CSS%20Design%20Awards%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%3Ci%20class%3D%5C%22mr-5%5C%22%20style%3D%5C%22font-style%3A%20normal%3B%20opacity%3A%200.7%5C%22%3E6x%3C%2Fi%3E%20AW%20Honorable%20Mention%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%3Ci%20class%3D%5C%22mr-5%5C%22%20style%3D%5C%22font-style%3A%20normal%3B%20opacity%3A%200.7%5C%22%3E2x%3C%2Fi%3E%20Red%20Dot%20Graphic%20Design%20Awards%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22%3Ci%20class%3D%5C%22mr-5%5C%22%20style%3D%5C%22font-style%3A%20normal%3B%20opacity%3A%200.7%5C%22%3E1x%3C%2Fi%3E%20AW%20Collections%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="15" color="rgba(255, 255, 255, 0.7)" hcolor="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1608026193087{padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;}" responsive_css="padding_top_small:50px|padding_bottom_small:50px"][vc_column width="1/2" align="text-center" offset="vc_col-md-3" responsive_align="text-md-left"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]Clients[/ld_fancy_heading][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_small:90px|padding_bottom_small:90px" css=".vc_custom_1608025725377{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="225" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025168012{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1608025922593{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="218" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025209217{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_top_medium:1px|border_left_medium:1px|border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167238443{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="224" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025217984{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1606167249830{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_css="border_left_medium:0px|border_left_small:1px|padding_top_small:80px|padding_bottom_small:80px" responsive_align="text-center"][vc_single_image image="217" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025250001{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px|padding_top_small:90px|padding_bottom_small:90px" css=".vc_custom_1608025757964{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="215" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025242330{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167274508{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="211" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025261402{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167286802{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" fadeeffect="yes" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bottom_offset="0" autoplaytime="3800" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595920532443-74056658-209a"][vc_single_image image="212" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025783680{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595920532744-efdf2255-df73"][vc_single_image image="213" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025673969{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:1px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167298395{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="219" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025292406{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_top_medium:1px|border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1608025810148{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" fadeeffect="yes" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bottom_offset="0" autoplaytime="5500" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595920417812-eae19c99-abc8"][vc_single_image image="51" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025531321{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595920417962-2c67d1a8-3110"][vc_single_image image="50" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025664057{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" responsive_css="padding_bottom_medium:100px|padding_top_small:50px" css=".vc_custom_1608025838088{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column width="1/3" offset="vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024402921{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:11px" margin="bottom_small:0px"]Looking for collaboration?[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:18px"]Hub wire[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs"][vc_separator color="white" border_width="2"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-1 vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024409989{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em"]290 Maryam Springs Courbevoie, NYC[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:18px"]+1 827 48 89[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs"][vc_separator color="white" border_width="2"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-1 vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024417804{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em"]Looking for a job? Send your resume[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:18px"]info@hub.com[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shadow - Contact
	$data = array();
	$data['name'] = esc_html__( 'Shadow - Contact', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $pages_uri . 'shadow-contact.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['page_template'] = true;
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" video_bg="yes" video_bg_source="youtube" video_bg_url="https://www.youtube.com/watch?v=5bnc8AxRTFc" enable_overlay="yes" css=".vc_custom_1614944976163{padding-top: 70px !important;padding-right: 10px !important;padding-bottom: 70px !important;padding-left: 10px !important;}" overlay_bg="rgba(25, 25, 25, 0.74)"][vc_column offset="vc_col-md-6" css=".vc_custom_1573716825914{margin-bottom: 30px !important;}"][ld_fancy_heading transform="text-uppercase" use_custom_fonts_title="true" fs="text_large:106px|text_small:33px" margin="bottom_small:0px"]SAY HI[/ld_fancy_heading][ld_fancy_heading transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:106px|text_small:33px" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.29)" hover_text_outline_width="1px"]AVAILABLE[/ld_fancy_heading][ld_fancy_heading transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:106px|text_small:33px" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.35)" hover_text_outline_width="1px"]IN 2021[/ld_fancy_heading][ld_spacer][ld_fancy_heading tag="h5" margin="bottom_small:0em"]Currently, I am not available for freelance work. But I always love to hear from you,[/ld_fancy_heading][ld_spacer height="42px"][vc_row_inner css=".vc_custom_1573716672018{margin-bottom: 40px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1614943101023{padding-top: 6px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" ls="text_small:0px" fs="text_small:16px" fw="text_small:700"]Address[/ld_fancy_heading][ld_fancy_heading tag="p"]290 Maryam Springs 260, Courbevoie, Paris, France[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" ls="text_small:0px" fs="text_small:16px" fw="text_small:700"]Contact[/ld_fancy_heading][ld_fancy_heading tag="p"]+47 213 5941 295 hello@liquid.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ld_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="28px" primary_color="rgba(255, 255, 255, 0.47)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" css=".vc_custom_1614942993185{margin-bottom: 30px !important;padding-top: 45px !important;padding-right: 20px !important;padding-bottom: 15px !important;padding-left: 20px !important;border-radius: 2px !important;}" offset="vc_col-md-offset-1 vc_col-md-5" responsive_align="text-left"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:23px"]Send a message[/ld_fancy_heading][ld_fancy_heading tag="h6" margin="bottom_small:0em" color="rgba(255, 255, 255, 0.37)"]Currently, I am not available for freelance work. But I always love to hear from you.[/ld_fancy_heading][ld_spacer][ld_cf7 id="73" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-md" roundness="lqd-contact-form-inputs-circle" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-circle" use_custom_fonts_input="true" color="rgb(184, 184, 184)" border_color="rgba(255, 255, 255, 0.32)" submit_bg_color="rgb(29, 29, 29)" submit_border_color="rgb(29, 29, 29)" submit_hbg_color="rgb(46, 46, 46)" submit_hover_border_color="rgb(46, 46, 46)" lqd_bg_color="rgba(255, 255, 255, 0.07)" fs="16px" h_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]— copy email: zack@hub.com[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
		
	return $templates;

}