<?php

function liquid_responsive_css() {
	
	$css = '';

	$max_media_mobile_nav = liquid_helper()->get_option( 'media-mobile-nav' );
	if( empty( $max_media_mobile_nav ) ) {
		$max_media_mobile_nav = 1199;
	}
	$min_media_mobile_nav = $max_media_mobile_nav + 1;
	
	$site_layout = liquid_helper()->get_option( 'page-layout' );
	if( empty( $site_layout ) ) {
		$site_layout = 'wide';
	}
	$site_width  = liquid_helper()->get_option( 'site-width' );
	if( empty( $site_width ) ) {
		$site_width = 1170;
	}
	$site_width_media  = $site_width + 30;
	
	if( 'boxed' === $site_layout ) {
		$css = "@media screen and ( min-width: {$site_width_media}px ) {

					.is-stuck,
					.footer-stuck,
					#wrap {
						max-width: {$site_width}px;
						margin: 0 auto;
					}
					.main-header .container-fluid,
					.main-header .container,
					.container {
						width: 100%;
						max-width: 100%;
					}
					.main-footer .vc_row,
					.content .vc_row {
						padding-inline-start: 15px;
						padding-inline-end: 15px;
					}
				}";
	}
	else {
		$css = "@media screen and ( min-width: {$site_width_media}px ) {

					.main-header .container {
						max-width: {$site_width}px;
					}
					.container {
						width: {$site_width}px;
					}
				}";
	}	
	
	$css .= "@media screen and (min-width: {$min_media_mobile_nav}px) {
		.lqd-visible-mobile {
			display: none !important;
		}
		.lqd-stack-moving-down .lqd-head-sec-wrap:not(.is-stuck) .social-icon a,
		.lqd-stack-moving-down .lqd-head-sec-wrap:not(.is-stuck) .header-module .ld-module-trigger,
		.lqd-stack-moving-down .lqd-head-sec-wrap:not(.is-stuck) .main-nav > li > a,
		.lqd-stack-moving-down .lqd-head-sec-wrap:not(.is-stuck) .navbar-brand .logo-light,
		.lqd-stack-moving-down .lqd-head-sec-wrap:not(.is-stuck) .navbar-brand .logo-dark {
			transition-delay: 0.35s;
		}
		.lqd-custom-menu .megamenu .nav-item-children {
			left: 100%!important;
			margin-top: -1px;
		}
		.lqd-custom-menu .megamenu.megamenu-fullwidth .megamenu-container {
			width: 100%;
		}
		.lqd-custom-menu .megamenu.megamenu-fullwidth .ld-container {
			max-width: none;
		}
		.lqd-custom-menu .megamenu.megamenu-fullwidth .nav-item-children {
			left: 100%;
			right: auto;
			margin-inline-start: 0;
			margin-inline-end: 0;
		}
		.lqd-custom-menu .submenu-expander {
			width: auto;
			height: auto;
			background-color: transparent;
			font-size: 13px;
		}
		.header-side {
			width: 375px;
			height: 100vh;
			position: fixed;
			top: 0;
			left: 0;
		}
		.header-side .lqd-head-sec,
		.header-side .lqd-head-container,
		.header-side .lqd-head-row,
		.header-side .lqd-head-sec-wrap {
			width: 100%;
			height: 100%;
		}
		.header-side .lqd-head-container {
			padding: 0;
		}
		.header-side .lqd-head-sec-wrap {
			padding: 12vh 50px;
			overflow: hidden;
			position: relative;
		}
		.header-side .lqd-head-sec {
			overflow: hidden;
		}
		.header-side .lqd-head-row {
			width: calc(100% + 20px);
			margin: 0;
			flex-direction: column;
			justify-content: space-between;
			overflow-x: hidden;
			overflow-y: auto;
		}
		.header-side .lqd-head-col {
			padding: 0;
			margin: 30px 0;
			flex-direction: column;
			align-items: flex-start;
			justify-content: center;
			flex: 1 auto;
		}
		.header-side .lqd-head-col:first-child {
			margin-top: 0;
			justify-content: flex-start;
		}
		.header-side .lqd-head-col:last-child {
			margin-bottom: 0;
			justify-content: flex-end;
		}
		.header-side .navbar-header {
			align-items: flex-start;
		}
		.header-side .navbar-brand {
			padding: 0;
		}
		.header-side .navbar-collapse {
			width: 100%;
		}
		.header-side .navbar-collapse.navbar-visible-ontoggle {
			flex-direction: column;
			justify-content: center;
			width: 375px;
			height: 100vh!important;
			position: fixed;
			top: 0;
			left: 0;
			z-index: 10;
			transform: translateX(-200%);
			background-color: #fdfdfe;
			box-shadow: 0 0 0 #f0f1f6 inset;
			transition: all 0.45s cubic-bezier(0.7, 0, 0.2, 1);
		}
		.header-side .navbar-collapse.navbar-visible-ontoggle.is-active {
			transform: translateX(-100%);
			box-shadow: -70px 0 70px #f0f1f6 inset;
		}
		.header-side .navbar-collapse.navbar-visible-ontoggle .main-nav {
			flex-grow: 0;
		}
		.header-side .main-nav {
			width: calc(100% + 25px);
			padding-inline-end: 25px;
			display: block;
			overflow-x: hidden;
			overflow-y: auto;
		}
		.header-side .main-nav > li {
			align-items: flex-start;
		}
		.header-side .main-nav > li > a {
			display: block;
			width: 100%;
			padding-inline-start: 0;
		}
		.header-side .main-nav .link-sup {
			top: -1.5em;
			right: -0.5em;
		}
		.header-side .nav-item-children {
			padding-inline-end: 15px;
		}
		.header-side .header-module {
			display: block;
			width: 100%;
			padding-top: 0;
			padding-bottom: 0;
			margin-inline-start: 0 !important;
			flex: 0;
		}
		.header-side .header-module > h1,
		.header-side .header-module > h2,
		.header-side .header-module > h3,
		.header-side .header-module > h4,
		.header-side .header-module > h5,
		.header-side .header-module > h6 {
			margin-top: 0;
			margin-bottom: 0.25em;
		}
		.header-side .header-module > h1:only-child,
		.header-side .header-module > h2:only-child,
		.header-side .header-module > h3:only-child,
		.header-side .header-module > h4:only-child,
		.header-side .header-module > h5:only-child,
		.header-side .header-module > h6:only-child {
			margin-bottom: 0;
		}
		.header-side .header-module:not(:only-child):not(:last-child) {
			margin-bottom: 15px;
		}
		.header-side .ld-module-dropdown,
		.header-side .ld-dropdown-menu-content {
			background: none;
		}
		.header-side .ld-dropdown-menu-content {
			margin-top: 1em;
			width: auto;
			padding: 0;
			border: none;
		}
		.header-side .ld-module-search .ld-module-trigger {
			transform: translateX(0);
			transition: transform 0.45s cubic-bezier(0.86, 0, 0.07, 1);
		}
		.header-side .ld-module-search .ld-module-trigger.collapse {
			transform: translateX(-100%);
		}
		.header-side .ld-module-search .ld-search-form-container {
			transform: translateX(-100%);
			transition: transform 0.45s cubic-bezier(0.86, 0, 0.07, 1);
		}
		.header-side .ld-module-search .ld-module-dropdown {
			width: 250px;
			height: auto !important;
			top: 0;
			left: 0;
			right: auto;
			overflow: hidden;
		}
		.header-side .ld-module-search .ld-module-dropdown.is-active .ld-search-form-container {
			transform: translateX(0);
		}
		.header-side .ld-search-form-container {
			width: auto;
			padding: 0;
			border: none;
		}
		.header-style-side .titlebar,
		.header-style-side #lqd-site-content,
		.header-style-side #wrap > .main-header,
		.header-style-side .main-footer {
			transition: transform 0.45s cubic-bezier(0.7, 0, 0.2, 1);
		}
		.side-nav-showing .titlebar,
		.side-nav-showing #lqd-site-content,
		.side-nav-showing #wrap > .main-header,
		.side-nav-showing .main-footer {
			transform: translateX(375px);
		}
		.lqd-stack-initiated .header-side {
			width: 200px;
		}
		.lqd-stack-initiated .header-side .lqd-head-sec-wrap {
			padding: 10vh 45px;
		}
		.lqd-stack-initiated.header-style-side #wrap {
			padding-inline-start: 0;
		}
		.navbar-fullscreen {
			display: flex !important;
			width: 100vw;
			height: 100vh !important;
			padding: 150px 0 50px;
			position: fixed;
			top: 0;
			left: 0;
			z-index: 90;
			opacity: 0;
			justify-content: flex-end;
			flex-direction: column;
			overflow: hidden;
			visibility: hidden;
			transition: all 0.15s 0.8s ease;
			transform: translateZ(0);
		}
		.navbar-fullscreen:before, .navbar-fullscreen:after {
			content: none;
		}
		.navbar-fullscreen .main-nav-trigger {
			position: fixed;
			top: 4em;
			right: 4em;
			z-index: 92;
			opacity: 0;
			visibility: hidden;
			transition: opacity 0.3s, visibility 0.3s;
		}
		.navbar-fullscreen .main-nav-trigger .txt {
			display: none;
		}
		.navbar-fullscreen .navbar-collapse {
			height: auto !important;
			overflow: visible !important;
		}
		.navbar-fullscreen .main-nav {
			flex-direction: column;
		}
		.navbar-fullscreen .main-nav > li {
			flex-direction: row;
		}
		.navbar-fullscreen .main-nav > li > a {
			padding-inline-start: 0;
			padding-inline-end: 0;
		}
		.navbar-fullscreen .nav-item-children {
			box-shadow: none;
		}
		.navbar-fullscreen .nav-item-children > li > a {
			padding: 0;
		}
		.navbar-fullscreen .nav-item-children > li:hover > a {
			background-color: transparent;
		}
		.navbar-fullscreen .megamenu .nav-item-children {
			display: none;
			visibility: visible;
			left: auto !important;
			right: auto !important;
		}
		.navbar-fullscreen .megamenu .ld-container,
		.navbar-fullscreen .megamenu .megamenu-column,
		.navbar-fullscreen .megamenu .megamenu-container {
			width: 100% !important;
		}
		.navbar-fullscreen .megamenu section.vc_row {
			padding: 0 !important;
		}
		.navbar-fullscreen .megamenu .ld-row {
			display: block;
		}
		.navbar-fullscreen .lqd-fsh-bg-side-container,
		.navbar-fullscreen .lqd-fsh-bg-side-container span,
		.navbar-fullscreen .lqd-fsh-bg-container,
		.navbar-fullscreen .lqd-fsh-bg-row,
		.navbar-fullscreen .lqd-fsh-bg-col,
		.navbar-fullscreen .lqd-fsh-bg-col span,
		.navbar-fullscreen .lqd-fsh-bg {
			height: 100%;
		}
		.navbar-fullscreen .lqd-fsh-bg-side-container,
		.navbar-fullscreen .lqd-fsh-bg-col {
			position: relative;
		}
		.navbar-fullscreen .lqd-fsh-bg-side-container:before,
		.navbar-fullscreen .lqd-fsh-bg-col:before {
			content: '';
			display: inline-block;
			width: 1px;
			height: 100%;
			position: absolute;
			top: 0;
			right: 0;
			z-index: 2;
			background-color: rgba(0, 0, 0, 0.1);
			transform: scaleY(0);
			transform-origin: center top;
			transition: transform 0.75s cubic-bezier(0.7, 0, 0.2, 1);
		}
		.navbar-fullscreen .lqd-fsh-bg-side-container span,
		.navbar-fullscreen .lqd-fsh-bg-col span {
			display: inline-block;
			width: 100%;
			background-color: #fff;
			transform: scaleX(0);
			transform-origin: left center;
			transition: transform 0.65s 0.3s cubic-bezier(0.7, 0, 0.2, 1);
		}
		.navbar-fullscreen .lqd-fsh-bg-container,
		.navbar-fullscreen .lqd-fsh-bg-side-container {
			flex: 1 auto;
		}
		.navbar-fullscreen .lqd-fsh-bg-container {
			margin: 0;
		}
		.navbar-fullscreen .lqd-fsh-bg {
			display: flex;
			width: 100%;
			position: fixed;
			top: 0;
			left: 0;
		}
		.navbar-fullscreen .header-modules-container {
			display: flex;
			flex-direction: column;
			flex-grow: 1;
			clip-path: polygon(0 0, 0 0, 0 100%, 0% 100%);
			transition: clip-path 0.8s 0s cubic-bezier(0.4, 0, 0.2, 1);
		}
		.navbar-fullscreen .header-modules-container > .container {
			display: flex;
			flex-direction: column;
			padding: 0;
		}
		.navbar-fullscreen .header-modules-container > .container:before, .navbar-fullscreen .header-modules-container > .container:after {
			content: none;
		}
		.navbar-fullscreen .header-modules-container > .container,
		.navbar-fullscreen .header-modules-container > .container > .row {
			flex-grow: 1;
		}
		.navbar-fullscreen .header-modules-container > .container > .row {
			display: flex;
			flex-direction: column;
		}
		.navbar-fullscreen .vc_row {
			flex-grow: 1;
		}
		.navbar-fullscreen .module-primary-nav {
			min-height: calc(100vh - 250px);
		}
		.navbar-fullscreen .module-primary-nav:only-child {
			display: flex;
			flex-direction: column;
			flex-grow: 1;
		}
		.navbar-fullscreen .module-primary-nav:only-child .navbar-collapse {
			flex-grow: 1;
			width: 100%;
		}
		.navbar-fullscreen .main-nav > li,
		.navbar-fullscreen .main-nav > li > a {
			align-items: stretch;
		}
		.navbar-fullscreen .navbar-collapse,
		.navbar-fullscreen .module-primary-nav {
			width: 100%;
		}
		.navbar-fullscreen .justify-content-lg-end .main-nav .link-sup {
			right: auto;
			left: -1em;
		}
		.navbar-fullscreen.is-active {
			opacity: 1;
			visibility: visible;
			transition-delay: 0s;
		}
		.navbar-fullscreen.is-active .main-nav-trigger {
			opacity: 1;
			visibility: visible;
			transition-delay: 0.6s;
		}
		.navbar-fullscreen.is-active .lqd-fsh-bg-side-container:before,
		.navbar-fullscreen.is-active .lqd-fsh-bg-col:before {
			transform: scaleY(1);
			transition-delay: 0.25s;
		}
		.navbar-fullscreen.is-active .lqd-fsh-bg-side-container > span,
		.navbar-fullscreen.is-active .lqd-fsh-bg-col > span {
			transform: scaleX(1);
			transition-delay: 0.05s;
		}
		.navbar-fullscreen.is-active .header-modules-container {
			transition-duration: 2s;
			transition-delay: 0.15s;
			clip-path: polygon(0 0, 100% 0, 100% 100%, 0% 100%);
		}
		.lqd-stickybar-wrap .navbar-fullscreen,
		.lqd-stickybar-wrap .navbar-fullscreen .header-module {
			writing-mode: horizontal-tb;
		}
		.navbar-collapse ~ .header-module {
			margin-inline-start: 25px;
		}
		.navbar-collapse:not(.navbar-fullscreen) .header-module {
			display: none;
		}
		.ld-module-cart-offcanvas > .ld-module-trigger:before {
			content: '';
			display: inline-block;
			width: 100vw;
			height: 100vw;
			position: fixed;
			top: 0;
			left: 0;
			z-index: 11;
			opacity: 1;
			visibility: visible;
			background-color: rgba(0, 0, 0, 0.6);
			transition: opacity 0.25s ease, visibility 0.25s ease;
		}
		.ld-module-cart-offcanvas > .ld-module-trigger.collapsed:before {
			opacity: 0;
			visibility: hidden;
		}
		.ld-module-cart-offcanvas .ld-module-dropdown {
			display: block;
			height: 100vh !important;
			position: fixed;
			top: 0;
			right: 0;
			z-index: 12;
			opacity: 0;
			max-height: none;
			box-shadow: -20px 0 60px rgba(0, 0, 0, 0.1);
			transform: translateX(100%);
			transition: transform 0.65s 0s, opacity 0.25s 0.4s;
			transition-timing-function: cubic-bezier(0.23, 1, 0.32, 1);
			will-change: transform;
		}
		.ld-module-cart-offcanvas .ld-module-dropdown.is-active {
			opacity: 1;
			transform: translateX(0);
			transition-delay: 0.1s;
		}
		.ld-module-cart-offcanvas .ld-cart-contents {
			width: 435px;
			height: 100vh;
			padding: 30px 35px;
			border: none;
			overflow-y: auto;
		}
		.ld-module-cart-offcanvas .header-quickcart {
			display: flex;
			flex-direction: column;
			min-height: 100%;
		}
		.ld-module-cart-offcanvas .ld-cart-head {
			display: flex;
			padding: 0 0 15px;
			border-bottom: 1px solid #e1e1e1;
			font-size: 20px;
			font-weight: 500;
		}
		.ld-module-cart-offcanvas .ld-cart-head .ld-cart-head-txt {
			display: flex;
			align-items: center;
			line-height: 1.5em;
		}
		.ld-module-cart-offcanvas .ld-cart-head .ld-module-trigger-count {
			width: 2em;
			height: 2em;
			margin-inline-start: 1em;
			background-color: #000;
		}
		.ld-module-cart-offcanvas .ld-cart-head .ld-module-trigger, .is-stuck .ld-module-cart-offcanvas .ld-cart-head .ld-module-trigger {
			color: #000 !important;
		}
		.ld-module-cart-offcanvas .ld-cart-foot,
	.ld-module-cart-offcanvas .ld-cart-product {
			padding-inline-start: 0;
			padding-inline-end: 0;
		}
		.ld-module-cart-offcanvas .ld-cart-product:last-child {
			border-bottom: none;
		}
		.ld-module-cart-offcanvas .ld-cart-product:hover .ld-cart-product-info figure {
			box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
			transform: translateY(-2px);
		}
		.ld-module-cart-offcanvas .ld-cart-product-details {
			width: 45%;
			flex-grow: 0;
		}
		.ld-module-cart-offcanvas .ld-cart-product-info figure {
			border-radius: 2px;
			box-shadow: 0 0 0 rgba(0, 0, 0, 0.2);
			transition: box-shadow 0.3s, transform 0.3s;
		}
		.ld-module-cart-offcanvas .ld-cart-product-name {
			font-size: 17px;
		}
		.ld-module-cart-offcanvas .ld-cart-product-price {
			display: block;
			max-width: 45%;
			font-size: 16px;
			position: absolute;
			top: 50%;
			right: 30px;
			transform: translateY(-50%);
		}
		.ld-module-cart-offcanvas a.ld-cart-product-remove.remove {
			width: 16px;
			height: 16px;
			border: none;
			left: auto;
			right: 0;
			top: calc(50% - 8px);
			opacity: 1;
			visibility: visible;
			font-size: 26px;
			color: var(--color-primary) !important;
		}
		.ld-module-cart-offcanvas a.ld-cart-product-remove.remove:hover {
			background: none;
			color: red !important;
		}
		.ld-module-cart-offcanvas .ld-cart-foot {
			margin-top: auto;
			margin-bottom: 40px;
		}
		.ld-module-cart-offcanvas .ld-cart-total {
			padding-top: 20px;
			padding-bottom: 10px;
			border-top: 1px solid #e1e1e1;
		}
		.ld-module-cart-offcanvas .ld-cart-total-price,
	.ld-module-cart-offcanvas .ld-cart-total-label {
			font-weight: 500 !important;
			text-transform: none !important;
			letter-spacing: 0 !important;
		}
		.ld-module-cart-offcanvas .ld-cart-total-label {
			font-size: 16px;
		}
		.ld-module-cart-offcanvas .ld-cart-total-price {
			font-size: 20px;
		}
		.ld-module-cart-offcanvas .ld-cart-button .btn {
			font-size: 15px;
			font-weight: 500 !important;
			text-transform: none !important;
			letter-spacing: 0 !important;
		}
		.ld-module-cart-offcanvas .ld-cart-button .btn + .btn {
			margin-top: 1em;
		}
		.ld-module-cart-offcanvas .ld-cart-button .btn-naked i {
			display: none;
		}
		.ld-module-cart-offcanvas .blockUI.blockOverlay {
			width: auto !important;
			left: -35px !important;
			right: -35px !important;
		}
		.ld-module-cart-offcanvas .ld-cart-message {
			margin: -19px -35px -30px;
		}
		.ld-module-to-left .ld-module-cart-offcanvas .ld-module-dropdown {
			right: auto;
			left: 0;
			transform: translateX(-100%);
		}
		.ld-module-to-left .ld-module-cart-offcanvas .ld-module-dropdown.is-active {
			transform: translateX(0);
		}
		.ld-search-form .input-icon {
			pointer-events: none;
		}
		.lqd-module-search-slide-top .ld-search-form-container {
			width: 100%;
			transition: transform 0.85s cubic-bezier(0.175, 1, 0.275, 1);
		}
		.lqd-module-search-slide-top p {
			font-size: 16px;
		}
		.lqd-module-search-slide-top .ld-search-form {
			width: 100%;
		}
		.lqd-module-search-slide-top .ld-search-form input {
			height: 100px;
			padding: 0;
			margin-bottom: 20px;
			border-bottom: 4px solid #000;
			background: none;
			font-size: 70px;
			font-weight: 600;
			color: #000;
		}
		.lqd-module-search-slide-top .ld-search-form input::-webkit-input-placeholder {
			color: #000;
		}
		.lqd-module-search-slide-top .ld-search-form input::-moz-placeholder {
			color: #000;
		}
		.lqd-module-search-slide-top .ld-search-form input:-moz-placeholder {
			color: #000;
		}
		.lqd-module-search-slide-top .ld-search-form input:-ms-input-placeholder {
			color: #000;
		}
		.lqd-module-search-slide-top .ld-search-form .input-icon {
			display: inline-flex;
			width: 50px;
			height: 50px;
			margin-top: -10px;
			left: auto;
			right: 0;
			pointer-events: all;
			align-items: center;
			justify-content: center;
			cursor: pointer;
		}
		.lqd-module-search-slide-top .ld-search-form .input-icon:before {
			content: '';
			display: inline-block;
			width: 100%;
			height: 100%;
			border-radius: 50em;
			background-color: rgba(0, 0, 0, 0.05);
			transform: scale(0);
			transition: transform 0.85s cubic-bezier(0.175, 1, 0.275, 1);
		}
		.lqd-module-search-slide-top .ld-search-form .input-icon i:before, .lqd-module-search-slide-top .ld-search-form .input-icon i:after {
			content: '';
			display: inline-block;
			width: 22px;
			height: 2px;
			margin: -1px 0 0 -11px;
			border-radius: 50em;
			position: absolute;
			top: 50%;
			left: 50%;
			background-color: #000;
			transition: transform 0.85s 0.3s cubic-bezier(0.175, 1, 0.275, 1);
		}
		.lqd-module-search-slide-top .ld-search-form .input-icon i:before {
			transform: rotate(45deg) translateX(-17px) scale(0, 1);
		}
		.lqd-module-search-slide-top .ld-search-form .input-icon i:after {
			transform: rotate(-45deg) translateX(17px) scale(0, 1);
		}
		.lqd-module-search-slide-top .ld-search-form .input-icon:hover:before {
			transition-delay: 0 !important;
			transform: scale(1.125) !important;
		}
		.lqd-module-search-slide-top .ld-search-form-container {
			display: flex;
			width: 100%;
			height: 100%;
			max-width: 1200px;
			flex-direction: column;
			justify-content: center;
			border: none;
			padding: 0;
			margin: 0 auto;
			background: none;
			backface-visibility: hidden;
			transform: translate3d(0, calc(100% - 100px), 0);
			transition: transform 0.85s cubic-bezier(0.175, 1, 0.275, 1);
		}
		.lqd-module-search-slide-top .ld-module-dropdown {
			display: flex;
			width: 100%;
			height: 380px !important;
			flex-direction: column;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 999;
			background: #fff;
			overflow: hidden;
			visibility: hidden;
			backface-visibility: hidden;
			transform: translate3d(0, -100%, 0);
			transition: transform 0.85s cubic-bezier(0.175, 1, 0.275, 1), visibility 0.8s step-end;
		}
		.lqd-module-search-slide-top .ld-module-dropdown.is-active {
			visibility: visible;
			transition: transform 0.85s cubic-bezier(0.175, 1, 0.275, 1), visibility 0.8s step-start;
		}
		.lqd-module-search-slide-top .ld-module-dropdown.is-active,
		.lqd-module-search-slide-top .ld-module-dropdown.is-active .ld-search-form-container {
			transform: translate3d(0, 0, 0);
		}
		.lqd-module-search-slide-top .ld-module-dropdown.is-active .ld-search-form .input-icon:before {
			transition-delay: 0.15s;
			transform: scale(1);
		}
		.lqd-module-search-slide-top .ld-module-dropdown.is-active .ld-search-form .input-icon i:before {
			transition-delay: 0.35s;
			transform: rotate(45deg) translate(0, 0) scale(1);
		}
		.lqd-module-search-slide-top .ld-module-dropdown.is-active .ld-search-form .input-icon i:after {
			transition-delay: 0.42s;
			transform: rotate(-45deg) translate(0, 0) scale(1);
		}
		.lqd-module-search-slide-top .ld-module-dropdown.is-active .ld-search-form-container {
			opacity: 1;
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form {
			color: rgba(255, 255, 255, 0.65);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form input {
			border-color: #fff;
			color: #fff;
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form input::-webkit-input-placeholder {
			color: rgba(255, 255, 255, 0.65);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form input::-moz-placeholder {
			color: rgba(255, 255, 255, 0.65);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form input:-moz-placeholder {
			color: rgba(255, 255, 255, 0.65);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form input:-ms-input-placeholder {
			color: rgba(255, 255, 255, 0.65);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form .input-icon:before {
			background-color: rgba(255, 255, 255, 0.13);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form .input-icon i:before, .lqd-module-search-slide-top.lqd-module-search-dark .ld-search-form .input-icon i:after {
			background-color: #fff;
		}
		.lqd-module-search-slide-top.lqd-module-search-dark p {
			color: rgba(255, 255, 255, 0.6);
		}
		.lqd-module-search-slide-top.lqd-module-search-dark .ld-module-dropdown {
			background-color: #000;
		}
		.lqd-search-style-slide-top:before {
			content: '';
			display: inline-block;
			width: 100vw;
			height: 100vh;
			position: fixed;
			top: 0;
			left: 0;
			background-color: rgba(0, 0, 0, 0.3);
			z-index: 3;
			opacity: 0;
			visibility: hidden;
			transition: opacity 0 0.85s cubic-bezier(0.175, 1, 0.275, 1), visibility 0 0.85s cubic-bezier(0.175, 1, 0.275, 1);
		}
		.lqd-module-search-expanded .lqd-search-style-slide-top:before {
			opacity: 1;
			visibility: visible;
		}
		.lqd-module-search-expanded.module-collapsing .lqd-search-style-slide-top:before {
			opacity: 0;
			visibility: hidden;
		}
		.lqd-module-search-frame {
			color: #a0a2ae;
		}
		.lqd-module-search-frame .ld-search-form-container {
			display: flex;
			width: 100%;
			height: 100vh;
			position: fixed;
			top: 0;
			left: 0;
			z-index: 1000;
			flex-direction: column;
			justify-content: center;
			align-items: center;
			background: rgba(18, 23, 56, 0.9);
			text-align: center;
			pointer-events: none;
			opacity: 0;
			transition: opacity 0.5s;
		}
		.lqd-module-search-frame .ld-search-form-container:before, .lqd-module-search-frame .ld-search-form-container:after {
			content: '';
			position: absolute;
			width: calc(100% + 15px);
			height: calc(100% + 15px);
			pointer-events: none;
			border: 1.5em solid #212fa0;
			transition: transform 0.5s;
		}
		.lqd-module-search-frame .ld-search-form-container:before {
			top: 0;
			left: 0;
			border-right-width: 0;
			border-bottom-width: 0;
			transform: translate3d(-15px, -15px, 0);
		}
		.lqd-module-search-frame .ld-search-form-container:after {
			right: 0;
			bottom: 0;
			border-top-width: 0;
			border-left-width: 0;
			transform: translate3d(15px, 15px, 0);
		}
		.lqd-module-search-frame .lqd-module-search-close {
			border: none;
			position: absolute;
			top: 30px;
			right: 70px;
			font-size: 120px;
			line-height: 50px;
			box-shadow: none;
			cursor: pointer;
			transform: scale3d(0.8, 0.8, 1);
			transition: opacity 0.5s, transform 0.5s;
		}
		.lqd-module-search-frame .lqd-module-search-close:hover {
			background: none;
			transform: scale(0.9) !important;
		}
		.lqd-module-search-frame .ld-search-form {
			margin: 5em 0;
			opacity: 0;
			transform: scale3d(0.8, 0.8, 1);
			transition: opacity 0.5s, transform 0.5s;
		}
		.lqd-module-search-frame .ld-search-form input {
			display: inline-block;
			width: 75%;
			padding: 0.05em 0;
			border: none;
			border-bottom: 2px solid;
			background: none;
			font-family: inherit;
			font-size: 10vw;
			line-height: 1;
			color: #d17c78;
		}
		.lqd-module-search-frame .ld-search-form input::-webkit-input-placeholder {
			opacity: 0.3;
			color: #060919;
		}
		.lqd-module-search-frame .ld-search-form input::-moz-placeholder {
			opacity: 0.3;
			color: #060919;
		}
		.lqd-module-search-frame .ld-search-form input:-moz-placeholder {
			opacity: 0.3;
			color: #060919;
		}
		.lqd-module-search-frame .ld-search-form input:-ms-input-placeholder {
			opacity: 0.3;
			color: #060919;
		}
		.lqd-module-search-frame .ld-search-form input:-webkit-search-cancel-button, .lqd-module-search-frame .ld-search-form input:-webkit-search-decoration {
			-webkit-appearance: none;
		}
		.lqd-module-search-frame .ld-search-form input:-ms-clear {
			display: none;
		}
		.lqd-module-search-frame .ld-search-form input:focus {
			outline: none;
			border-color: currentColor;
		}
		.lqd-module-search-frame .lqd-module-search-info {
			font-size: 90%;
			font-weight: bold;
			display: block;
			width: 75%;
			margin: 0 auto;
			padding: 0.85em 0;
			text-align: right;
			color: #d17c78;
		}
		.lqd-module-search-frame .lqd-module-search-related {
			display: flex;
			width: 75%;
		}
		.lqd-module-search-frame .lqd-module-search-suggestion {
			width: 33.33%;
			opacity: 0;
			text-align: left;
			transform: translate3d(0, -30px, 0);
			transition: opacity 0.5s, transform 0.5s;
		}
		.lqd-module-search-frame .lqd-module-search-suggestion:nth-child(2) {
			margin: 0 3em;
		}
		.lqd-module-search-frame .lqd-module-search-suggestion h3 {
			margin: 0;
			font-size: 1.35em;
			color: inherit;
		}
		.lqd-module-search-frame .lqd-module-search-suggestion h3:before {
			content: '\\21FE';
			display: inline-block;
			padding: 0 0.5em 0 0;
		}
		.lqd-module-search-frame .lqd-module-search-suggestion p {
			font-size: 1.15em;
			line-height: 1.4;
			margin: 0.75em 0 0 0;
		}
		.lqd-module-search-frame .ld-module-dropdown {
			display: block;
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .ld-search-form-container {
			pointer-events: auto;
			opacity: 1;
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .ld-search-form-container:before, .lqd-module-search-frame .ld-module-dropdown.is-active .ld-search-form-container:after {
			transform: translate3d(0, 0, 0);
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .lqd-module-search-close {
			transform: scale3d(1, 1, 1);
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .ld-search-form {
			opacity: 1;
			transform: scale3d(1, 1, 1);
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .lqd-module-search-suggestion {
			opacity: 1;
			transform: translate3d(0, 0, 0);
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .lqd-module-search-suggestion:nth-child(2) {
			transition-delay: 0.1s;
		}
		.lqd-module-search-frame .ld-module-dropdown.is-active .lqd-module-search-suggestion:nth-child(3) {
			transition-delay: 0.2s;
		}
		.lqd-module-search-zoom-out {
			color: #cecae0;
		}
		.lqd-module-search-zoom-out .ld-search-form-container {
			display: flex;
			width: 100%;
			height: 100vh;
			position: fixed;
			top: 0;
			left: 0;
			z-index: 1000;
			border: none;
			background: none;
			flex-direction: column;
			justify-content: center;
			align-items: center;
			text-align: center;
			opacity: 0;
			transition: opacity 0.5s;
		}
		.lqd-module-search-zoom-out .ld-search-form-container:before {
			content: '';
			position: absolute;
			top: 0;
			right: 0;
			width: 100%;
			height: 100%;
			background: rgba(0, 0, 0, 0.8);
		}
		.lqd-module-search-zoom-out .lqd-module-search-close {
			position: absolute;
			top: 25px;
			right: 55px;
			font-size: 68px;
			cursor: pointer;
		}
		.lqd-module-search-zoom-out .lqd-module-search-close:hover {
			color: #fff;
		}
		.lqd-module-search-zoom-out .ld-search-form {
			margin: 5em 0;
		}
		.lqd-module-search-zoom-out .ld-search-form input {
			display: inline-block;
			width: 75%;
			padding: 0.05em 0;
			border-bottom: 5px solid;
			background: none;
			font-family: inherit;
			font-size: 10vw;
			line-height: 1;
			color: #eaba82;
			transform: scale3d(0, 1, 1);
			transform-origin: 0% 50%;
			transition: transform 0.3s;
		}
		.lqd-module-search-zoom-out .ld-search-form input::-webkit-input-placeholder {
			opacity: 1;
			color: #4a319e;
		}
		.lqd-module-search-zoom-out .ld-search-form input::-moz-placeholder {
			opacity: 1;
			color: #4a319e;
		}
		.lqd-module-search-zoom-out .ld-search-form input:-moz-placeholder {
			opacity: 1;
			color: #4a319e;
		}
		.lqd-module-search-zoom-out .ld-search-form input:-ms-input-placeholder {
			opacity: 1;
			color: #4a319e;
		}
		.lqd-module-search-zoom-out .ld-search-form input:-webkit-search-cancel-button, .lqd-module-search-zoom-out .ld-search-form input:-webkit-search-decoration {
			-webkit-appearance: none;
		}
		.lqd-module-search-zoom-out .ld-search-form input:-ms-clear {
			display: none;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion,
		.lqd-module-search-zoom-out .lqd-module-search-info {
			opacity: 0;
			transform: translate3d(0, 50px, 0);
			transition: opacity 0.4s, transform 0.4s;
		}
		.lqd-module-search-zoom-out .lqd-module-search-info {
			font-size: 90%;
			font-weight: bold;
			display: block;
			width: 75%;
			margin: 0 auto;
			padding: 0.85em 0;
			text-align: right;
			color: #eaba82;
		}
		.lqd-module-search-zoom-out .lqd-module-search-related {
			display: flex;
			width: 75%;
			text-align: left;
			pointer-events: none;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion {
			width: 50%;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion:first-child {
			padding: 0 2em 0 0;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion:last-child {
			padding: 0 0 0 2em;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion h3 {
			margin: 0;
			font-size: 1.35em;
			color: inherit;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion h3:before {
			content: '\\21FE';
			display: inline-block;
			padding: 0 0.5em 0 0;
		}
		.lqd-module-search-zoom-out .lqd-module-search-suggestion p {
			font-size: 1.15em;
			line-height: 1.4;
			margin: 0.75em 0 0 0;
		}
		.lqd-module-search-zoom-out .ld-module-dropdown {
			display: block;
			visibility: hidden;
			opacity: 0;
			transition: opacity 0.3s, visibility 0.3s;
		}
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active {
			opacity: 1;
			visibility: visible;
		}
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active .ld-search-form-container {
			opacity: 1;
		}
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active .ld-search-form input {
			transform: scale3d(1, 1, 1);
			transition-duration: 0.5s;
		}
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active .lqd-module-search-suggestion,
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active .lqd-module-search-info {
			opacity: 1;
			transform: translate3d(0, 0, 0);
		}
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active .lqd-module-search-suggestion:first-child {
			transition-delay: 0.15s;
		}
		.lqd-module-search-zoom-out .ld-module-dropdown.is-active .lqd-module-search-suggestion:nth-child(2) {
			transition-delay: 0.2s;
		}
		.module-product-search .ld-module-trigger {
			display: none;
		}
		.module-product-search .ld-module-dropdown {
			display: flex;
			height: auto !important;
			position: relative;
			top: auto;
			left: auto;
			right: auto;
			bottom: auto;
			background: none;
			z-index: auto;
			text-align: inherit;
		}
		.megamenu {
			position: static !important;
		}
		.main-nav body:not(.header-style-side) .megamenu:not(.position-applied) .nav-item-children {
			display: block !important;
			visibility: hidden;
		}
		.megamenu .megamenu-container:before, .megamenu .megamenu-container:after,
		.megamenu .megamenu-inner-row:before,
		.megamenu .megamenu-inner-row:after {
				content: none;
			}
		.megamenu .megamenu-container.container {
			padding-inline-start: 15px;
			padding-inline-end: 15px;
		}
		.megamenu .megamenu-container .container {
			width: 100%;
		}
		.megamenu .nav-item-children {
			border-radius: 0;
			padding-top: 0;
			padding-bottom: 0;
		}
		.megamenu .nav-item-children:before {
			background: none !important;
			box-shadow: none;
		}
		.megamenu .megamenu-inner-row {
			background-color: #fff;
			box-shadow: 0 16px 50px rgba(0, 0, 0, 0.07);
		}
		.megamenu .megamenu-inner-row.vc_row {
			flex-flow: row wrap;
		}
		.megamenu .megamenu-inner-row.vc_row:after {
			content: none;
		}
		.megamenu .megamenu-inner-row.vc_row-has-bg:before {
			background-color: inherit;
		}
		.megamenu .flickity-viewport {
			width: 100%;
		}
		.megamenu[data-megamenu-bg-scheme=transparent] .megamenu-inner-row {
			box-shadow: none;
		}
		.megamenu.megamenu-content-stretch .nav-item-children {
			left: 0;
			right: 0;
		}
		.megamenu.megamenu-fullwidth .nav-item-children {
			width: 100vw;
			left: 50%;
			right: 50%;
			margin-inline-start: -50vw;
			margin-inline-end: -50vw;
		}
		.megamenu.megamenu-fullwidth .megamenu-container {
			width: 100vw;
			max-width: none;
		}
		.megamenu.position-applied .megamenu-column:only-of-type {
			width: 100%;
		}
		.lqd-submenu-dark .megamenu .megamenu-inner-row {
			background-color: #030516;
		}
		.main-header[data-react-to-megamenu=true]:not(.is-stuck) .megamenu-hover-bg {
			display: inline-block;
			width: 100%;
			height: 100%;
			position: absolute;
			top: 0;
			left: 0;
			opacity: 0;
			background-color: var(--lqd-megamenu-background-color, #fff);
			transition: opacity 0.3s cubic-bezier(0.02, 0.01, 0.47, 1), background 0.3s;
		}
		.main-header[data-react-to-megamenu=true]:not(.is-stuck).megamenu-item-active .megamenu-hover-bg {
			opacity: 1;
		}
		.navbar-header {
			flex-basis: auto;
		}
		.navbar-header .mobile-logo-default,
		.navbar-header .header-module {
			display: none;
		}
		.navbar-header.hidden-lg {
			display: none !important;
		}
		.navbar-collapse {
			display: inline-flex !important;
			flex-direction: column;
			align-items: stretch;
			height: auto !important;
			flex-basis: 0;
		}
		.navbar-collapse:before, .navbar-collapse:after {
			content: none;
		}
		.navbar-collapse > .nav-trigger {
			display: none !important;
		}
		.main-nav {
			display: flex;
			align-items: stretch;
			justify-content: flex-end;
		}
		.main-nav:before, .main-nav:after {
			content: none;
		}
		.main-nav > li,
		.main-nav > li > a {
			align-items: center;
		}
		.main-nav > li:first-child {
			padding-inline-start: 0;
		}
		.main-nav > li:last-child {
			padding-inline-end: 0;
		}
		.main-nav > li.nav-item-cloned {
			display: none;
		}
		.main-nav > li > a {
			position: relative;
		}
		.main-nav .submenu-expander {
			display: none !important;
		}
		.navbar-fullscreen .main-nav.justify-content-lg-start {
			align-items: flex-start !important;
		}
		.navbar-fullscreen .main-nav.justify-content-lg-center {
			align-items: center !important;
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) .nav-item-children {
			min-width: 120px;
			box-shadow: 0 10px 35px -5px rgba(0, 0, 0, 0.05);
			border-radius: 15px;
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > .nav-item-children,
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > .nav-item-children > li {
			transform: translateY(15px);
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > a {
			z-index: 1;
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > .nav-item-children {
			padding-top: calc(var(--item-height, 100%) - var(--lqd-menu-items-top-padding, 10px) - var(--lqd-menu-items-bottom-padding, 10px) - 0.25em);
			top: var(--lqd-menu-items-top-padding, 10px);
			z-index: 3;
			white-space: nowrap;
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > .nav-item-children:before {
			left: clamp(-5px, calc(var(--lqd-menu-items-left-padding, 15px) * -1), -20px);
			right: clamp(calc(var(--lqd-menu-items-right-padding, 15px) * -1), calc((var(--lqd-menu-items-right-padding, 15px) / 2) * -1), calc(var(--lqd-menu-items-right-padding, 15px) * -1));
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > .nav-item-children > li {
			opacity: 0;
			transition: all 0.5s cubic-bezier(0.17, 0.84, 0.44, 1);
			transition-property: transform, opacity;
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu) > .nav-item-children > li > a {
			padding: 0.5em var(--lqd-menu-items-right-padding, 15px) 0.5em var(--lqd-menu-items-left-padding, 15px);
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu):hover > .nav-item-children,
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu):hover > .nav-item-children > li {
			opacity: 1;
			transform: translateY(0);
		}
		.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu):hover > a {
			z-index: 4;
			transition: color 0.3s, background 0.3s, border 0.3s, z-index 0.05s step-start;
		}
		.lqd-submenu-dark .nav-item-children:before {
			background-color: #424040;
		}
		.lqd-submenu-dark .nav-item-children > li > a {
			color: rgba(255, 255, 255, 0.8);
		}
		.lqd-submenu-dark .nav-item-children > li > a:hover {
			color: #fff;
		}
		.lqd-submenu-dark.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu):before, .lqd-submenu-dark.lqd-submenu-cover .main-nav > .menu-item-has-children:not(.megamenu):after {
			background-color: #424040;
		}
		.main-nav-hover-underline-1 > li > a:after {
			content: '';
			display: inline-block;
			width: 100%;
			height: 3px;
			position: absolute;
			bottom: 0;
			left: 0;
			background-color: currentColor;
			transform-origin: right center;
			transform: scaleX(0);
			transition: transform 0.25s cubic-bezier(0, 0, 0.2, 1);
		}
		.main-nav-hover-underline-1 > li.is-active > a:after, .main-nav-hover-underline-1 > li.active > a:after, .main-nav-hover-underline-1 > li.current_page_item > a:after, .main-nav-hover-underline-1 > li.current-menu-item > a:after, .main-nav-hover-underline-1 > li.current-menu-ancestor > a:after,
		.main-nav-hover-underline-1 > li > a:hover:after {
			transform-origin: left center;
			transform: scaleX(1);
		}
		.main-nav-hover-fade-inactive:hover > li > a {
			opacity: 0.35;
		}
		.main-nav-hover-fade-inactive:hover > li:hover > a {
			opacity: 1;
		}
		.navbar-visible-ontoggle {
			padding-inline-end: 5px;
			padding-inline-start: 5px;
		}
		.navbar-visible-ontoggle .main-nav > li {
			opacity: 0;
			visibility: hidden;
			transform: translateX(5px);
			transition: all 0.3s ease;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(1) {
			transition-delay: 0.05s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(2) {
			transition-delay: 0.1s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(3) {
			transition-delay: 0.15s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(4) {
			transition-delay: 0.2s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(5) {
			transition-delay: 0.25s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(6) {
			transition-delay: 0.3s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(7) {
			transition-delay: 0.35s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(8) {
			transition-delay: 0.4s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(9) {
			transition-delay: 0.45s;
		}
		.navbar-visible-ontoggle .main-nav > li:nth-child(10) {
			transition-delay: 0.5s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li {
			opacity: 1;
			visibility: visible;
			transform: none;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(10) {
			transition-delay: 0.05s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(9) {
			transition-delay: 0.1s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(8) {
			transition-delay: 0.15s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(7) {
			transition-delay: 0.2s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(6) {
			transition-delay: 0.25s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(5) {
			transition-delay: 0.3s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(4) {
			transition-delay: 0.35s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(3) {
			transition-delay: 0.4s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(2) {
			transition-delay: 0.45s;
		}
		.navbar-visible-ontoggle.is-active .main-nav > li:nth-child(1) {
			transition-delay: 0.5s;
		}
		.navbar-visible-ontoggle[aria-expanded=false].collapsing .main-nav > li {
			transform: translateX(-5px);
		}
		.header-style-side .main-nav {
			overflow-x: hidden;
			overflow-y: auto;
		}
		.header-style-side .main-nav > li, .header-style-side .main-nav > li:first-child, .header-style-side .main-nav > li:last-child {
			padding-inline-start: 0;
			padding-inline-end: 0;
		}
		.header-style-side .main-nav .nav-item-children {
			display: none;
			width: 100%;
			padding: 0.625em 0 0.625em 0;
			border-radius: 0;
			position: relative !important;
			top: auto !important;
			left: auto !important;
			right: auto !important;
			background-color: transparent;
			box-shadow: none;
			font-size: 16px;
			line-height: 1.5em;
			overflow-x: hidden;
			overflow-y: auto;
		}
		.header-style-side .main-nav .nav-item-children > li {
			display: block;
			width: 100%;
			font-size: 1em;
			font-weight: 400;
		}
		.header-style-side .main-nav .nav-item-children > li > a {
			padding: 0.75em 1.25em;
		}
		.header-style-side .main-nav .nav-item-children > li:hover > a {
			background-color: transparent;
		}
		.header-style-side .main-nav .nav-item-children .nav-item-children {
			padding-inline-start: 1.25em;
		}
		.header-style-side .main-nav .megamenu .nav-item-children {
			display: none;
			padding-inline-start: 1.25em;
			width: auto !important;
			left: auto !important;
			right: auto !important;
			margin-inline-start: 0 !important;
			margin-inline-end: 0 !important;
			visibility: visible;
		}
		.header-style-side .main-nav .megamenu .ld-container,
		.header-style-side .main-nav .megamenu .megamenu-column,
		.header-style-side .main-nav .megamenu .megamenu-container {
			width: 100% !important;
			padding: 0;
		}
		.header-style-side .main-nav .megamenu section.vc_row {
			padding: 0 !important;
		}
		.header-style-side .main-nav .megamenu .vc_row,
		.header-style-side .main-nav .megamenu .vc_column-inner,
		.header-style-side .main-nav .megamenu .megamenu-column,
		.header-style-side .main-nav .megamenu .wpb_wrapper {
			background: none !important;
			border: none !important;
			padding: 0 !important;
			margin: 0 !important;
			box-shadow: none !important;
		}
		.header-style-side .main-nav .megamenu .ld-row {
			display: block;
			margin: 0;
		}
		.header-style-side .main-nav .megamenu .megamenu-inner-row:before {
			content: none !important;
		}
		.header-style-side .navbar-visible-ontoggle .main-nav > li, .header-style-side .navbar-visible-ontoggle .main-nav > li:first-child, .header-style-side .navbar-visible-ontoggle .main-nav > li:last-child {
			padding-inline-start: 1.666em;
			padding-inline-end: 1.666em;
		}
		.navbar-fullscreen .main-nav {
			width: auto;
			position: relative;
			flex-grow: 0;
		}
		.navbar-fullscreen .main-nav > li {
			width: 100%;
			padding-inline-start: 0 !important;
			padding-inline-end: 0 !important;
			align-items: inherit;
			justify-content: inherit;
			position: static;
		}
		.navbar-fullscreen .main-nav > li:after {
			content: '';
			display: inline-block;
			width: 100%;
			position: absolute;
			top: 0;
			left: 100%;
			bottom: 0;
			visibility: hidden;
		}
		.navbar-fullscreen .main-nav > li > a {
			width: 100%;
			flex-grow: 0;
			font-size: 4.5vw;
			line-height: 1.1em;
			font-weight: 700;
		}
		.navbar-fullscreen .main-nav > li > a .txt {
			display: flex;
			position: relative;
		}
		.navbar-fullscreen .main-nav > li.is-active:after {
			visibility: visible;
		}
		.navbar-fullscreen .main-nav > li.is-active .nav-item-children {
			transform: translateX(0);
		}
		.navbar-fullscreen .main-nav .link-sup {
			top: 0;
			right: 0;
		}
		.navbar-fullscreen .main-nav .nav-item-children {
			width: calc(100% + 7px);
			left: 110%;
			top: 0;
			padding: 0.625em 0 0;
			background-color: transparent;
			visibility: visible;
			font-size: 16px;
			line-height: 1.5em;
			overflow-x: hidden;
			overflow-y: auto;
			transform: translateX(-10px);
		}
		.navbar-fullscreen .main-nav .nav-item-children:before {
			background: none;
			box-shadow: none;
		}
		.navbar-fullscreen .main-nav .nav-item-children > li {
			display: block;
			width: 100%;
			padding: 0.75em 1.25em;
			font-size: 1em;
			font-weight: 400;
		}
		.navbar-fullscreen .main-nav .nav-item-children .nav-item-children {
			width: 100%;
		}
		.main-nav-ver {
			flex-direction: column;
			align-items: flex-end;
		}
		.lqd-stickybar-wrap.lqd-show-onstuck {
			display: flex;
		}
		.is-stuck .lqd-stickybar-wrap.lqd-hide-onstuck {
			display: flex;
		}
		.is-stuck {
			box-shadow: -2px 3px 90px -20px rgba(0, 0, 0, 0.25);
		}
		.is-stuck .lqd-hide-onstuck {
			display: none;
		}
		.is-stuck .lqd-show-onstuck {
			display: flex;
		}
		.is-stuck.sticky-header-noshadow {
			box-shadow: none;
		}
		.lqd-show-onstuck {
			display: none;
		}
		.lqd-mobile-sec {
			display: none;
		}
	}
			
	@media screen and (max-width: {$max_media_mobile_nav}px) {
		.lqd-sticky-bg-spacer,
		.lqd-sticky-bg-wrap,
		.lqd-sticky-bg {
			height: 100%;
			min-height: 0;
			max-height: none;
			position: absolute;
			top: 0;
			left: 0;
		}
		.lqd-sticky-bg-spacer:not(.vc_row) {
			position: absolute !important;
		}
		.lqd-stack-has-prevnext-buttons #pp-nav,
		.lqd-stack-has-prevnext-buttons .lqd-stack-prevnext-wrap {
			font-size: 1em;
		}
		.lqd-stack-has-prevnext-buttons .lqd-stack-prevnext-wrap {
			display: flex;
			padding: 0 !important;
			flex-direction: row !important;
			align-items: center;
			position: fixed;
			top: auto !important;
			left: auto !important;
			right: 20px !important;
			bottom: 40px !important;
			transform: none !important;
			writing-mode: inherit;
		}
		.lqd-stack-has-prevnext-buttons .lqd-stack-prevnext-wrap button {
			margin: 0 5px !important;
		}
		.lqd-stack-has-prevnext-buttons .lqd-stack-button-label,
		.lqd-stack-has-prevnext-buttons .lqd-stack-prevnext-button {
			transform: none !important;
		}
		.lqd-stack-has-prevnext-buttons .lqd-stack-prevnext-button {
			position: relative;
			top: auto;
			bottom: auto;
			left: auto;
			right: auto;
		}
		.lqd-stack-has-prevnext-buttons .lqd-stack-prevnext-button span {
			writing-mode: inherit;
		}
		.lqd-stack-has-prevnext-buttons .lqd-back-to-top {
			display: none;
		}
		.lqd-stack-has-prevnext-buttons.lqd-stack-buttons-style-1 .lqd-stack-prevnext-wrap {
			bottom: 50px !important;
			left: 20px !important;
			justify-content: space-between;
		}
		#pp-nav {
			left: 20px;
			top: auto;
			bottom: 40px;
			right: auto !important;
			transform: none;
		}
		#pp-nav .pp-nav-ul {
			display: none !important;
		}
		#pp-nav .pp-nav-inner {
			display: flex;
			align-items: center;
			flex-direction: row;
		}
		#pp-nav .pp-nav-current,
		#pp-nav .pp-nav-total {
			width: auto;
			margin: 0 !important;
			left: auto;
		}
		#pp-nav .pp-nav-current {
			height: 1em;
			align-items: center;
			line-height: 1em;
		}
		#pp-nav .pp-nav-total {
			margin-inline-start: 1em !important;
		}
		#pp-nav .pp-nav-total:before {
			content: '|';
			padding-inline-end: 0.75em;
			transform: scaleX(1.25) skewX(-18deg);
		}
		.lqd-stack-extra {
			display: none;
		}
		.lqd-stack-page-number {
			display: none;
		}
		.lqd-custom-menu .nav-item-children {
			display: none;
			width: 100%;
			min-width: 0;
			position: relative;
			left: 0 !important;
			right: 0 !important;
			bottom: auto !important;
			top: auto !important;
			opacity: 1;
			visibility: visible;
		}
		.lqd-custom-menu .nav-item-children:before {
			border-radius: 0;
			box-shadow: none;
		}
		.lqd-custom-menu .megamenu .megamenu-container {
			width: 100% !important;
		}
		.lqd-custom-menu span.submenu-expander {
			background-color: rgba(0, 0, 0, 0.1);
		}
		.lqd-head-sec-wrap {
			display: none;
		}
		.lqd-stickybar-wrap {
			display: none;
		}
	}";

	//Return the arrary with styles to output
	return $css;
}