<?php

global $post;

$enable_parallax = liquid_helper()->get_option( 'post-parallax-enable' );
$style = liquid_helper()->get_option( 'post-style' );
$style = !empty( $style ) ? $style : 'classic';
$alt_image_src   = liquid_helper()->get_option( 'liquid-post-cover-style-image' );
$cat_before_title = $header_post_excerpt = false;
$meta_in_header = true;

if( 'minimal' == $style ) {
	$cat_before_title = true;
	$header_post_excerpt = true;
	$meta_in_header = false;
}
elseif( 'classic' == $style || 'wide' == $style ) {
	$cat_before_title = true;
}

$figure_atts = $header_atts = array();

if( in_array( $style, array( 'modern', 'modern-full-screen', 'dark' ) ) && 'on' == $enable_parallax ) {
	$figure_atts[] = $header_atts[] = 'data-parallax="true"';
	$figure_atts[] = 'data-parallax-from=\'{ "yPercent": "0" }\'';
	$figure_atts[] = 'data-parallax-to=\'{ "yPercent": "25" }\'';
	$figure_atts[] = $header_atts[] = 'data-parallax-options=\'{ "start":"top top", "scrub":"true" }\'';
	
	$header_atts[] = 'data-parallax-from=\'{ "yPercent": "0", "opacity":"1" }\'';
	$header_atts[] = 'data-parallax-to=\'{ "yPercent": "25", "opacity":"0" }\'';
}


?>
<div class="lqd-post-cover overflow-hidden">

	<?php if( has_post_thumbnail( $post->ID ) || isset( $alt_image_src['media']['id'] ) && !empty( $alt_image_src['media']['id'] ) ) { ?>
		<figure class="lqd-post-media" <?php echo implode( ' ', $figure_atts ); ?>>
		<?php
			if( isset( $alt_image_src['media']['id'] ) && !empty( $alt_image_src['media']['id'] ) ){
				echo wp_get_attachment_image( $alt_image_src['media']['id'], 'full' );
			}
			else {				
				if( 'minimal' == $style ) {
					the_post_thumbnail( 'liquid-style3-sp', array( 'itemprop' => 'url' ) );
				}
				else {
					the_post_thumbnail( 'full', array( 'itemprop' => 'url' ) );
				}
			
			} 
		?>
		</figure>
	<?php } ?>
	
	
	<span class="lqd-overlay lqd-post-cover-overlay z-index-2"></span>

	<header class="lqd-post-header entry-header" <?php echo implode( ' ', $header_atts ); ?>>

		<?php if ( $cat_before_title ) : ?>
		<div class="entry-meta">
			<div class="cat-links">
				<span><?php esc_html_e( 'Published in:', 'hub' ); ?></span>
				<?php liquid_get_category(); ?>
			</div>
		</div><!-- /.entry-meta -->
		<?php endif ?>
		
		<?php the_title( '<h1 class="entry-title">', '</h1>' ) ?>

		<?php if ( $header_post_excerpt && has_excerpt() ) : ?>
			<p class="entry-excerpt"><?php echo get_the_excerpt(); ?></p>
		<?php endif; ?>

		<?php if ( $meta_in_header ) 
			get_template_part( 'templates/blog/single/part', 'meta' );
		?>
	</header>

	<?php if ( !$meta_in_header ) 
		get_template_part( 'templates/blog/single/part', 'meta' );
	?>
</div><!-- /.lqd-post-cover -->