<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Serverless\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class ServiceOptions {
    /**
     * @param boolean $includeCredentials The include_credentials
     * @return CreateServiceOptions Options builder
     */
    public static function create($includeCredentials = Values::NONE) {
        return new CreateServiceOptions($includeCredentials);
    }

    /**
     * @param boolean $includeCredentials The include_credentials
     * @param string $friendlyName The friendly_name
     * @return UpdateServiceOptions Options builder
     */
    public static function update($includeCredentials = Values::NONE, $friendlyName = Values::NONE) {
        return new UpdateServiceOptions($includeCredentials, $friendlyName);
    }
}

class CreateServiceOptions extends Options {
    /**
     * @param boolean $includeCredentials The include_credentials
     */
    public function __construct($includeCredentials = Values::NONE) {
        $this->options['includeCredentials'] = $includeCredentials;
    }

    /**
     * The include_credentials
     * 
     * @param boolean $includeCredentials The include_credentials
     * @return $this Fluent Builder
     */
    public function setIncludeCredentials($includeCredentials) {
        $this->options['includeCredentials'] = $includeCredentials;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Serverless.V1.CreateServiceOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateServiceOptions extends Options {
    /**
     * @param boolean $includeCredentials The include_credentials
     * @param string $friendlyName The friendly_name
     */
    public function __construct($includeCredentials = Values::NONE, $friendlyName = Values::NONE) {
        $this->options['includeCredentials'] = $includeCredentials;
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * The include_credentials
     * 
     * @param boolean $includeCredentials The include_credentials
     * @return $this Fluent Builder
     */
    public function setIncludeCredentials($includeCredentials) {
        $this->options['includeCredentials'] = $includeCredentials;
        return $this;
    }

    /**
     * The friendly_name
     * 
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Serverless.V1.UpdateServiceOptions ' . implode(' ', $options) . ']';
    }
}